/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class FileRetrieval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String srcPath = "artifacts";
    private String filePatterns;
    private String destPath;
    private QuickbuildRepository repository;

    @Editable(order=100, name="Source Path", description="Specify source path to retrieve files from. This path is relative to publish directory of choosed build above.")
    @Expressions(value={"artifacts", "artifacts"})
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get source path of files to retrieve.")
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=200, name="Files To Retrieve", description="Specify patterns of files that need to be retrieved. Patterns will be matched under the <b>source path</b> specified above. Matched files will be retrieved to the <b>destination path</b> specified below. The directory structure will be preserved after retrieval.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get patterns of files to retrieve.")
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    @Editable(order=300, name="Destination Path", description="Specify destination path of retrieved files. This path is relative to workspace directory of the configuration. If left empty, the workspace directory will be assumed.")
    @Scriptable
    @ScriptApi(value="Get destination path to put retrieved files.")
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @ScriptApi(value="Get associated repository object.")
    public QuickbuildRepository getRepository() {
        return this.repository;
    }

    public FileRetrieval(QuickbuildRepository repository) {
        this.repository = repository;
    }
}

