/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

public class DependencyServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String userName;
    private String password;
    private QuickbuildRepository repository;

    @Editable(order=100, description="Specify server url. For example: <em>http://server-host-name:8810</em>")
    @Scriptable
    @NotEmpty
    @ScriptApi(value="Get url of the server.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Editable(order=200, description="Specify user name to login to the server. Server will be accessed anonymously if user name is not specified.")
    @Scriptable
    @ScriptApi(value="Get user name to login to the user. Null for anonymous access.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=300, description="Specify password for above user.")
    @Scriptable
    @Password
    @ScriptApi(value="Get password to login to the server.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ScriptApi(value="Get associated repository object.")
    public QuickbuildRepository getRepository() {
        return this.repository;
    }

    public DependencyServer(QuickbuildRepository repository) {
        this.repository = repository;
    }
}

