/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.util.StringUtils;
import java.util.List;
import java.util.Stack;
import org.dom4j.Element;

@ScriptApi(value="The revision class used by QuickBuild repository.")
public class DependencyRevision
extends Revision {
    private static final long serialVersionUID = 1L;
    private List<DependencyInfo> value;
    private boolean failDependentBuildIfIAmFailed = true;

    public DependencyRevision() {
    }

    public DependencyRevision(List<DependencyInfo> value, boolean failDependentBuildIfIAmFailed) {
        this.value = value;
        this.failDependentBuildIfIAmFailed = failDependentBuildIfIAmFailed;
    }

    @ScriptApi(value="Get value of the revision.")
    public List<DependencyInfo> getValue() {
        return this.value;
    }

    public void setValue(List<DependencyInfo> value) {
        this.value = value;
    }

    public boolean isFailDependentBuildIfIAmFailed() {
        return this.failDependentBuildIfIAmFailed;
    }

    public void setFailDependentBuildIfIAmFailed(boolean failDependentBuildIfIAmFailed) {
        this.failDependentBuildIfIAmFailed = failDependentBuildIfIAmFailed;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (DependencyInfo info : this.value) {
            buffer.append(info.toString() + "; ");
        }
        return StringUtils.stripEnd((String)buffer.toString(), (String)"; ");
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("waitForFinish").setText("true");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element valueElement = dom.getRootElement().element("value");
        String buildId = valueElement.getTextTrim();
        valueElement.clearContent();
        Element waitForFinishElement = dom.getRootElement().element("waitForFinish");
        String waitForFinish = waitForFinishElement.getTextTrim();
        waitForFinishElement.detach();
        Element dependencyInfoElement = valueElement.addElement("com.pmease.quickbuild.dependency.DependencyInfo");
        dependencyInfoElement.addElement("buildId").setText(buildId);
        dependencyInfoElement.addElement("waitForFinish").setText(waitForFinish);
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("failDependentBuildIfIAmFailed").setText("true");
    }
}

