/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.aggregationsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.aggregationsupport.FailsafeAggregation;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.setting.configuration.aggregation.AllChildrenMatcher;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.util.Collection;
import java.util.HashSet;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementationProvider(method="getImplementations")
public abstract class Aggregation
extends TypeInstance {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Aggregation.class);
    private String name;
    private String description;
    private boolean enabled = true;
    private BuildMatcher buildMatcher = new AllChildrenMatcher();

    @Editable(order=10, description="Specify name of the aggregation.")
    @Name
    @NotEmpty
    @ScriptApi(value="Get name of the aggregation.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=20, description="Specify description of the aggregation.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get description of the aggregation.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=25, description="Whether or not enable this aggregation.")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Editable(name="Tree Builds to be Aggregated", order=30, description="Specify tree builds to be aggregated. Tree builds include builds in current and all descent configurations.")
    @NotNull
    public BuildMatcher getBuildMatcher() {
        return this.buildMatcher;
    }

    public void setBuildMatcher(BuildMatcher buildMatcher) {
        this.buildMatcher = buildMatcher;
    }

    private static Collection<Class<?>> getImplementations() {
        HashSet implementations = new HashSet();
        for (AggregationSupport provider : Quickbuild.getInstance(PluginManager.class).getExtensions(AggregationSupport.class)) {
            Class<? extends Aggregation> aggregationClass = provider.getAggregationClass();
            if (aggregationClass == null) continue;
            implementations.add(aggregationClass);
        }
        return implementations;
    }

    public static Aggregation fromDOM(final Configuration configuration, VersionedDocument dom) {
        try {
            return (Aggregation)dom.toBean(new MigrationListener(){

                @Override
                public void afterMigration(Object bean) {
                    Aggregation aggregation = (Aggregation)bean;
                    Quickbuild.getInstance(ConfigurationManager.class).saveAggregation(configuration.getId(), aggregation);
                }
            });
        }
        catch (Exception e) {
            if (Context.isBackend()) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            logger.error("Error constructing aggregation from DOM.", (Throwable)e);
            FailsafeAggregation aggregation = new FailsafeAggregation();
            aggregation.setName(dom.getValue("name"));
            aggregation.setDescription(e.getClass().getSimpleName() + ":" + e.getMessage());
            return aggregation;
        }
    }

    public abstract void aggregate(Configuration var1, Build var2);
}

