/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.IdManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.extensionpoint.ChangesRecorder;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.AgentCriteriaCarrier;
import com.pmease.quickbuild.persistence.AgentQueryCarrier;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.RepositoryRuntime;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.util.SerializationHelper;

@Singleton
public class ServerServiceImpl
implements ServerService {
    @Inject
    private AgentManager agentManager;
    @Inject
    private IdManager idManager;
    @Inject
    private UserManager userManager;
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private BuildEngine buildEngine;
    @Inject
    private BuildManager buildManager;

    public ServerServiceImpl() {
        Validate.isTrue((boolean)Bootstrap.isServer());
    }

    @Override
    public int executeUpdate(byte[] carrierBytes) {
        Session session = SessionManager.getSession();
        AgentQueryCarrier carrier = (AgentQueryCarrier)SerializationHelper.deserialize(carrierBytes);
        Query query = carrier.assembleQuery(session);
        return query.executeUpdate();
    }

    @Override
    public byte[] queryList(byte[] carrierBytes) {
        AgentQueryCarrier carrier = (AgentQueryCarrier)SerializationHelper.deserialize(carrierBytes);
        Query query = carrier.assembleQuery(SessionManager.getSession());
        return SerializationHelper.serialize((Serializable)((Object)query.list()));
    }

    @Override
    public byte[] queryUniqueResult(byte[] carrierBytes) {
        AgentQueryCarrier carrier = (AgentQueryCarrier)SerializationHelper.deserialize(carrierBytes);
        Query query = carrier.assembleQuery(SessionManager.getSession());
        return SerializationHelper.serialize((Serializable)query.uniqueResult());
    }

    @Override
    public byte[] criteriaList(byte[] carrierBytes) {
        AgentCriteriaCarrier carrier = (AgentCriteriaCarrier)SerializationHelper.deserialize(carrierBytes);
        Criteria criteria = carrier.assembleCriteria(SessionManager.getSession());
        return SerializationHelper.serialize((Serializable)((Object)criteria.list()));
    }

    @Override
    public byte[] criteriaUniqueResult(byte[] carrierBytes) {
        AgentCriteriaCarrier carrier = (AgentCriteriaCarrier)SerializationHelper.deserialize(carrierBytes);
        Criteria criteria = carrier.assembleCriteria(SessionManager.getSession());
        return SerializationHelper.serialize((Serializable)criteria.uniqueResult());
    }

    @Override
    public byte[] get(Class<?> entityClass, Serializable id) {
        return SerializationHelper.serialize((Serializable)SessionManager.getSession().get(entityClass, id));
    }

    @Override
    public byte[] get(String entityName, Serializable id) {
        return SerializationHelper.serialize((Serializable)SessionManager.getSession().get(entityName, id));
    }

    @Override
    public byte[] get(Class<?> entityClass, Serializable id, LockOptions lockOptions) {
        return SerializationHelper.serialize((Serializable)SessionManager.getSession().get(entityClass, id, lockOptions));
    }

    @Override
    public byte[] get(String entityName, Serializable id, LockOptions lockOptions) {
        return SerializationHelper.serialize((Serializable)SessionManager.getSession().get(entityName, id, lockOptions));
    }

    @Override
    public byte[] load(Class<?> entityClass, Serializable id) {
        Object entity = SessionManager.getSession().load(entityClass, id);
        Hibernate.initialize((Object)entity);
        return SerializationHelper.serialize((Serializable)entity);
    }

    @Override
    public byte[] load(String entityName, Serializable id) {
        Object entity = SessionManager.getSession().load(entityName, id);
        Hibernate.initialize((Object)entity);
        return SerializationHelper.serialize((Serializable)entity);
    }

    @Override
    public byte[] load(Class<?> entityClass, Serializable id, LockOptions lockOptions) {
        Object entity = SessionManager.getSession().load(entityClass, id, lockOptions);
        Hibernate.initialize((Object)entity);
        return SerializationHelper.serialize((Serializable)entity);
    }

    @Override
    public byte[] load(String entityName, Serializable id, LockOptions lockOptions) {
        Object entity = SessionManager.getSession().load(entityName, id, lockOptions);
        Hibernate.initialize((Object)entity);
        return SerializationHelper.serialize((Serializable)entity);
    }

    @Override
    public Collection<GridNode> getBuildAgentNodes() {
        return this.agentManager.getBuildAgents();
    }

    @Override
    public GridNode getServerNode() {
        return Quickbuild.getInstance(Grid.class).getLocalNode();
    }

    @Override
    public GridNode getAgentNodeById(UUID nodeId) {
        return this.agentManager.getAgentById(nodeId);
    }

    @Override
    public GridNode getAgentNodeByAddress(String nodeAddress) {
        return this.agentManager.getAgentByAddress(nodeAddress);
    }

    @Override
    public GridNode getNodeById(UUID nodeId) {
        GridNode serverNode = this.getServerNode();
        if (serverNode.getId().equals(nodeId)) {
            return serverNode;
        }
        return this.getAgentNodeById(nodeId);
    }

    @Override
    public GridNode getNodeByAddress(String nodeAddress) {
        GridNode serverNode = this.getServerNode();
        if (serverNode.getAddress().equals(nodeAddress)) {
            return serverNode;
        }
        return this.getAgentNodeByAddress(nodeAddress);
    }

    @Override
    public GridNode getUserAgentNode(Long userId) {
        return this.agentManager.getUserAgent((User)this.userManager.load(userId));
    }

    @Override
    public void stepUpdated(Long buildId, StepPath stepPath, StepRuntime stepRuntime) {
        BuildEngine.instance.stepUpdated(buildId, stepPath, stepRuntime);
    }

    @Override
    public void stepSkipped(Long buildId, StepPath stepPath) {
        BuildEngine.instance.stepSkipped(buildId, stepPath);
    }

    @Override
    public Long getId(String name) {
        return this.idManager.getId(name);
    }

    @Override
    public void repositoryMigrated(Long configurationId, byte[] bytes) {
        this.configurationManager.saveRepository(configurationId, (Repository)SerializationHelper.deserialize(bytes));
    }

    @Override
    public void stepMigrated(Long configurationId, byte[] bytes) {
        this.configurationManager.saveStep(configurationId, (Step)SerializationHelper.deserialize(bytes));
    }

    @Override
    public RequestResult requestBuild(Long requesterId, boolean scheduled, BuildRequest request) {
        User requester = requesterId == null ? null : (User)this.userManager.load(requesterId);
        return this.buildEngine.requestBuild(requester, scheduled, request);
    }

    @Override
    public void saveVariable(Long configurationId, String varName, String varValue) {
        Configuration configuration = (Configuration)this.configurationManager.load(configurationId);
        this.configurationManager.saveVariable(configuration, varName, varValue);
    }

    @Override
    public Long getBuildId(String requestId, String nodeAddress) {
        return this.buildEngine.getBuildId(requestId, nodeAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBuildPublishDir(Long buildId) {
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(buildId);
        try {
            Context.push(build);
            String string = build.getPublishDir().getAbsolutePath();
            return string;
        }
        finally {
            Context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigurationPublishDir(Long configurationId) {
        Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(configurationId);
        try {
            Context.push(configuration);
            String string = configuration.getPublishDir().getAbsolutePath();
            return string;
        }
        finally {
            Context.pop();
        }
    }

    @Override
    public Build.Status getBuildStatus(Long buildId, String nodeAddress) {
        return BuildEngine.instance.getBuildStatus(buildId, nodeAddress);
    }

    @Override
    public void writeChanges(Long buildId, String repositoryName, List<Changeset> changes) {
        for (ChangesRecorder recorder : PluginManager.instance.getExtensions(ChangesRecorder.class)) {
            recorder.write(buildId, repositoryName, changes);
        }
    }

    @Override
    public List<Changeset> readChanges(Long buildId, String repositoryName) {
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        for (ChangesRecorder recorder : PluginManager.instance.getExtensions(ChangesRecorder.class)) {
            List<? extends Changeset> recordedChanges = recorder.read(buildId, repositoryName);
            if (recordedChanges == null) continue;
            changes.addAll(recordedChanges);
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listArtifacts(Long buildId, String dir, String patterns) {
        Build build = (Build)BuildManager.instance.load(buildId);
        Context.push(build);
        ArrayList<String> artifacts = new ArrayList<String>();
        try {
            File publishDir = build.getPublishDir();
            for (File file : FileUtils.listFiles(new File(publishDir, dir), patterns)) {
                if (!file.isFile()) continue;
                artifacts.add(FileUtils.getRelativePath(file.getAbsolutePath(), publishDir.getAbsolutePath()).substring(1));
            }
            ArrayList<String> arrayList = artifacts;
            return arrayList;
        }
        finally {
            Context.pop();
        }
    }

    @Override
    public boolean hasPermission(String userName, String password, Long configurationId, String permission) {
        User user = userName != null && password != null ? SecurityHelper.authenticate(userName, password, null) : null;
        return SecurityHelper.hasPermission(user, (Configuration)ConfigurationManager.instance.load(configurationId), permission);
    }

    @Override
    public boolean hasPermission(Long userId, Long configurationId, String permission) {
        User user = (User)UserManager.instance.load(userId);
        return SecurityHelper.hasPermission(user, (Configuration)ConfigurationManager.instance.load(configurationId), permission);
    }

    @Override
    public void cancelBuildRequest(String requestId) {
        this.buildEngine.cancelRequest(requestId);
    }

    @Override
    public void cancelBuildRequest(String initiatingRequestId, String requestId) {
        this.buildEngine.cancelRequest(initiatingRequestId, requestId);
    }

    @Override
    public Object getPreviousRepositoryRuntimeCustomData(Long buildId, String repositoryName) {
        Build previousBuild = this.buildManager.getPrevious((Build)this.buildManager.load(buildId));
        if (previousBuild == null) {
            return null;
        }
        RepositoryRuntime runtime = previousBuild.getRepositoryRuntimes().get(repositoryName);
        if (runtime != null) {
            return runtime.getCustomData();
        }
        return null;
    }

    @Override
    public Object getPreviousStepRuntimeCustomData(Long buildId, String stepPathName) {
        Build previousBuild = this.buildManager.getPrevious((Build)this.buildManager.load(buildId));
        if (previousBuild == null) {
            return null;
        }
        StepRuntime runtime = previousBuild.getStepRuntimes().get(stepPathName);
        if (runtime != null) {
            return runtime.getCustomData();
        }
        return null;
    }

    @Override
    public void saveRepositoryRuntimeCustomData(Long buildId, String repositoryName, Object customData) {
        Build build = (Build)this.buildManager.load(buildId);
        RepositoryRuntime runtime = build.getRepositoryRuntimes().get(repositoryName);
        Validate.notNull((Object)runtime);
        runtime.setCustomData(customData);
        this.buildManager.save(build);
    }

    @Override
    public Long getConfigurationId(String configurationPath) {
        Configuration configuration = this.configurationManager.get(configurationPath);
        if (configuration != null) {
            return configuration.getId();
        }
        return null;
    }

    @Override
    public Resource getResource(String resourceName) {
        return CacheManager.instance.getResource(resourceName);
    }

    @Override
    public void audit(Long userId, String source, String action, String content, String previousContent) {
        User user;
        String userName = null;
        if (userId != null && (user = CacheManager.instance.getUser(userId)) != null) {
            userName = user.getDisplayName();
        }
        AuditManager.instance.audit(userName, source, action, content, previousContent);
    }
}

