/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class SearchCriteria
implements Serializable {
    private Criterion[] criterions = new Criterion[0];
    private Order[] orders = new Order[0];

    public SearchCriteria() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchCriteria of(Criterion[] criterions, Order[] orders) {
        return new SearchCriteria(criterions, orders);
    }

    public static SearchCriteria of(Criterion ... criterions) {
        return new SearchCriteria(criterions, new Order[0]);
    }

    public SearchCriteria(Criterion[] criterions, Order[] orders) {
        this.criterions = criterions;
        this.orders = orders;
    }

    public SearchCriteria(Criterion[] criterions) {
        this(criterions, new Order[0]);
    }

    public Criterion[] getCriterions() {
        return this.criterions;
    }

    public void setCriterions(Criterion[] criterions) {
        this.criterions = criterions;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrders(Order[] orders) {
        this.orders = orders;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.criterions != null) {
            for (Criterion criterion : this.criterions) {
                sb.append(criterion.toString()).append(", ");
            }
        }
        if (this.orders != null) {
            for (Criterion criterion : this.orders) {
                sb.append(criterion.toString()).append(", ");
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private List<Criterion> criterions = Lists.newArrayList();
        private List<Order> orders = Lists.newArrayList();

        public Builder add(SearchCriteria other) {
            if (other == null) {
                return this;
            }
            for (Criterion criterion : other.criterions) {
                this.add(criterion);
            }
            for (Criterion criterion : other.orders) {
                this.add((Order)criterion);
            }
            return this;
        }

        public Builder add(Criterion criterion) {
            if (criterion != null) {
                this.criterions.add(criterion);
            }
            return this;
        }

        public Builder or(Criterion ... criterions) {
            if (criterions == null || criterions.length == 0) {
                return this;
            }
            LogicalExpression or = null;
            Criterion pre = null;
            for (Criterion each : criterions) {
                if (each == null) continue;
                if (pre == null) {
                    pre = each;
                    continue;
                }
                or = Restrictions.or((Criterion)pre, (Criterion)each);
            }
            if (or == null) {
                this.add(pre);
            } else {
                this.add((Criterion)or);
            }
            return this;
        }

        public Builder add(Order order) {
            if (this.orders != null) {
                this.orders.add(order);
            }
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria((Criterion[])Iterables.toArray(this.criterions, Criterion.class), (Order[])Iterables.toArray(this.orders, Order.class));
        }
    }
}

