/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.persistence.PersistenceNamingStrategy;
import com.pmease.quickbuild.persistence.SessionFactoryProvider;
import com.pmease.quickbuild.persistence.SessionInterceptor;
import com.pmease.quickbuild.pluginsupport.DefaultPluginManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.MainFilter;
import com.pmease.quickbuild.web.MainServlet;
import com.pmease.quickbuild.web.WicketConfig;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.WicketServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.NamingStrategy;

public class QuickbuildModule
extends AbstractModule {
    private EventBus eventBus = new EventBus("QuickBuild Application");

    protected void configure() {
        this.bind(PluginManager.class).to(DefaultPluginManager.class);
        this.bind(SessionFactory.class).toProvider(SessionFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(NamingStrategy.class).to(PersistenceNamingStrategy.class);
        this.bind(WicketServlet.class).to(MainServlet.class);
        this.bind(WicketFilter.class).to(MainFilter.class);
        this.bind(WebApplication.class).to(WicketConfig.class);
        this.bind(ServletContextHandler.class).toProvider((Provider)new Provider<ServletContextHandler>(){

            public ServletContextHandler get() {
                return Quickbuild.getInstance().getServletContext();
            }
        });
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(SessionAware.class), new MethodInterceptor[]{new SessionInterceptor()});
        this.bind(EventBus.class).toInstance((Object)this.eventBus);
    }
}

