/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.QuickbuildModule;
import com.pmease.quickbuild.RemotingProxyFactory;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.ServerServlet;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.bootstrap.AgentUpdater;
import com.pmease.quickbuild.bootstrap.BootAction;
import com.pmease.quickbuild.bootstrap.BootActionSupport;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.bootstrap.ConnectResult;
import com.pmease.quickbuild.bootstrap.ConnectService;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.equinoxadapter.EquinoxAdapter;
import com.pmease.quickbuild.extensionpoint.NodeCharacteristicsPopulator;
import com.pmease.quickbuild.grid.AgentConnectivityTask;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.AgentUpdateServlet;
import com.pmease.quickbuild.grid.ConnectServlet;
import com.pmease.quickbuild.grid.FileTransferServlet;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.NodeServlet;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.grid.cloud.ProfileTestTask;
import com.pmease.quickbuild.log.LivelogManager;
import com.pmease.quickbuild.maintenance.SystemCareTask;
import com.pmease.quickbuild.migration.MainMigrator;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.migration.qb1.Qb1Migrator;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionFactoryProvider;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.AbstractPluginModule;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.rest.RestServlet;
import com.pmease.quickbuild.security.TrustAllSSLSocketFactory4HC;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.DbUtils;
import com.pmease.quickbuild.util.DependencyHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.AssetPack;
import com.pmease.quickbuild.web.AssetServlet;
import com.pmease.quickbuild.web.BatchDownloadServlet;
import com.pmease.quickbuild.web.DownloadServlet;
import com.pmease.quickbuild.web.GzipServletWrapper;
import com.pmease.quickbuild.web.LogRequestServlet;
import com.pmease.quickbuild.web.RssFeedServlet;
import com.pmease.quickbuild.web.chart.ChartManager;
import com.pmease.quickbuild.web.chart.ChartServlet;
import com.pmease.quickbuild.web.component.wizard.WizardStep;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.app.Velocity;
import org.apache.wicket.protocol.http.WicketServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi
public class Quickbuild
implements BootActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(Quickbuild.class);
    public static Injector injector;
    private List<WizardStep> setupSteps = Collections.synchronizedList(new ArrayList());
    private volatile boolean systemReady = false;
    private volatile boolean connected = false;
    private Server jettyServer;
    private ServletContextHandler servletContext;
    private volatile Thread agentConnectivityThread;
    private volatile Thread cloudProfileTestThread;
    private ReadWriteLock stopLock = new ReentrantReadWriteLock();
    private ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private volatile boolean restart;
    private volatile String specifiedNodeIp;
    private static volatile Quickbuild instance;

    public String getSpecifiedNodeIp() {
        return this.specifiedNodeIp;
    }

    public void start() {
        Properties nodeProps = BootstrapUtils.loadProps((File)new File(Bootstrap.installDir, "conf/node.properties"));
        String specifiedNodeIp = nodeProps.getProperty("ip");
        if (StringUtils.isBlank((String)specifiedNodeIp)) {
            specifiedNodeIp = null;
        }
        this.specifiedNodeIp = specifiedNodeIp;
        if (Bootstrap.bootAction == null) {
            File log4jPropsFile = new File(Bootstrap.installDir, "conf/log4j.properties");
            Properties log4jProps = BootstrapUtils.loadProps((File)log4jPropsFile);
            log4jProps.setProperty("log4j.appender.file.File", new File(Bootstrap.installDir, "logs/quickbuild.log").getAbsolutePath());
            log4jProps.setProperty("log4j.appender.console", "com.pmease.quickbuild.log.SecretAwareConsoleAppender");
            log4jProps.setProperty("log4j.appender.file", "com.pmease.quickbuild.log.SecretAwareFileAppender");
            PropertyConfigurator.configure((Properties)log4jProps);
        }
        if (this.isAgent()) {
            File agentConfigFile = new File(Bootstrap.getConfigDir(), "wrapper.conf");
            List<String> agentConfigLines = FileUtils.readFileAsLines(agentConfigFile);
            Iterator<String> it = agentConfigLines.iterator();
            while (it.hasNext()) {
                if (!it.next().contains("wrapper.restart.reload_configuration")) continue;
                it.remove();
            }
            agentConfigLines.add("wrapper.restart.reload_configuration=TRUE");
            FileUtils.writeFile(agentConfigFile, agentConfigLines);
            int updated = 0;
            if (this.updateBootstrapLib("servlet-api-3.0.20100224.jar", "javax.servlet.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("jul-to-slf4j-1.7.2.jar", "jul-to-slf4j.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("slf4j-api-1.7.2.jar", "slf4j-api.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("slf4j-log4j12-1.7.2.jar", "slf4j-log4j12.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("hessian-4.0.38.jar", "hessian.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("commons-codec-1.10.jar", "commons-codec.+?jar")) {
                ++updated;
            }
            if (this.updateBootstrapLib("joda-time-2.7.jar", "joda-time.+?jar")) {
                ++updated;
            }
            if (updated > 0) {
                this.restart = true;
                Bootstrap.restart();
                while (this.restart) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                return;
            }
        }
        instance = this;
        Modules.OverriddenModuleBuilder builder = Modules.override((Module[])new Module[]{new QuickbuildModule()});
        for (AbstractPluginModule module : DependencyHelper.sortDependencies(this.loadPluginModules())) {
            builder = Modules.override((Module[])new Module[]{builder.with(new Module[]{module})});
        }
        injector = Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{builder.with(new Module[]{new AbstractModule(){

            protected void configure() {
            }
        }})});
        this.startJettyServer();
        try {
            if (this.isServer()) {
                this.startServer();
            } else {
                this.startAgent();
            }
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
        this.systemReady = true;
    }

    private String getBindAddress() {
        Properties nodeProps = BootstrapUtils.loadProps((File)new File(Bootstrap.installDir, "conf/node.properties"));
        String bindAddress = nodeProps.getProperty("bindAddress");
        if (StringUtils.isNotBlank((String)bindAddress)) {
            return bindAddress.trim();
        }
        return null;
    }

    private void startJettyServer() {
        this.jettyServer = new Server();
        SocketConnector socketConnector = null;
        int port = this.getPort();
        if (port != 0) {
            socketConnector = new SocketConnector();
            socketConnector.setPort(port);
            socketConnector.setRequestHeaderSize(32768);
            String bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                socketConnector.setHost(bindAddress);
            }
            this.jettyServer.addConnector((Connector)socketConnector);
        }
        SslSocketConnector sslSocketConnector = null;
        int sslPort = this.getSSLPort();
        if (sslPort != 0) {
            File excludedProtocolsFile;
            File excludedCiphersFile;
            sslSocketConnector = new SslSocketConnector();
            sslSocketConnector.setPort(sslPort);
            String keystorePath = System.getProperty("org.eclipse.equinox.http.jetty.ssl.keystore");
            String keystorePassword = System.getProperty("org.eclipse.equinox.http.jetty.ssl.password");
            String keystoreKeyPassword = System.getProperty("org.eclipse.equinox.http.jetty.ssl.keypassword");
            sslSocketConnector.setKeystore(keystorePath);
            sslSocketConnector.setPassword(keystorePassword);
            sslSocketConnector.setKeyPassword(keystoreKeyPassword);
            sslSocketConnector.setRequestHeaderSize(32768);
            String bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                sslSocketConnector.setHost(bindAddress);
            }
            if ((excludedCiphersFile = new File(Bootstrap.installDir, "conf/ciphers.excluded")).exists()) {
                ArrayList<String> excludedCiphers = new ArrayList<String>();
                for (String line : FileUtils.readFileAsLines(excludedCiphersFile)) {
                    if (line.trim().length() == 0) continue;
                    excludedCiphers.add(line.trim());
                }
                if (!excludedCiphers.isEmpty()) {
                    sslSocketConnector.getSslContextFactory().setExcludeCipherSuites(excludedCiphers.toArray(new String[0]));
                }
            }
            if ((excludedProtocolsFile = new File(Bootstrap.installDir, "conf/protocols.excluded")).exists()) {
                ArrayList<String> excludedProtocols = new ArrayList<String>();
                for (String line : FileUtils.readFileAsLines(excludedProtocolsFile)) {
                    if (line.trim().length() == 0) continue;
                    excludedProtocols.add(line.trim());
                }
                if (!excludedProtocols.isEmpty()) {
                    sslSocketConnector.getSslContextFactory().setExcludeProtocols(excludedProtocols.toArray(new String[0]));
                }
            }
            this.jettyServer.addConnector((Connector)sslSocketConnector);
        }
        this.servletContext = new ServletContextHandler((HandlerContainer)this.jettyServer, "/", 1);
        this.servletContext.setClassLoader(Quickbuild.class.getClassLoader());
        this.servletContext.getSessionHandler().getSessionManager().setMaxInactiveInterval(1800);
        Map initParams = this.servletContext.getInitParams();
        if (port != 0) {
            initParams.put("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID_" + port);
        } else {
            initParams.put("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID_" + sslPort);
        }
        this.servletContext.addFilter(DisableTraceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/404");
        this.servletContext.setErrorHandler((ErrorHandler)errorHandler);
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)this.servletContext);
        this.jettyServer.setHandler((Handler)handlers);
        handlers.setServer(this.jettyServer);
        File xmlFile = new File(Bootstrap.bootDir, "conf/jetty.xml");
        if (xmlFile.exists()) {
            try {
                XmlConfiguration jettyConf = new XmlConfiguration(xmlFile.toURI().toURL());
                jettyConf.getIdMap().put("Handlers", handlers);
                if (socketConnector != null) {
                    jettyConf.getIdMap().put("SocketConnector", socketConnector);
                }
                if (sslSocketConnector != null) {
                    jettyConf.getIdMap().put("SslSocketConnector", sslSocketConnector);
                }
                jettyConf.configure((Object)this.jettyServer);
            }
            catch (Exception e) {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public ServletContextHandler getServletContext() {
        return this.servletContext;
    }

    public void stop() {
        if (this.restart) {
            this.restart = false;
            return;
        }
        AlertManager.instance.stop();
        logger.info("Stopping plugin manager...");
        ((PluginManager)injector.getInstance(PluginManager.class)).stop();
        if (this.isServer()) {
            logger.info("Stopping QuickBuild server...");
        } else {
            logger.info("Stopping QuickBuild agent...");
        }
        if (BuildEngine.instance.isStarted()) {
            logger.info("Stopping build engine...");
            BuildEngine.instance.shutdown();
        }
        while (this.agentConnectivityThread != null && this.agentConnectivityThread.isAlive()) {
            this.agentConnectivityThread.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        while (this.cloudProfileTestThread != null && this.cloudProfileTestThread.isAlive()) {
            this.cloudProfileTestThread.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.isAgent()) {
            try {
                logger.info("Disconnecting from server...");
                RemotingProxyFactory factory = new RemotingProxyFactory(Bootstrap.getAgentToken());
                ConnectService connectService = (ConnectService)factory.create(ConnectService.class, Bootstrap.serverUrl + "/service/connect");
                connectService.disconnect(this.getPort(), this.specifiedNodeIp);
            }
            catch (Throwable throwable) {
                logger.error("Failed to notify server.", throwable);
            }
            logger.info("Waiting for finish of existing jobs...");
            while (Grid.instance.hasJobs()) {
                try {
                    Thread.sleep(1000L);
                    System.gc();
                }
                catch (InterruptedException e) {}
            }
        }
        this.stopLock.writeLock().lock();
        try {
            logger.info("Stopping plugins...");
            Quickbuild.getInstance(PluginManager.class).stop();
            if (TaskScheduler.instance.isStarted()) {
                logger.info("Stopping task scheduler...");
                TaskScheduler.instance.shutdown();
            }
            if (((SessionFactoryProvider)injector.getProvider(SessionFactoryProvider.class).get()).isCreated()) {
                logger.info("Closing session factory...");
                Quickbuild.getInstance(SessionFactory.class).close();
            }
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                DriverManager.deregisterDriver(drivers.nextElement());
            }
            File h2lock = new File(this.getInstallDir(), "sampledb/quickbuild.lock.db");
            if (h2lock.exists()) {
                FileUtils.deleteFile(h2lock);
            }
            this.jettyServer.stop();
            if (this.isServer()) {
                logger.info("QuickBuild server stopped.");
            } else {
                logger.info("QuickBuild agent stopped.");
            }
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            this.stopLock.writeLock().unlock();
        }
    }

    private Map<String, AbstractPluginModule> loadPluginModules() {
        HashMap<String, AbstractPluginModule> pluginModules = new HashMap<String, AbstractPluginModule>();
        for (Map.Entry entry : EquinoxAdapter.pluginLocations.entrySet()) {
            String pluginId = (String)entry.getKey();
            if (pluginId.equals("com.pmease.quickbuild") || pluginId.equals("com.pmease.quickbuild.equinoxadapter")) continue;
            Manifest mf = EquinoxAdapter.findManifest((File)((File)entry.getValue()));
            Preconditions.checkNotNull((Object)mf);
            Attributes attrs = mf.getMainAttributes();
            String moduleClassName = attrs.getValue("Bundle-Activator");
            try {
                if (moduleClassName != null) {
                    AbstractPluginModule pluginModule;
                    final Class<?> moduleClass = this.getClass().getClassLoader().loadClass(moduleClassName);
                    if (AbstractPluginModule.class.isAssignableFrom(moduleClass)) {
                        pluginModule = (AbstractPluginModule)moduleClass.newInstance();
                    } else if (Plugin.class.isAssignableFrom(AbstractPlugin.class)) {
                        pluginModule = new AbstractPluginModule(){

                            @Override
                            protected Class<? extends AbstractPlugin> getPluginClass() {
                                return moduleClass;
                            }
                        };
                    } else {
                        throw new RuntimeException("Plugin activator should be defined as a sub class of '" + AbstractPluginModule.class.getName() + "'.");
                    }
                    pluginModule.setPluginId(pluginId);
                    pluginModule.setPluginName(attrs.getValue("Bundle-Name"));
                    pluginModule.setPluginVendor(attrs.getValue("Bundle-Vendor"));
                    pluginModule.setPluginVersion(attrs.getValue("Bundle-Version"));
                    HashSet<String> dependencies = new HashSet<String>();
                    String required = attrs.getValue("Require-Bundle");
                    if (required != null) {
                        for (String partial : required.split(",")) {
                            if ((partial = partial.trim()).length() == 0) continue;
                            int pos = partial.indexOf(59);
                            if (pos != -1) {
                                partial = partial.substring(0, pos).trim();
                            }
                            if (partial.equals("com.pmease.quickbuild.bootstrap") || partial.equals("com.pmease.quickbuild.equinoxadapter") || partial.equals("com.pmease.quickbuild") || partial.equals("com.pmease.quickbuild.libs")) continue;
                            if (!EquinoxAdapter.pluginLocations.containsKey(partial)) {
                                throw new RuntimeException("Plugin '" + pluginId + " requires non-existant plugin '" + partial + "'");
                            }
                            dependencies.add(partial);
                        }
                    }
                    pluginModule.setPluginDependencies(dependencies);
                    pluginModules.put(pluginId, pluginModule);
                    continue;
                }
                throw new RuntimeException("Plugin activator class should be defined as a sub class of '" + AbstractPluginModule.class.getName() + "'.");
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading plugin '" + pluginId + "'.", e);
            }
        }
        return pluginModules;
    }

    private void startAgent() throws Exception {
        logger.info("Starting QuickBuild agent...");
        logger.info("Initializing velocity...");
        Properties props = FileUtils.loadProps(new File(Bootstrap.installDir, "asset/velocity.properties"));
        props.setProperty("file.resource.loader.path", Bootstrap.installDir.getAbsolutePath() + "/asset");
        Velocity.init((Properties)props);
        Object servlet = new NodeServlet();
        injector.injectMembers(servlet);
        this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/service/node/*");
        GridNode localNode = Grid.instance.getLocalNode();
        while (true) {
            try {
                RemotingProxyFactory factory = new RemotingProxyFactory(Bootstrap.getAgentToken());
                ConnectService connectService = (ConnectService)factory.create(ConnectService.class, Bootstrap.serverUrl + "/service/connect");
                connectService.connect(localNode.getPort(), localNode.isOverSSL(), this.specifiedNodeIp, localNode.getHostName(), localNode.getBenchmark(), localNode.getId(), null);
            }
            catch (Throwable throwable) {
                if (this.handleConnectException(throwable)) {
                    return;
                }
                try {
                    Thread.sleep(Bootstrap.heartbeatInterval * 1000);
                }
                catch (InterruptedException e) {}
                continue;
            }
            break;
        }
        logger.info("Starting plugins...");
        Quickbuild.getInstance(PluginManager.class).start();
        GridNode agentNode = Grid.instance.getLocalNode();
        for (NodeCharacteristicsPopulator each : PluginManager.instance.getExtensions(NodeCharacteristicsPopulator.class)) {
            each.populate(agentNode.getCharacteristics().getExtraCharacteristics());
        }
        servlet = new FileTransferServlet();
        injector.injectMembers(servlet);
        this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/file_transfer/*");
        servlet = new DownloadServlet();
        injector.injectMembers(servlet);
        this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/download/*");
        servlet = new BatchDownloadServlet();
        injector.injectMembers(servlet);
        this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/batch_download/*");
        TaskScheduler.instance.schedule(LivelogManager.instance);
        TaskScheduler.instance.schedule(NodeService.instance);
        TaskScheduler.instance.schedule(Grid.instance);
        this.agentConnectivityThread = new Thread(new AgentConnectivityTask());
        this.agentConnectivityThread.setPriority(10);
        this.agentConnectivityThread.start();
        logger.info("QuickBuild agent started.");
    }

    private void startServer() throws Exception {
        logger.info("Starting QuickBuild server...");
        final BootAction bootAction = Bootstrap.bootAction;
        if (bootAction != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        bootAction.execute((BootActionSupport)Quickbuild.this);
                    }
                    catch (Throwable e) {
                        bootAction.setException(e);
                    }
                    BootAction bootAction2 = bootAction;
                    synchronized (bootAction2) {
                        bootAction.notify();
                    }
                }
            }).start();
        } else {
            logger.info("Initializing velocity...");
            Properties props = FileUtils.loadProps(new File(Bootstrap.installDir, "asset/velocity.properties"));
            props.setProperty("file.resource.loader.path", Bootstrap.installDir.getAbsolutePath() + "/asset");
            Velocity.init((Properties)props);
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", TrustAllSSLSocketFactory4HC.getDefault(), 443));
            this.servletContext.addServlet(AssetServlet.class, "/images/*");
            this.servletContext.addServlet(AssetServlet.class, "/jquery/*");
            this.servletContext.addServlet(AssetServlet.class, "/scripts/*");
            this.servletContext.addServlet(AssetServlet.class, "/styles/*");
            this.servletContext.addServlet(AssetServlet.class, "/robots.txt");
            this.servletContext.addServlet(AssetServlet.class, "/asset/*");
            for (AssetPack pack : BasePage.ASSET_PACKS) {
                pack.registerHandler(this.servletContext);
            }
            this.servletContext.addServlet(new ServletHolder((Servlet)new GzipServletWrapper((Servlet)Quickbuild.getInstance(WicketServlet.class))), "/");
            logger.info("Checking data version...");
            String version = MigrationHelper.getVersion(MainMigrator.class);
            String dataVersion = DbUtils.getDataVersion();
            if (dataVersion != null && !dataVersion.equals(version)) {
                throw new QuickbuildException("Data version mismatch (database data version:" + dataVersion + ", application data version:" + version + "). " + "Please follow instructions in the upgrade guide to upgrade the database.");
            }
            logger.info("Checking data...");
            this.setupSteps.addAll(DataManager.instance.initialize());
            if (!this.setupSteps.isEmpty()) {
                String url = this.getPort() != 0 ? "http://" + InetAddress.getLocalHost().getHostName() + ":" + this.getPort() : "https://" + InetAddress.getLocalHost().getHostName() + ":" + this.getSSLPort();
                logger.warn("Please point your browser to '" + url + "' to set up the server");
                do {
                    Thread.sleep(100L);
                } while (!this.setupSteps.isEmpty());
            }
            logger.info("Initializing caches...");
            CacheManager.instance.initialize();
            logger.info("Starting plugins...");
            Quickbuild.getInstance(PluginManager.class).start();
            GridNode serverNode = Grid.instance.getLocalNode();
            for (NodeCharacteristicsPopulator each : PluginManager.instance.getExtensions(NodeCharacteristicsPopulator.class)) {
                each.populate(serverNode.getCharacteristics().getExtraCharacteristics());
            }
            Object servlet = new NodeServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/service/node/*");
            servlet = new FileTransferServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/file_transfer/*");
            servlet = new DownloadServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/download/*");
            servlet = new BatchDownloadServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/batch_download/*");
            servlet = new ChartServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/chart/*");
            servlet = new ConnectServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/service/connect/*");
            servlet = new AgentUpdateServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/agent_update/*");
            servlet = new ServerServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/service/server/*");
            servlet = new RestServlet();
            ServletHolder holder = new ServletHolder((Servlet)servlet);
            holder.setInitParameter("javax.ws.rs.Application", "com.pmease.quickbuild.rest.RestModule");
            this.servletContext.addServlet(holder, "/rest/*");
            servlet = new LogRequestServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/log_request/*");
            servlet = new RssFeedServlet();
            injector.injectMembers(servlet);
            this.servletContext.addServlet(new ServletHolder((Servlet)servlet), "/rss_feed/*");
            logger.info("Starting build engine...");
            BuildEngine.instance.startup();
            logger.info("Starting alert service...");
            AlertManager.instance.start();
            try {
                logger.info("Scheduling system tasks...");
                TaskScheduler.instance.schedule(ChartManager.instance);
                TaskScheduler.instance.schedule(CacheManager.instance);
                TaskScheduler.instance.schedule(LivelogManager.instance);
                TaskScheduler.instance.schedule(NodeService.instance);
                TaskScheduler.instance.schedule(Grid.instance);
                TaskScheduler.instance.schedule(BuildEngine.instance);
                TaskScheduler.instance.schedule(new SchedulableTask(){

                    @Override
                    public void execute() {
                        BuildEngine.instance.terminateIdleBuildAgents();
                    }

                    @Override
                    public Schedule getSchedule() {
                        PeriodicalSchedule schedule = new PeriodicalSchedule();
                        schedule.setRepeatInterval("60");
                        return schedule;
                    }
                });
                SystemCareTask.schedule();
                DataManager.instance.scheduleBackup();
                logger.info("Scheduling builds...");
                BuildEngine.instance.scheduleAll();
            }
            catch (Exception e) {
                logger.error("Error scheduling tasks...", (Throwable)e);
            }
            this.agentConnectivityThread = new Thread(new AgentConnectivityTask());
            this.agentConnectivityThread.start();
            this.cloudProfileTestThread = new Thread(new ProfileTestTask());
            this.cloudProfileTestThread.start();
            logger.info("QuickBuild server started.");
            logger.info("You can now point browser to '" + this.getUrl() + "' to access the server.");
            if (System.getProperty("reset") != null) {
                User root = (User)UserManager.instance.load(User.ROOT_ID);
                root.setPassword(StringUtils.hash("12345"));
                root.setAuthenticator(null);
                UserManager.instance.save(root);
                logger.warn("Password of root user '" + root.getName() + "' has been reset to '12345'.");
            }
        }
    }

    public static Quickbuild getInstance() {
        return instance;
    }

    public static <T> T getInstance(Class<T> clazz) {
        return (T)injector.getInstance(clazz);
    }

    public static CacheManager getCacheManager() {
        if (!Bootstrap.isServer()) {
            throw new QuickbuildException("Cache manager can only be used at server side.");
        }
        return Quickbuild.getInstance(CacheManager.class);
    }

    @ScriptApi(value="Get URL of the QuickBuild server.")
    public String getUrl() {
        String url = SettingManager.instance.getSystemSetting().getUrl();
        url = url != null ? StringUtils.stripEnd((String)url, (String)"/") : (this.getPort() != 0 ? "http://" + Bootstrap.getHostName() + ":" + this.getPort() : "https://" + Bootstrap.getHostName() + ":" + this.getSSLPort());
        return url;
    }

    @ScriptApi(value="Get host name of the node.")
    public String getHostName() {
        return Bootstrap.getHostName();
    }

    @ScriptApi(value="Get IP address of the node.")
    public String getIp() {
        return Bootstrap.nodeIp;
    }

    @ScriptApi(value="Get port number of the node.")
    public int getPort() {
        return Bootstrap.getPort();
    }

    @ScriptApi(value="Get SSL port number of the node.")
    public int getSSLPort() {
        return Bootstrap.getSSLPort();
    }

    @ScriptApi(value="Whether or not current node is an agent node.")
    public boolean isAgent() {
        return Bootstrap.isAgent();
    }

    @ScriptApi(value="Whether or not current node is an user agent node.")
    public boolean isUserAgent() {
        return Bootstrap.isUserAgent();
    }

    @ScriptApi(value="Whether or not current node is a build agent node.")
    public boolean isBuildAgent() {
        return Bootstrap.isBuildAgent();
    }

    @ScriptApi(value="Whether or not current node is server node.")
    public boolean isServer() {
        return Bootstrap.isServer();
    }

    public List<WizardStep> getSetupSteps() {
        return this.setupSteps;
    }

    @ScriptApi(value="Get URL displaying the server log")
    public String getLogUrl() {
        return this.getUrl() + "/log";
    }

    public boolean isSystemReady() {
        return this.systemReady;
    }

    public void getVersion(String[] version) {
        version[0] = MigrationHelper.getVersion(MainMigrator.class);
        version[1] = DbUtils.getDataVersion();
    }

    public void exportData(File toDir) {
        DataManager.instance.exportData(toDir, false, false, false, false);
    }

    public void importData(File fromDir) {
        DataManager.instance.importData(fromDir);
    }

    public void migrateData(File dataDir) {
        MainMigrator.migrate(dataDir);
    }

    public void clearDatabase() {
        DataManager.instance.clearDatabase();
    }

    public void migrateQb1(File qb1Dir, File dataDir, File storageDir) {
        Qb1Migrator.toVersion1(qb1Dir, dataDir, storageDir);
        MainMigrator.migrate(dataDir);
    }

    @ScriptApi(value="Get the global storage directory.")
    public File getStorageDir() {
        if (this.isServer()) {
            return new File(CacheManager.instance.getSystemSetting().getStoragePath());
        }
        return new File(Bootstrap.installDir, "storage");
    }

    @ScriptApi(value="Get the global workspace directory.")
    public File getWorkspaceDir() {
        return new File(Bootstrap.installDir, "workspace");
    }

    @ScriptApi(value="Get installation directory of QuickBuild application. If called at agent side, this directory returns installation directory of agent.")
    public File getInstallDir() {
        return Bootstrap.installDir;
    }

    @ScriptApi(value="Get configuration manager which responsible for loading configurations.")
    public ConfigurationManager getConfigurationManager() {
        return ConfigurationManager.instance;
    }

    @ScriptApi(value="Get agent manager which is used to manage build and user agents.")
    public AgentManager getAgentManager() {
        return AgentManager.instance;
    }

    @ScriptApi(value="Get build manager which responsible for loading builds.")
    public BuildManager getBuildManager() {
        return BuildManager.instance;
    }

    @ScriptApi(value="Get build engine instance.")
    public BuildEngine getBuildEngine() {
        if (this.isServer()) {
            return BuildEngine.instance;
        }
        throw new UnsupportedOperationException();
    }

    @ScriptApi(value="Get script engine.")
    public ScriptEngine getScriptEngine() {
        return ScriptEngine.instance;
    }

    @ScriptApi(value="Get user manager which manages users.")
    public UserManager getUserManager() {
        return UserManager.instance;
    }

    @ScriptApi(value="Get group manager which manages groups.")
    public GroupManager getGroupManager() {
        return GroupManager.instance;
    }

    @ScriptApi(value="Get membership manager.")
    public MembershipManager getMembershipManager() {
        return MembershipManager.instance;
    }

    @ScriptApi(value="Get authorization manager.")
    public AuthorizationManager getAuthorizationManager() {
        return AuthorizationManager.instance;
    }

    @ScriptApi(value="Get configuration by path name. Null if not found.")
    public Configuration getConfiguration(String pathName) {
        return ConfigurationManager.instance.get(pathName);
    }

    @ScriptApi(value="Get plugin instance with the name containing specified string in case insensitive mode. Null if not found.")
    public Plugin getPlugin(String pluginShortName) {
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.getName().toLowerCase().contains(pluginShortName.toLowerCase())) continue;
            return plugin;
        }
        return null;
    }

    public static ServerService getServerService() {
        if (Bootstrap.serverUrl == null) {
            return Quickbuild.getInstance(ServerService.class);
        }
        RemotingProxyFactory factory = new RemotingProxyFactory(Bootstrap.getAgentToken());
        return (ServerService)factory.create(ServerService.class, Bootstrap.serverUrl, "/service/server");
    }

    public ReadWriteLock getStopLock() {
        return this.stopLock;
    }

    private boolean updateBootstrapLib(String libName, String replacePattern) {
        File libFile = new File(Bootstrap.getPluginsDir(), "com.pmease.quickbuild.bootstrap/lib/" + libName);
        if (!libFile.exists()) {
            logger.info("Updating bootstrap lib '" + libName + "'...");
            try {
                String url = Bootstrap.serverUrl + "/agent_update" + "/plugins/com.pmease.quickbuild.bootstrap/lib/" + libName;
                BootstrapUtils.download((String)url, (String)Bootstrap.getAgentToken(), (File)libFile);
            }
            catch (Throwable throwable) {
                if (libFile.exists()) {
                    BootstrapUtils.deleteFile((File)libFile);
                }
                throw BootstrapUtils.wrapAsUnchecked((Throwable)throwable);
            }
            for (File file : FileUtils.listFiles(Bootstrap.installDir, "conf/wrapper.conf, bin/config.*")) {
                String content = FileUtils.readFileAsString(file);
                FileUtils.writeFile(file, content.replaceAll(replacePattern, libName));
                if (!file.getName().endsWith(".sh")) continue;
                file.setExecutable(true);
            }
            return true;
        }
        return false;
    }

    public Server getJettyServer() {
        return this.jettyServer;
    }

    public boolean processConnectResult(ConnectResult connectResult) {
        Bootstrap.heartbeatInterval = connectResult.getHeartbeatInterval();
        if (!connectResult.getAgentIp().equals(Bootstrap.nodeIp)) {
            logger.warn("Agent ip address is changed (previous: {}, current: {}), restarting...", (Object)Bootstrap.nodeIp, (Object)connectResult.getAgentIp());
            Bootstrap.restart();
            return true;
        }
        if (!connectResult.getServerToken().equals(Bootstrap.serverToken)) {
            logger.info("Server restarted, checking for updates...");
            if (AgentUpdater.isOutOfDate()) {
                logger.warn("Agent files are out of date, restarting agent to sync with server...");
                Bootstrap.restart();
                return true;
            }
            logger.info("Agent files are in sync.");
            Bootstrap.serverToken = connectResult.getServerToken();
            return false;
        }
        return false;
    }

    public boolean handleConnectException(Throwable throwable) {
        AuthenticationException authenticationException = (AuthenticationException)BootstrapUtils.extractException((Throwable)throwable, AuthenticationException.class);
        if (authenticationException != null) {
            logger.error("Error connecting server: " + authenticationException.getMessage());
            if (this.isUserAgent()) {
                System.exit(1);
                return true;
            }
            return false;
        }
        AccessDeniedException accessDeniedException = (AccessDeniedException)BootstrapUtils.extractException((Throwable)throwable, AccessDeniedException.class);
        if (accessDeniedException != null) {
            logger.error("Error connecting server: " + accessDeniedException.getMessage());
            if (this.isUserAgent()) {
                System.exit(1);
                return true;
            }
            if (accessDeniedException.getPayload() instanceof ConnectResult) {
                return this.processConnectResult((ConnectResult)accessDeniedException.getPayload());
            }
            if (accessDeniedException.getPayload() instanceof Integer) {
                Bootstrap.heartbeatInterval = (Integer)accessDeniedException.getPayload();
                return false;
            }
            return false;
        }
        logger.error("Error connecting server.", throwable);
        return false;
    }

    public boolean isConnected() {
        if (this.isServer()) {
            throw new UnsupportedOperationException("This can only be called from agent.");
        }
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (this.isServer()) {
            throw new UnsupportedOperationException("This can only be called from agent.");
        }
        this.connected = connected;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public static class DisableTraceFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if ("false".equals(System.getProperty("keepAlive"))) {
                httpResponse.setHeader("Connection", "close");
            }
            if (httpRequest.getMethod().equals("TRACE")) {
                httpResponse.sendError(405);
            } else {
                chain.doFilter(request, response);
            }
        }

        public void destroy() {
        }
    }

    public static class DefaultPlugin
    extends AbstractPlugin {
        @Override
        public Object[] getExtensions() {
            return null;
        }
    }
}

