/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.extensionpoint.ScriptInterpreter;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.util.Triple;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

@Singleton
public class DefaultScriptEngine
implements ScriptEngine {
    @Inject
    private PluginManager pluginManager;
    private volatile List<ScriptInterpreter> evaluators;

    private Triple<String, String, String> parseInterpolative(String interpolative) {
        String right;
        String middle;
        int pos = interpolative.indexOf("${");
        if (pos == -1) {
            return new Triple<String, Object, String>(interpolative, null, "");
        }
        String left = interpolative.substring(0, pos);
        String rest = StringUtils.replace((String)interpolative.substring(pos + 2), (String)"\\}", (String)String.valueOf('\u000e'));
        if (rest.indexOf(125) != -1) {
            middle = StringUtils.substringBefore((String)rest, (String)"}");
            middle = StringUtils.replace((String)middle, (String)String.valueOf('\u000e'), (String)"}");
            right = StringUtils.substringAfter((String)rest, (String)"}");
            right = StringUtils.replace((String)right, (String)String.valueOf('\u000e'), (String)"\\}");
        } else {
            left = interpolative;
            middle = null;
            right = "";
        }
        return new Triple<String, String, String>(left, middle, right);
    }

    @Override
    public Object evaluate(String script, Map context) {
        if (script == null) {
            script = "";
        }
        try {
            if (this.evaluators == null) {
                this.evaluators = this.pluginManager.getExtensions(ScriptInterpreter.class);
            }
            for (ScriptInterpreter evaluator : this.evaluators) {
                if (!script.trim().startsWith(evaluator.getPrefix())) continue;
                return evaluator.evaluate(script.trim().substring(evaluator.getPrefix().length()), context);
            }
            script = "mvel:" + script;
            for (ScriptInterpreter evaluator : this.evaluators) {
                if (!script.startsWith(evaluator.getPrefix())) continue;
                return evaluator.evaluate(script.substring(evaluator.getPrefix().length()), context);
            }
            throw new QuickbuildException("Can not find evaluator.");
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapException("Failed to evaluate below expression:\n" + script, e);
        }
    }

    @Override
    public String interpolate(String string, Map context) {
        if (string == null) {
            return null;
        }
        Triple<String, String, String> result = this.parseInterpolative(string);
        while (result.getSecond() != null) {
            String replacement;
            Object evaluationResult = this.evaluate(result.getSecond(), context);
            if (evaluationResult == null) {
                replacement = "";
            } else {
                replacement = evaluationResult.toString();
                if (replacement == null) {
                    replacement = "";
                }
            }
            string = result.getFirst() + replacement + result.getThird();
            result = this.parseInterpolative(string);
        }
        if (string.length() != 0) {
            return StringUtils.replace((String)string, (String)"$!{", (String)"${");
        }
        return null;
    }

    @Override
    public Object installInterpolator(Object object) {
        return this.installInterpolator(object, null);
    }

    private Object installInterpolator(Object object, Object parentObject) {
        Constructor<?> constructor;
        if (object == null) {
            return object;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(object.getClass());
        enhancer.setCallback((Callback)new Interpolator());
        Object enhanced = parentObject != null ? ((constructor = ClassUtils.getConstructor(object.getClass(), parentObject.getClass())) != null ? enhancer.create(constructor.getParameterTypes(), new Object[]{parentObject}) : enhancer.create()) : enhancer.create();
        for (Field field : BeanUtils.getFields(object.getClass())) {
            try {
                field.setAccessible(true);
                if (parentObject != null && field.get(enhanced) == parentObject) continue;
                field.set(enhanced, field.get(object));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        List<Method> getters = BeanUtils.getGetters(object.getClass());
        for (Method getter : getters) {
            TypeConverter typeConverter;
            if (getter.getAnnotation(Editable.class) == null || !BeanUtils.hasSetter(getter) || (typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter)) != null) continue;
            try {
                if (List.class.isAssignableFrom(getter.getReturnType())) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    List oldList = (List)getter.invoke(enhanced, new Object[0]);
                    if (oldList != null) {
                        for (Object element : oldList) {
                            list.add(this.installInterpolator(element, enhanced));
                        }
                    }
                    BeanUtils.getSetter(getter).invoke(enhanced, list);
                    continue;
                }
                if (ClassUtils.isSystemType(getter.getReturnType())) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Return type is not supported.", "class", object.getClass().getName(), "method", getter.getName()));
                }
                Object value = getter.invoke(enhanced, new Object[0]);
                if (value == null) continue;
                BeanUtils.getSetter(getter).invoke(enhanced, this.installInterpolator(value, enhanced));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return enhanced;
    }

    @Override
    public Object uninstallInterpolator(Object object) {
        return this.uninstallInterpolator(object, null);
    }

    private Object uninstallInterpolator(Object object, Object parentObject) {
        Object unenhanced;
        Class<?> unenhancedClass = ClassUtils.unproxy(object.getClass());
        try {
            Constructor<?> constructor;
            unenhanced = parentObject != null ? ((constructor = ClassUtils.getConstructor(unenhancedClass, parentObject.getClass())) != null ? constructor.newInstance(parentObject) : unenhancedClass.newInstance()) : unenhancedClass.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        for (Field field : BeanUtils.getFields(unenhanced.getClass())) {
            try {
                field.setAccessible(true);
                if (parentObject != null && field.get(unenhanced) == parentObject) continue;
                field.set(unenhanced, field.get(object));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        List<Method> getters = BeanUtils.getGetters(unenhanced.getClass());
        for (Method getter : getters) {
            TypeConverter typeConverter;
            if (getter.getAnnotation(Editable.class) == null || !BeanUtils.hasSetter(getter) || (typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter)) != null) continue;
            try {
                if (List.class.isAssignableFrom(getter.getReturnType())) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    List originList = (List)getter.invoke(object, new Object[0]);
                    if (originList != null) {
                        for (Object element : originList) {
                            list.add(this.uninstallInterpolator(element, unenhanced));
                        }
                    }
                    BeanUtils.getSetter(getter).invoke(unenhanced, list);
                    continue;
                }
                if (ClassUtils.isSystemType(getter.getReturnType())) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Return type is not supported.", "class", getter.getDeclaringClass().getName(), "method", getter.getName()));
                }
                Object value = getter.invoke(object, new Object[0]);
                if (value == null) continue;
                BeanUtils.getSetter(getter).invoke(unenhanced, this.uninstallInterpolator(value, unenhanced));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return unenhanced;
    }

    @Override
    public boolean interpolative(String string) {
        if (string != null) {
            return string.indexOf("${") != -1;
        }
        return false;
    }

    private static class Interpolator
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Interpolator() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (!BeanUtils.isGetter(method) || method.getAnnotation(Editable.class) == null || method.getAnnotation(Scriptable.class) == null) {
                return methodProxy.invokeSuper(proxy, args);
            }
            TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(method);
            if (typeConverter != null) {
                Object value = methodProxy.invokeSuper(proxy, args);
                if (value != null) {
                    Map<String, Object> context = Context.buildEvalContext(proxy, null);
                    String interpolated = Quickbuild.getInstance(ScriptEngine.class).interpolate(typeConverter.toString(value), context);
                    return typeConverter.toObject(value.getClass(), interpolated);
                }
                return null;
            }
            return methodProxy.invokeSuper(proxy, args);
        }
    }
}

