/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.measurement.BuildMeasurements;
import com.pmease.quickbuild.measurement.WebMeasurements;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMetricsManager
implements MetricsManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetricsManager.class);
    @Inject
    private BuildEngine buildEngine;
    @Inject
    private Grid grid;
    @Inject
    private CacheManager cacheManager;
    private long totalProcessingBuildRequests;
    private long totalWaitingBuildRequests;
    private long totalRunningSteps;
    private long totalWaitingSteps;
    private Map<String, Long> processingBuildRequestsByNode = new HashMap<String, Long>();
    private Map<String, Long> runningStepsByNode = new HashMap<String, Long>();
    private Map<String, Long> usedResourcesByName = new HashMap<String, Long>();
    private Map<String, Long> freeResourcesByName = new HashMap<String, Long>();

    @Override
    public synchronized long getTotalProcessingBuildRequests() {
        return this.totalProcessingBuildRequests;
    }

    @Override
    public synchronized long getTotalWaitingBuildRequests() {
        return this.totalWaitingBuildRequests;
    }

    @Override
    public synchronized long getTotalRunningSteps() {
        return this.totalRunningSteps;
    }

    @Override
    public synchronized long getTotalWaitingSteps() {
        return this.totalWaitingSteps;
    }

    @Override
    public synchronized Map<String, Long> getProcessingBuildRequestsByNode() {
        return this.processingBuildRequestsByNode;
    }

    @Override
    public synchronized Map<String, Long> getRunningStepsByNode() {
        return this.runningStepsByNode;
    }

    @Override
    public synchronized Map<String, Long> getUsedResourcesByName() {
        return this.usedResourcesByName;
    }

    @Override
    public synchronized Map<String, Long> getFreeResourcesByName() {
        return this.freeResourcesByName;
    }

    @Override
    public synchronized void prepare() {
        String serverNodeAddress = this.grid.getServerNode().getAddress();
        this.totalProcessingBuildRequests = 0L;
        this.totalWaitingBuildRequests = 0L;
        this.totalRunningSteps = 0L;
        this.totalWaitingSteps = 0L;
        this.processingBuildRequestsByNode.clear();
        this.runningStepsByNode.clear();
        this.usedResourcesByName.clear();
        this.freeResourcesByName.clear();
        List<BuildRequest> requests = this.buildEngine.getBuildRequests(null);
        for (BuildRequest request : requests) {
            BuildRequest.Status status = request.getStatus();
            String processingNodeAddress = null;
            if (status == BuildRequest.Status.AGGREGATING_METRICS || status == BuildRequest.Status.COLLECTING_BUILD_METRICS || status == BuildRequest.Status.SENDING_BUILD_NOTIFICATIONS) {
                ++this.totalProcessingBuildRequests;
                processingNodeAddress = serverNodeAddress;
            } else if (status == BuildRequest.Status.CHECKING_BUILD_CONDITION || status == BuildRequest.Status.RUNNING_BUILD) {
                ++this.totalProcessingBuildRequests;
                for (Map.Entry<String, StepRuntime> stepEntry : request.getBuild().getStepRuntimes().entrySet()) {
                    if (stepEntry.getValue().getStatus() == StepRuntime.Status.RUNNING) {
                        ++this.totalRunningSteps;
                        String nodeAddress = stepEntry.getValue().getNodeAddress();
                        if (nodeAddress != null) {
                            Long count = this.runningStepsByNode.get(nodeAddress);
                            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
                            this.runningStepsByNode.put(nodeAddress, count);
                        }
                        for (Map.Entry<String, Integer> resourceEntry : stepEntry.getValue().getResources().entrySet()) {
                            Long count = this.usedResourcesByName.get(resourceEntry.getKey());
                            count = count != null ? Long.valueOf(count + (long)resourceEntry.getValue().intValue()) : Long.valueOf(resourceEntry.getValue().longValue());
                            this.usedResourcesByName.put(resourceEntry.getKey(), count);
                        }
                    }
                    if (stepEntry.getValue().getStatus() == StepRuntime.Status.WAITING) {
                        ++this.totalWaitingSteps;
                    }
                    if (!stepEntry.getKey().equals("master")) continue;
                    processingNodeAddress = stepEntry.getValue().getNodeAddress();
                }
            } else if (status == BuildRequest.Status.WAITING_NODE) {
                ++this.totalWaitingBuildRequests;
            }
            if (processingNodeAddress == null) continue;
            Long count = this.processingBuildRequestsByNode.get(processingNodeAddress);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.processingBuildRequestsByNode.put(processingNodeAddress, count);
        }
        for (Resource resource : this.cacheManager.getResources()) {
            long freeCount;
            Long usedCount = this.usedResourcesByName.get(resource.getName());
            if (usedCount == null) {
                usedCount = 0L;
                this.usedResourcesByName.put(resource.getName(), usedCount);
            }
            if ((freeCount = (long)resource.getCount() - usedCount) < 0L) {
                freeCount = 0L;
            }
            this.freeResourcesByName.put(resource.getName(), freeCount);
        }
        for (String resourceName : this.usedResourcesByName.keySet()) {
            if (this.freeResourcesByName.containsKey(resourceName)) continue;
            this.usedResourcesByName.remove(resourceName);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("*************************** BEGIN BUILD METRICS *************************");
            logger.trace("totalProcessingBuildRequests: " + this.getTotalProcessingBuildRequests());
            logger.trace("totalWaitingBuildRequests: " + this.getTotalWaitingBuildRequests());
            logger.trace("totalRunningSteps: " + this.getTotalRunningSteps());
            logger.trace("totalWaitingSteps: " + this.getTotalWaitingSteps());
            logger.trace("processingBuildRequestsByNode: " + this.getProcessingBuildRequestsByNode());
            logger.trace("runningStepsByNode: " + this.getRunningStepsByNode());
            logger.trace("usedResourcesByName: " + this.getUsedResourcesByName());
            logger.trace("freeResourcesByName: " + this.getFreeResourcesByName());
            logger.trace("*************************** END BUILD METRICS *************************");
        }
    }

    @Override
    public void buildFinished(Build build) {
        BuildMeasurements.INSTANCE.getBuildsCounter().inc();
        if (!build.isSuccessful()) {
            BuildMeasurements.INSTANCE.getBuildsFailedCounter().inc();
        }
        BuildMeasurements.INSTANCE.getBuildsTimer().update(build.getDuration().longValue(), TimeUnit.MILLISECONDS);
        BuildMeasurements.INSTANCE.getBuildsWaitingTimer().update(build.getWaitDuration().longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void webRequestProcessed(Long duration) {
        WebMeasurements.INSTANCE.getUiTimer().update(duration.longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void restRequestProcessed(Long duration) {
        WebMeasurements.INSTANCE.getRestTimer().update(duration.longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void rpcRequestProcessed(Long duration) {
        WebMeasurements.INSTANCE.getRpcTimer().update(duration.longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void downloadRequestProcessed(Long duration) {
        WebMeasurements.INSTANCE.getDownloadTimer().update(duration.longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void uploadRequestProcessed(Long duration) {
        WebMeasurements.INSTANCE.getUploadTimer().update(duration.longValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void buildRequestProcessed() {
        BuildMeasurements.INSTANCE.getProcessedRequestsCounter().inc();
    }

    @Override
    public void buildRequestSubmitted() {
        BuildMeasurements.INSTANCE.getSubmittedRequestsCounter().inc();
    }

    static class RequestInfo {
        private Date date;
        private boolean successful;
        private Long duration;
        private Long waitDuration;

        RequestInfo() {
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void setSuccessful(boolean successful) {
            this.successful = successful;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public Long getWaitDuration() {
            return this.waitDuration;
        }

        public void setWaitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
        }
    }
}

