/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.ResourceAccess;
import com.pmease.quickbuild.model.Setting;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.TriggerDependence;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.setting.system.AlertRetentionSetting;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.setting.system.SystemSetting;
import com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.ObjectUtils;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.cycle.RequestCycle;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheManager.class);
    private static final long BUILD_TIME_TO_LIVE = 300L;
    private static final MetaDataKey<Map<Long, List<Authorization>>> GROUP_AUTHORIZATIONS_KEY = new MetaDataKey<Map<Long, List<Authorization>>>(){};
    private Map<Long, Configuration> configurations = new HashMap<Long, Configuration>();
    private Map<Long, Date> lastAccessTimeOfResources = new ConcurrentHashMap<Long, Date>();
    private ReadWriteLock configurationsLock = new ReentrantReadWriteLock();
    private Map<Long, TriggerDependence> triggerDependences = new HashMap<Long, TriggerDependence>();
    private ReadWriteLock triggerDependencesLock = new ReentrantReadWriteLock();
    private Map<Long, Resource> resources = new HashMap<Long, Resource>();
    private ReadWriteLock resourcesLock = new ReentrantReadWriteLock();
    private Map<Long, Build> latestBuilds = new HashMap<Long, Build>();
    private ReadWriteLock latestBuildsLock = new ReentrantReadWriteLock();
    private Map<Long, Long> historyCounts = new HashMap<Long, Long>();
    private ReadWriteLock historyCountsLock = new ReentrantReadWriteLock();
    private Map<Long, Long> baseDurations = new HashMap<Long, Long>();
    private ReadWriteLock baseDurationsLock = new ReentrantReadWriteLock();
    private Map<Long, Build> firstBuilds = new HashMap<Long, Build>();
    private ReadWriteLock firstBuildsLock = new ReentrantReadWriteLock();
    private Map<Long, Pair<Build, Date>> activeBuilds = new HashMap<Long, Pair<Build, Date>>();
    private ReadWriteLock activeBuildsLock = new ReentrantReadWriteLock();
    private Map<Long, Authorization> authorizations = new HashMap<Long, Authorization>();
    private ReadWriteLock authorizationsLock = new ReentrantReadWriteLock();
    private Map<Long, Group> groups = new HashMap<Long, Group>();
    private Map<Long, PermissionSet> permissionSets = new HashMap<Long, PermissionSet>();
    private Map<Long, Alarm> alarms = new HashMap<Long, Alarm>();
    private ReadWriteLock alarmsLock = new ReentrantReadWriteLock();
    private ReadWriteLock groupsLock = new ReentrantReadWriteLock();
    private ReadWriteLock permissionSetsLock = new ReentrantReadWriteLock();
    private Map<Long, User> users = new HashMap<Long, User>();
    private ReadWriteLock usersLock = new ReentrantReadWriteLock();
    private Map<Long, CloudProfile> cloudProfiles = new HashMap<Long, CloudProfile>();
    private ReadWriteLock cloudProfilesLock = new ReentrantReadWriteLock();
    private Map<Long, Token> tokens = new HashMap<Long, Token>();
    private ReadWriteLock tokensLock = new ReentrantReadWriteLock();
    private Map<Long, Membership> memberships = new HashMap<Long, Membership>();
    private ReadWriteLock membershipsLock = new ReentrantReadWriteLock();
    private Map<Long, Dashboard> dashboards = new HashMap<Long, Dashboard>();
    private ReadWriteLock dashboardsLock = new ReentrantReadWriteLock();
    private Map<Long, GroupShare> groupShares = new HashMap<Long, GroupShare>();
    private ReadWriteLock groupSharesLock = new ReentrantReadWriteLock();
    private Map<Long, UserShare> userShares = new HashMap<Long, UserShare>();
    private ReadWriteLock userSharesLock = new ReentrantReadWriteLock();
    private volatile SystemSetting systemSetting;
    private volatile EmailSetting emailSetting;
    private volatile AlertRetentionSetting alertSetting;
    private volatile License license;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration(Long configurationId) {
        this.configurationsLock.readLock().lock();
        try {
            Configuration configuration = this.configurations.get(configurationId);
            return configuration;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Build getLatestBuild(Long configurationId) {
        this.latestBuildsLock.readLock().lock();
        try {
            Build build = this.latestBuilds.get(configurationId);
            return build;
        }
        finally {
            this.latestBuildsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Build> getLatestBuilds() {
        this.latestBuildsLock.readLock().lock();
        try {
            HashMap<Long, Build> hashMap = new HashMap<Long, Build>(this.latestBuilds);
            return hashMap;
        }
        finally {
            this.latestBuildsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Build cloneLatestBuild(Long configurationId) {
        this.latestBuildsLock.readLock().lock();
        try {
            Build build = this.latestBuilds.get(configurationId);
            if (build != null) {
                Build build2 = this.clone(build);
                return build2;
            }
            Build build3 = null;
            return build3;
        }
        finally {
            this.latestBuildsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationSaved(Configuration configuration, boolean isNew) {
        Configuration cached;
        this.configurationsLock.writeLock().lock();
        try {
            cached = this.configurations.get(configuration.getId());
            Configuration clone = this.clone(configuration);
            this.configurations.put(clone.getId(), clone);
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        if (cached == null || !ObjectUtils.equals((Object)cached.getSchedule(), (Object)configuration.getSchedule()) || !ObjectUtils.equals((Object)cached.getDisabled(), (Object)configuration.getDisabled())) {
            BuildEngine.instance.scheduleChanged(configuration);
        }
        if (isNew) {
            this.historyCountsLock.writeLock().lock();
            try {
                this.historyCounts.put(configuration.getId(), 0L);
            }
            finally {
                this.historyCountsLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationRemoved(Long configurationId) {
        this.configurationsLock.writeLock().lock();
        try {
            this.configurations.remove(configurationId);
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        this.latestBuildsLock.writeLock().lock();
        try {
            this.latestBuilds.remove(configurationId);
        }
        finally {
            this.latestBuildsLock.writeLock().unlock();
        }
        this.firstBuildsLock.writeLock().lock();
        try {
            this.firstBuilds.remove(configurationId);
        }
        finally {
            this.firstBuildsLock.writeLock().unlock();
        }
        this.historyCountsLock.writeLock().lock();
        try {
            this.historyCounts.remove(configurationId);
        }
        finally {
            this.historyCountsLock.writeLock().unlock();
        }
        this.authorizationsLock.writeLock().lock();
        try {
            Iterator<Map.Entry<Long, Authorization>> it = this.authorizations.entrySet().iterator();
            while (it.hasNext()) {
                Authorization authorization = it.next().getValue();
                if (!authorization.getConfiguration().getId().equals(configurationId)) continue;
                it.remove();
            }
        }
        finally {
            this.authorizationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildRemoved(Build build) {
        Long configurationId = build.getConfiguration().getId();
        this.latestBuildsLock.writeLock().lock();
        try {
            Build latestBuild = this.latestBuilds.get(configurationId);
            if (latestBuild != null && build.getId().equals(latestBuild.getId())) {
                latestBuild = BuildManager.instance.getLatest(build.getConfiguration());
                if (latestBuild != null) {
                    latestBuild = this.clone(latestBuild);
                    this.latestBuilds.put(configurationId, latestBuild);
                } else {
                    this.latestBuilds.remove(configurationId);
                }
            }
        }
        finally {
            this.latestBuildsLock.writeLock().unlock();
        }
        this.firstBuildsLock.writeLock().lock();
        try {
            Build firstBuild = this.firstBuilds.get(configurationId);
            if (firstBuild != null && build.getId().equals(firstBuild.getId())) {
                firstBuild = BuildManager.instance.getFirst(build.getConfiguration());
                if (firstBuild != null) {
                    firstBuild = this.clone(firstBuild);
                    this.firstBuilds.put(configurationId, firstBuild);
                } else {
                    this.firstBuilds.remove(configurationId);
                }
            }
        }
        finally {
            this.firstBuildsLock.writeLock().unlock();
        }
        this.historyCountsLock.writeLock().lock();
        try {
            this.historyCounts.put(configurationId, this.historyCounts.get(configurationId) - 1L);
        }
        finally {
            this.historyCountsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildActive(Build build) {
        this.activeBuildsLock.writeLock().lock();
        try {
            this.activeBuilds.put(build.getId(), new Pair<Build, Date>(this.clone(build), new Date()));
        }
        finally {
            this.activeBuildsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSaved(Build build, boolean isNew) {
        Long configurationId = build.getConfiguration().getId();
        Build clone = this.clone(build);
        this.latestBuildsLock.writeLock().lock();
        try {
            Build latestBuild = this.latestBuilds.get(configurationId);
            if (latestBuild == null || clone.getId() >= latestBuild.getId()) {
                this.latestBuilds.put(configurationId, clone);
            }
        }
        finally {
            this.latestBuildsLock.writeLock().unlock();
        }
        this.firstBuildsLock.writeLock().lock();
        try {
            Build firstBuild = this.firstBuilds.get(configurationId);
            if (firstBuild == null || clone.getId() <= firstBuild.getId()) {
                this.firstBuilds.put(configurationId, clone);
            }
        }
        finally {
            this.firstBuildsLock.writeLock().unlock();
        }
        this.buildActive(build);
        if (isNew) {
            this.historyCountsLock.writeLock().lock();
            try {
                this.historyCounts.put(configurationId, this.historyCounts.get(configurationId) + 1L);
            }
            finally {
                this.historyCountsLock.writeLock().unlock();
            }
        }
        if (build.isSuccessful()) {
            this.baseDurationsLock.writeLock().lock();
            try {
                this.baseDurations.put(configurationId, build.getDuration());
            }
            finally {
                this.baseDurationsLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildMoved(Build build, Long oldConfigurationId) {
        Long configurationId = build.getConfiguration().getId();
        this.latestBuildsLock.writeLock().lock();
        try {
            Build latestBuild = this.latestBuilds.get(oldConfigurationId);
            if (latestBuild != null && latestBuild.getId().equals(build.getId())) {
                latestBuild = BuildManager.instance.getLatest((Configuration)ConfigurationManager.instance.load(oldConfigurationId));
                if (latestBuild != null) {
                    latestBuild = this.clone(latestBuild);
                    this.latestBuilds.put(oldConfigurationId, latestBuild);
                } else {
                    this.latestBuilds.remove(oldConfigurationId);
                }
            }
            if ((latestBuild = this.latestBuilds.get(configurationId)) == null || build.getId() >= latestBuild.getId()) {
                this.latestBuilds.put(configurationId, this.clone((Build)BuildManager.instance.load(build.getId())));
            }
        }
        finally {
            this.latestBuildsLock.writeLock().unlock();
        }
        this.firstBuildsLock.writeLock().lock();
        try {
            Build firstBuild = this.firstBuilds.get(oldConfigurationId);
            if (firstBuild != null && firstBuild.getId().equals(build.getId())) {
                firstBuild = BuildManager.instance.getFirst((Configuration)ConfigurationManager.instance.load(oldConfigurationId));
                if (firstBuild != null) {
                    firstBuild = this.clone(firstBuild);
                    this.firstBuilds.put(oldConfigurationId, firstBuild);
                } else {
                    this.firstBuilds.remove(oldConfigurationId);
                }
            }
            if ((firstBuild = this.firstBuilds.get(configurationId)) == null || build.getId() <= firstBuild.getId()) {
                this.firstBuilds.put(configurationId, this.clone((Build)BuildManager.instance.load(build.getId())));
            }
        }
        finally {
            this.firstBuildsLock.writeLock().unlock();
        }
        this.historyCountsLock.writeLock().lock();
        try {
            this.historyCounts.put(oldConfigurationId, this.historyCounts.get(oldConfigurationId) - 1L);
            this.historyCounts.put(configurationId, this.historyCounts.get(configurationId) + 1L);
        }
        finally {
            this.historyCountsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        Session session = SessionManager.openSession();
        try {
            AbstractEntity share;
            Setting setting = (Setting)session.load(Setting.class, (Serializable)Setting.SYSTEM_SETTING_ID);
            this.systemSetting = (SystemSetting)ScriptEngine.instance.installInterpolator(setting.getObject());
            setting = (Setting)session.load(Setting.class, (Serializable)Setting.EMAIL_SETTING_ID);
            if (setting.getObject() != null) {
                this.emailSetting = (EmailSetting)ScriptEngine.instance.installInterpolator(setting.getObject());
            }
            setting = (Setting)session.load(Setting.class, (Serializable)Setting.ALERT_SETTING_ID);
            this.alertSetting = (AlertRetentionSetting)setting.getObject();
            setting = (Setting)session.load(Setting.class, (Serializable)Setting.LICENSE_KEY_ID);
            this.license = License.fromKey((String)((Object)setting.getObject()));
            Query query = session.createQuery("from Resource");
            for (Resource resource : query.list()) {
                this.resources.put(resource.getId(), this.clone(resource));
                query = session.createQuery("from ResourceAccess access where access.resource=:resource order by access.when desc");
                query.setParameter("resource", (Object)resource);
                query.setMaxResults(1);
                query.setFirstResult(0);
                ResourceAccess resourceAccess = (ResourceAccess)query.uniqueResult();
                if (resourceAccess == null) continue;
                this.lastAccessTimeOfResources.put(resource.getId(), resourceAccess.getWhen());
            }
            query = session.createQuery("from PermissionSet");
            for (PermissionSet permissionSet : query.list()) {
                this.permissionSets.put(permissionSet.getId(), this.clone(permissionSet));
            }
            query = session.createQuery("from Group");
            for (Group group : query.list()) {
                this.groups.put(group.getId(), this.clone(group));
            }
            query = session.createQuery("from User");
            for (User user : query.list()) {
                this.users.put(user.getId(), this.clone(user));
            }
            query = session.createQuery("from Token");
            for (Token token : query.list()) {
                this.tokens.put(token.getId(), this.clone(token));
            }
            query = session.createQuery("select id, name, description, user.id from Dashboard");
            for (Object[] row : query.list()) {
                Dashboard dashboard = new Dashboard();
                dashboard.setId((Long)row[0]);
                dashboard.setName((String)row[1]);
                dashboard.setDescription((String)row[2]);
                dashboard.setUser(new User());
                dashboard.getUser().setId((Long)row[3]);
                this.dashboards.put(dashboard.getId(), dashboard);
            }
            query = session.createQuery("select id, group.id, dashboard.id from GroupShare");
            for (Object[] row : query.list()) {
                share = new GroupShare();
                share.setId((Long)row[0]);
                if (row[1] != null) {
                    ((GroupShare)share).setGroup(new Group());
                    ((GroupShare)share).getGroup().setId((Long)row[1]);
                }
                ((GroupShare)share).setDashboard(new Dashboard());
                ((GroupShare)share).getDashboard().setId((Long)row[2]);
                this.groupShares.put(share.getId(), (GroupShare)share);
            }
            query = session.createQuery("select id, user.id, dashboard.id from UserShare");
            for (Object[] row : query.list()) {
                share = new UserShare();
                share.setId((Long)row[0]);
                ((UserShare)share).setUser(new User());
                ((UserShare)share).getUser().setId((Long)row[1]);
                ((UserShare)share).setDashboard(new Dashboard());
                ((UserShare)share).getDashboard().setId((Long)row[2]);
                this.userShares.put(share.getId(), (UserShare)share);
            }
            query = session.createQuery("from CloudProfile");
            for (CloudProfile profile : query.list()) {
                this.cloudProfiles.put(profile.getId(), this.clone(profile));
            }
            query = session.createQuery("select id, group.id, configuration.id, permissions from Authorization");
            for (Object[] row : query.list()) {
                Authorization authorization = new Authorization();
                authorization.setId((Long)row[0]);
                authorization.setGroup(new Group());
                authorization.getGroup().setId((Long)row[1]);
                authorization.setConfiguration(new Configuration());
                authorization.getConfiguration().setId((Long)row[2]);
                authorization.setPermissions((ArrayList)row[3]);
                this.authorizations.put(authorization.getId(), authorization);
            }
            query = session.createQuery("select id, user.id, notifier from Alarm");
            for (Object[] row : query.list()) {
                Alarm alarm = new Alarm();
                alarm.setId((Long)row[0]);
                alarm.setUser(new User());
                alarm.getUser().setId((Long)row[1]);
                alarm.setNotifier((String)row[2]);
                this.alarms.put(alarm.getId(), alarm);
            }
            query = session.createQuery("select id, user.id, group.id from Membership");
            for (Object[] row : query.list()) {
                Membership membership = new Membership();
                membership.setId((Long)row[0]);
                membership.setUser(new User());
                membership.getUser().setId((Long)row[1]);
                membership.setGroup(new Group());
                membership.getGroup().setId((Long)row[2]);
                this.memberships.put(membership.getId(), membership);
            }
            query = session.createQuery("select id, dependent.id, dependency.id from TriggerDependence");
            for (Object[] row : query.list()) {
                TriggerDependence dependence = new TriggerDependence();
                dependence.setId((Long)row[0]);
                dependence.setDependent(new Configuration());
                dependence.getDependent().setId((Long)row[1]);
                dependence.setDependency(new Configuration());
                dependence.getDependency().setId((Long)row[2]);
                this.triggerDependences.put(dependence.getId(), dependence);
            }
            query = session.createQuery("select id, name, description, disabled, statusDate, errorMessage, schedule, parent.id, data from Configuration");
            List confObjs = query.list();
            int confCount = confObjs.size();
            int i = 1;
            for (Object[] row : confObjs) {
                Build build;
                Configuration configuration = new Configuration();
                configuration.setId((Long)row[0]);
                configuration.setName((String)row[1]);
                configuration.setDescription((String)row[2]);
                configuration.setDisabled((Boolean)row[3]);
                configuration.setStatusDate((Date)row[4]);
                configuration.setErrorMessage((String)row[5]);
                configuration.setSchedule((Schedule)row[6]);
                if (row[7] != null) {
                    configuration.setParent(new Configuration());
                    configuration.getParent().setId((Long)row[7]);
                }
                configuration.setData((LinkedHashMap)row[8]);
                this.configurations.put(configuration.getId(), configuration);
                query = session.createQuery("select id, beginDate, duration, status, version, shortBranch from Build where configuration.id=:configurationId order by id desc");
                query.setParameter("configurationId", (Object)configuration.getId());
                query.setMaxResults(1);
                row = (Object[])query.uniqueResult();
                if (row != null) {
                    build = new Build();
                    build.setConfiguration(new Configuration());
                    build.getConfiguration().setId(configuration.getId());
                    build.setId((Long)row[0]);
                    build.setBeginDate((Date)row[1]);
                    build.setDuration((Long)row[2]);
                    build.setStatus((Build.Status)((Object)row[3]));
                    build.setVersion((String)row[4]);
                    build.setShortBranch((String)row[5]);
                    this.latestBuilds.put(configuration.getId(), build);
                }
                query = session.createQuery("select duration from Build where configuration.id=:configurationId and status=:successful order by id desc");
                query.setParameter("configurationId", (Object)configuration.getId());
                query.setParameter("successful", (Object)Build.Status.SUCCESSFUL);
                query.setMaxResults(1);
                Long baseDuration = (Long)query.uniqueResult();
                if (baseDuration != null) {
                    this.baseDurations.put(configuration.getId(), baseDuration);
                }
                query = session.createQuery("select id, beginDate, duration, status, version from Build where configuration.id=:configurationId order by id");
                query.setParameter("configurationId", (Object)configuration.getId());
                query.setMaxResults(1);
                row = (Object[])query.uniqueResult();
                if (row != null) {
                    build = new Build();
                    build.setConfiguration(new Configuration());
                    build.getConfiguration().setId(configuration.getId());
                    build.setId((Long)row[0]);
                    build.setBeginDate((Date)row[1]);
                    build.setDuration((Long)row[2]);
                    build.setStatus((Build.Status)((Object)row[3]));
                    build.setVersion((String)row[4]);
                    this.firstBuilds.put(configuration.getId(), build);
                }
                query = session.createQuery("select count(*) from Build where configuration=:configuration");
                query.setParameter("configuration", (Object)configuration);
                this.historyCounts.put(configuration.getId(), (Long)query.uniqueResult());
                logger.debug("Cached {} configurations ({} left)...", (Object)i, (Object)(confCount - i));
                ++i;
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Build, Date> getActiveBuild(Long buildId) {
        this.activeBuildsLock.readLock().lock();
        try {
            Pair<Build, Date> pair = this.activeBuilds.get(buildId);
            return pair;
        }
        finally {
            this.activeBuildsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.activeBuildsLock.writeLock().lock();
        try {
            Date expireDate = new Date(System.currentTimeMillis() - 300000L);
            Iterator<Map.Entry<Long, Pair<Build, Date>>> it = this.activeBuilds.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Pair<Build, Date>> entry = it.next();
                if (!entry.getValue().getSecond().before(expireDate)) continue;
                it.remove();
            }
        }
        finally {
            this.activeBuildsLock.writeLock().unlock();
        }
    }

    @Override
    public Schedule getSchedule() {
        PeriodicalSchedule schedule = new PeriodicalSchedule();
        schedule.setRepeatInterval("300");
        return schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConfigurationCount() {
        this.configurationsLock.readLock().lock();
        try {
            int n = this.configurations.size();
            return n;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Build getFirstBuild(Long configurationId) {
        this.firstBuildsLock.readLock().lock();
        try {
            Build build = this.firstBuilds.get(configurationId);
            return build;
        }
        finally {
            this.firstBuildsLock.readLock().unlock();
        }
    }

    private Build clone(Build build) {
        Build clone = new Build();
        clone.setConfiguration(new Configuration());
        clone.getConfiguration().setId(build.getConfiguration().getId());
        clone.setId(build.getId());
        clone.setBeginDate(build.getBeginDate());
        clone.setDuration(build.getDuration());
        clone.setStatus(build.getStatus());
        clone.setVersion(build.getVersion());
        clone.setShortBranch(build.getShortBranch());
        return clone;
    }

    private Resource clone(Resource resource) {
        Resource clone = new Resource();
        clone.setId(resource.getId());
        clone.setDescription(resource.getDescription());
        clone.setName(resource.getName());
        clone.setProviders(resource.getProviders());
        return clone;
    }

    private Alarm clone(Alarm alarm) {
        Alarm clone = new Alarm();
        clone.setId(alarm.getId());
        clone.setUser(new User());
        clone.getUser().setId(alarm.getUser().getId());
        clone.setNotifier(alarm.getNotifier());
        return clone;
    }

    private Group clone(Group group) {
        Group clone = new Group();
        clone.setAdmin(group.isAdmin());
        clone.setAgentAllowed(group.isAgentAllowed());
        clone.setExpandAllAllowed(group.isExpandAllAllowed());
        clone.setNodeAttributesAllowed(group.isNodeAttributesAllowed());
        clone.setSystemLogAllowed(group.isSystemLogAllowed());
        clone.setScriptAllowed(group.isScriptAllowed());
        clone.setForceHttps(group.isForceHttps());
        clone.setShareDashboardAllowed(group.isShareDashboardAllowed());
        clone.setRestAccessAllowed(group.isRestAccessAllowed());
        clone.setViewAlertsAllowed(group.isViewAlertsAllowed());
        clone.setId(group.getId());
        clone.setName(group.getName());
        return clone;
    }

    private PermissionSet clone(PermissionSet permissionSet) {
        PermissionSet clone = new PermissionSet();
        clone.setId(permissionSet.getId());
        clone.setName(permissionSet.getName());
        clone.setPermissions(permissionSet.getPermissions());
        return clone;
    }

    private Dashboard clone(Dashboard dashboard) {
        Dashboard clone = new Dashboard();
        clone.setId(dashboard.getId());
        clone.setDescription(dashboard.getDescription());
        clone.setName(dashboard.getName());
        clone.setUser(new User());
        clone.getUser().setId(dashboard.getUser().getId());
        return clone;
    }

    private User clone(User user) {
        User clone = new User();
        clone.setAuthenticator(user.getAuthenticator());
        clone.getFavoriteDashboardIds().addAll(user.getFavoriteDashboardIds());
        clone.setEmail(user.getEmail());
        clone.setFullName(user.getFullName());
        clone.setId(user.getId());
        clone.setName(user.getName());
        clone.setPassword(user.getPassword());
        clone.setPluginSettingDOMs(user.getPluginSettingDOMs());
        return clone;
    }

    private CloudProfile clone(CloudProfile cloudProfile) {
        CloudProfile clone = new CloudProfile();
        clone.setDescription(cloudProfile.getDescription());
        clone.setId(cloudProfile.getId());
        clone.setName(cloudProfile.getName());
        clone.setNodeLauncherDOM(cloudProfile.getNodeLauncherDOM());
        clone.setTestInfo(cloudProfile.getTestInfo());
        clone.setProfileAttributes(cloudProfile.getProfileAttributes());
        clone.setIdleTimeToTerminate(cloudProfile.getIdleTimeToTerminate());
        clone.setMaxNodesToLaunch(cloudProfile.getMaxNodesToLaunch());
        return clone;
    }

    private Token clone(Token token) {
        Token clone = new Token();
        clone.setHostName(token.getHostName());
        clone.setId(token.getId());
        clone.setIp(token.getIp());
        clone.setPort(token.getPort());
        clone.setValue(token.getValue());
        clone.setTest(token.isTest());
        clone.setOfflineAlert(token.isOfflineAlert());
        if (token.getCloudProfile() != null) {
            clone.setCloudProfile(new CloudProfile());
            clone.getCloudProfile().setId(token.getCloudProfile().getId());
        }
        clone.setNodeLaunchId(token.getNodeLaunchId());
        return clone;
    }

    private Membership clone(Membership membership) {
        Membership clone = new Membership();
        clone.setId(membership.getId());
        clone.setGroup(new Group());
        clone.getGroup().setId(membership.getGroup().getId());
        clone.setUser(new User());
        clone.getUser().setId(membership.getUser().getId());
        return clone;
    }

    private TriggerDependence clone(TriggerDependence triggerDependence) {
        TriggerDependence clone = new TriggerDependence();
        clone.setId(triggerDependence.getId());
        clone.setDependent(new Configuration());
        clone.getDependent().setId(triggerDependence.getDependent().getId());
        clone.setDependency(new Configuration());
        clone.getDependency().setId(triggerDependence.getDependency().getId());
        return clone;
    }

    private GroupShare clone(GroupShare share) {
        GroupShare clone = new GroupShare();
        clone.setId(share.getId());
        clone.setDashboard(new Dashboard());
        clone.getDashboard().setId(share.getDashboard().getId());
        if (share.getGroup() != null) {
            clone.setGroup(new Group());
            clone.getGroup().setId(share.getGroup().getId());
        }
        return clone;
    }

    private UserShare clone(UserShare share) {
        UserShare clone = new UserShare();
        clone.setId(share.getId());
        clone.setDashboard(new Dashboard());
        clone.getDashboard().setId(share.getDashboard().getId());
        clone.setUser(new User());
        clone.getUser().setId(share.getUser().getId());
        return clone;
    }

    private Authorization clone(Authorization authorization) {
        Authorization clone = new Authorization();
        clone.setId(authorization.getId());
        clone.setConfiguration(new Configuration());
        clone.getConfiguration().setId(authorization.getConfiguration().getId());
        clone.setGroup(new Group());
        clone.getGroup().setId(authorization.getGroup().getId());
        clone.setPermissions(authorization.getPermissions());
        return clone;
    }

    private Configuration clone(Configuration configuration) {
        Configuration clone = new Configuration();
        clone.setId(configuration.getId());
        if (configuration.getParent() != null) {
            clone.setParent(new Configuration());
            clone.getParent().setId(configuration.getParent().getId());
        }
        clone.setName(configuration.getName());
        clone.setDescription(configuration.getDescription());
        clone.setDisabled(configuration.getDisabled());
        clone.setStatusDate(configuration.getStatusDate());
        clone.setErrorMessage(configuration.getErrorMessage());
        clone.setData(new LinkedHashMap<String, Serializable>(configuration.getData()));
        if (configuration.getSchedule() != null) {
            clone.setSchedule(configuration.getSchedule().clone());
        } else {
            clone.setSchedule(null);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Configuration> getConfigurations() {
        this.configurationsLock.readLock().lock();
        try {
            HashMap<Long, Configuration> hashMap = new HashMap<Long, Configuration>(this.configurations);
            return hashMap;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Configuration> cloneConfigurations() {
        HashMap<Long, Configuration> cloned;
        this.configurationsLock.readLock().lock();
        try {
            cloned = new HashMap<Long, Configuration>(this.configurations);
            for (Map.Entry entry : cloned.entrySet()) {
                entry.setValue(this.clone((Configuration)entry.getValue()));
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        for (Configuration configuration : cloned.values()) {
            if (configuration.getParent() == null) continue;
            configuration.setParent((Configuration)cloned.get(configuration.getParent().getId()));
        }
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren(Long configurationId) {
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration each : this.configurations.values()) {
                if (each.getParent() == null || !each.getParent().getId().equals(configurationId)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getChildrenIds(Set<Long> parentIds) {
        HashSet<Long> childrenIds = new HashSet<Long>();
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration each : this.configurations.values()) {
                if (each.getParent() == null || !parentIds.contains(each.getParent().getId())) continue;
                childrenIds.add(each.getId());
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return childrenIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Configuration> getChildren(Long configurationId) {
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration each : this.configurations.values()) {
                if (each.getParent() == null || !each.getParent().getId().equals(configurationId)) continue;
                children.add(each);
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildrenCount(Long configurationId) {
        this.configurationsLock.readLock().lock();
        try {
            int count = 0;
            for (Configuration each : this.configurations.values()) {
                if (each.getParent() == null || !each.getParent().getId().equals(configurationId)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Configuration> getDescendents(Long configurationId) {
        HashSet<Long> descendentIds = new HashSet<Long>();
        Set<Long> parentIds = new HashSet<Long>();
        parentIds.add(configurationId);
        while (!parentIds.isEmpty()) {
            Set<Long> childrenIds = this.getChildrenIds(parentIds);
            descendentIds.addAll(childrenIds);
            parentIds = childrenIds;
        }
        ArrayList<Configuration> descendents = new ArrayList<Configuration>();
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration each : this.configurations.values()) {
                if (!descendentIds.contains(each.getId())) continue;
                descendents.add(each);
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return descendents;
    }

    @Override
    public Set<Long> getDescendentIds(Long configurationId) {
        HashSet<Long> descendentIds = new HashSet<Long>();
        Set<Long> parentIds = new HashSet<Long>();
        parentIds.add(configurationId);
        while (!parentIds.isEmpty()) {
            Set<Long> childrenIds = this.getChildrenIds(parentIds);
            descendentIds.addAll(childrenIds);
            parentIds = childrenIds;
        }
        return descendentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHistoryCount(Long configurationId) {
        this.historyCountsLock.readLock().lock();
        try {
            Long historyCount = this.historyCounts.get(configurationId);
            if (historyCount != null) {
                long l = historyCount;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.historyCountsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBaseDuration(Long configurationId) {
        this.baseDurationsLock.readLock().lock();
        try {
            Long baseDuration = this.baseDurations.get(configurationId);
            if (baseDuration != null) {
                long l = baseDuration;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.baseDurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Authorization> getAuthorizations(Long groupId) {
        List<Authorization> groupAuthorizations = null;
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null) {
            HashMap map = (HashMap)requestCycle.getMetaData(GROUP_AUTHORIZATIONS_KEY);
            if (map == null) {
                map = new HashMap();
                requestCycle.setMetaData(GROUP_AUTHORIZATIONS_KEY, map);
            }
            groupAuthorizations = (List)map.get(groupId);
        }
        if (groupAuthorizations == null) {
            groupAuthorizations = new ArrayList();
            this.authorizationsLock.readLock().lock();
            try {
                for (Authorization each : this.authorizations.values()) {
                    if (!each.getGroup().getId().equals(groupId)) continue;
                    groupAuthorizations.add(each);
                }
            }
            finally {
                this.authorizationsLock.readLock().unlock();
            }
            if (requestCycle != null) {
                ((Map)requestCycle.getMetaData(GROUP_AUTHORIZATIONS_KEY)).put(groupId, groupAuthorizations);
            }
        }
        return groupAuthorizations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getGroup(Long groupId) {
        this.groupsLock.readLock().lock();
        try {
            Group group = this.groups.get(groupId);
            return group;
        }
        finally {
            this.groupsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionSet getPermissionSet(Long id) {
        this.permissionSetsLock.readLock().lock();
        try {
            PermissionSet permissionSet = this.permissionSets.get(id);
            return permissionSet;
        }
        finally {
            this.permissionSetsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getGroups(Long userId) {
        ArrayList<Group> userGroups = new ArrayList<Group>();
        this.membershipsLock.readLock().lock();
        try {
            for (Membership each : this.memberships.values()) {
                Group group;
                if (!each.getUser().getId().equals(userId) || (group = this.getGroup(each.getGroup().getId())) == null) continue;
                userGroups.add(group);
            }
        }
        finally {
            this.membershipsLock.readLock().unlock();
        }
        return userGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Dashboard> getDashboardsAccessibleByGroup(Long groupId) {
        ArrayList<Dashboard> accessibleDashboards = new ArrayList<Dashboard>();
        this.groupSharesLock.readLock().lock();
        try {
            for (GroupShare each : this.groupShares.values()) {
                Dashboard dashboard;
                if (each.getGroup() == null || !each.getGroup().getId().equals(groupId) || (dashboard = this.getDashboard(each.getDashboard().getId())) == null) continue;
                accessibleDashboards.add(dashboard);
            }
        }
        finally {
            this.groupSharesLock.readLock().unlock();
        }
        return accessibleDashboards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Dashboard> getDashboardsAccessibleByUser(Long userId) {
        Dashboard dashboard;
        ArrayList<Dashboard> accessibleDashboards = new ArrayList<Dashboard>();
        accessibleDashboards.addAll(this.getDashboardsOwnedByUser(userId));
        HashSet<Long> dashboardIds = new HashSet<Long>();
        for (Dashboard each : accessibleDashboards) {
            dashboardIds.add(each.getId());
        }
        HashSet<Long> groupIds = new HashSet<Long>();
        for (Group group : this.getGroups(userId)) {
            groupIds.add(group.getId());
        }
        this.groupSharesLock.readLock().lock();
        try {
            for (GroupShare groupShare : this.groupShares.values()) {
                if (dashboardIds.contains(groupShare.getDashboard().getId()) || groupShare.getGroup() != null && !groupIds.contains(groupShare.getGroup().getId()) || (dashboard = this.getDashboard(groupShare.getDashboard().getId())) == null) continue;
                accessibleDashboards.add(dashboard);
                dashboardIds.add(dashboard.getId());
            }
        }
        finally {
            this.groupSharesLock.readLock().unlock();
        }
        this.userSharesLock.readLock().lock();
        try {
            for (UserShare userShare : this.userShares.values()) {
                if (!userShare.getUser().getId().equals(userId) || dashboardIds.contains(userShare.getDashboard().getId()) || (dashboard = this.getDashboard(userShare.getDashboard().getId())) == null) continue;
                accessibleDashboards.add(dashboard);
                dashboardIds.add(dashboard.getId());
            }
        }
        finally {
            this.userSharesLock.readLock().unlock();
        }
        return accessibleDashboards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGroupsSharedWithDashboard(Long dashboardId) {
        ArrayList<String> groups = new ArrayList<String>();
        this.groupSharesLock.readLock().lock();
        try {
            for (GroupShare each : this.groupShares.values()) {
                if (!each.getDashboard().getId().equals(dashboardId)) continue;
                if (each.getGroup() != null) {
                    Group group = this.getGroup(each.getGroup().getId());
                    if (group != null) {
                        groups.add(group.getName());
                    }
                    continue;
                }
                ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"[Everyone]"});
                return arrayList;
            }
        }
        finally {
            this.groupSharesLock.readLock().unlock();
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsersSharedWithDashboard(Long dashboardId) {
        ArrayList<String> users = new ArrayList<String>();
        this.userSharesLock.readLock().lock();
        try {
            for (UserShare each : this.userShares.values()) {
                User user;
                if (each.getUser() == null || !each.getDashboard().getId().equals(dashboardId) || (user = this.getUser(each.getUser().getId())) == null) continue;
                users.add(user.getName());
            }
        }
        finally {
            this.userSharesLock.readLock().unlock();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Dashboard> getDashboardsOwnedByUser(Long userId) {
        ArrayList<Dashboard> userDashboards = new ArrayList<Dashboard>();
        this.dashboardsLock.readLock().lock();
        try {
            for (Dashboard each : this.dashboards.values()) {
                if (!each.getUser().getId().equals(userId)) continue;
                userDashboards.add(each);
            }
        }
        finally {
            this.dashboardsLock.readLock().unlock();
        }
        return userDashboards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void membershipRemoved(Long membershipId) {
        this.membershipsLock.writeLock().lock();
        try {
            this.memberships.remove(membershipId);
        }
        finally {
            this.membershipsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void membershipSaved(Membership membership) {
        this.membershipsLock.writeLock().lock();
        try {
            this.memberships.put(membership.getId(), this.clone(membership));
        }
        finally {
            this.membershipsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerDependenceRemoved(Long triggerDependenceId) {
        this.triggerDependencesLock.writeLock().lock();
        try {
            this.triggerDependences.remove(triggerDependenceId);
        }
        finally {
            this.triggerDependencesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerDependenceSaved(TriggerDependence triggerDependence) {
        this.triggerDependencesLock.writeLock().lock();
        try {
            this.triggerDependences.put(triggerDependence.getId(), this.clone(triggerDependence));
        }
        finally {
            this.triggerDependencesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void groupShareSaved(GroupShare share) {
        this.groupSharesLock.writeLock().lock();
        try {
            this.groupShares.put(share.getId(), this.clone(share));
        }
        finally {
            this.groupSharesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void groupShareRemoved(Long shareId) {
        this.groupSharesLock.writeLock().lock();
        try {
            this.groupShares.remove(shareId);
        }
        finally {
            this.groupSharesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupShare getGroupShare(Long shareId) {
        this.groupSharesLock.readLock().lock();
        try {
            GroupShare groupShare = this.groupShares.get(shareId);
            return groupShare;
        }
        finally {
            this.groupSharesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userShareSaved(UserShare share) {
        this.userSharesLock.writeLock().lock();
        try {
            this.userShares.put(share.getId(), this.clone(share));
        }
        finally {
            this.userSharesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userShareRemoved(Long shareId) {
        this.userSharesLock.writeLock().lock();
        try {
            this.userShares.remove(shareId);
        }
        finally {
            this.userSharesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserShare getUserShare(Long shareId) {
        this.userSharesLock.readLock().lock();
        try {
            UserShare userShare = this.userShares.get(shareId);
            return userShare;
        }
        finally {
            this.userSharesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dashboardSaved(Dashboard dashboard) {
        this.dashboardsLock.writeLock().lock();
        try {
            this.dashboards.put(dashboard.getId(), this.clone(dashboard));
        }
        finally {
            this.dashboardsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dashboardRemoved(Long dashboardId) {
        this.dashboardsLock.writeLock().lock();
        try {
            this.dashboards.remove(dashboardId);
        }
        finally {
            this.dashboardsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dashboard getDashboard(Long dashboardId) {
        this.dashboardsLock.readLock().lock();
        try {
            Dashboard dashboard = this.dashboards.get(dashboardId);
            return dashboard;
        }
        finally {
            this.dashboardsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authorizationRemoved(Long authorizationId) {
        this.authorizationsLock.writeLock().lock();
        try {
            this.authorizations.remove(authorizationId);
        }
        finally {
            this.authorizationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authorizationSaved(Authorization authorization) {
        this.authorizationsLock.writeLock().lock();
        try {
            this.authorizations.put(authorization.getId(), this.clone(authorization));
        }
        finally {
            this.authorizationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void groupRemoved(Long groupId) {
        this.groupsLock.writeLock().lock();
        try {
            this.groups.remove(groupId);
        }
        finally {
            this.groupsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void permissionSetRemoved(Long permissionSetId) {
        this.permissionSetsLock.writeLock().lock();
        try {
            this.permissionSets.remove(permissionSetId);
        }
        finally {
            this.permissionSetsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void groupSaved(Group group) {
        this.groupsLock.writeLock().lock();
        try {
            this.groups.put(group.getId(), this.clone(group));
        }
        finally {
            this.groupsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void permissionSetSaved(PermissionSet permissionSet) {
        this.permissionSetsLock.writeLock().lock();
        try {
            this.permissionSets.put(permissionSet.getId(), this.clone(permissionSet));
        }
        finally {
            this.permissionSetsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alarmRemoved(Long alarmId) {
        this.alarmsLock.writeLock().lock();
        try {
            this.alarms.remove(alarmId);
        }
        finally {
            this.alarmsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alarmSaved(Alarm alarm) {
        this.alarmsLock.writeLock().lock();
        try {
            this.alarms.put(alarm.getId(), this.clone(alarm));
        }
        finally {
            this.alarmsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Alarm> getUserAlarms(Long userId) {
        this.alarmsLock.readLock().lock();
        try {
            ArrayList<Alarm> userAlarms = new ArrayList<Alarm>();
            for (Alarm alarm : this.alarms.values()) {
                if (!alarm.getUser().getId().equals(userId)) continue;
                userAlarms.add(alarm);
            }
            ArrayList<Alarm> arrayList = userAlarms;
            return arrayList;
        }
        finally {
            this.alarmsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getGroup(String name) {
        this.groupsLock.readLock().lock();
        try {
            for (Group group : this.groups.values()) {
                if (!group.getName().equals(name)) continue;
                Group group2 = group;
                return group2;
            }
            Group group = null;
            return group;
        }
        finally {
            this.groupsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionSet getPermissionSet(String name) {
        this.permissionSetsLock.readLock().lock();
        try {
            for (PermissionSet permissionSet : this.permissionSets.values()) {
                if (!permissionSet.getName().equals(name)) continue;
                PermissionSet permissionSet2 = permissionSet;
                return permissionSet2;
            }
            PermissionSet permissionSet = null;
            return permissionSet;
        }
        finally {
            this.permissionSetsLock.readLock().unlock();
        }
    }

    @Override
    public Configuration cloneConfiguration(Long configurationId) {
        Configuration configuration = this.getConfiguration(configurationId);
        if (configuration == null) {
            return null;
        }
        Configuration clone = this.clone(configuration);
        while (clone.getParent() != null) {
            clone.setParent(this.cloneConfiguration(clone.getParent().getId()));
        }
        return clone;
    }

    @Override
    public SystemSetting getSystemSetting() {
        return this.systemSetting;
    }

    @Override
    public void systemSettingSaved(SystemSetting systemSetting) {
        this.systemSetting = systemSetting;
    }

    @Override
    public EmailSetting getEmailSetting() {
        return this.emailSetting;
    }

    @Override
    public void emailSettingSaved(EmailSetting emailSetting) {
        this.emailSetting = emailSetting;
    }

    @Override
    public License getLicense() {
        License temp = this.license;
        if (temp == null) {
            throw new QuickbuildException("License not available or is invalid.");
        }
        return temp;
    }

    @Override
    public void licenseSaved(License license) {
        this.license = license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceSaved(Resource resource) {
        this.resourcesLock.writeLock().lock();
        try {
            this.resources.put(resource.getId(), this.clone(resource));
        }
        finally {
            this.resourcesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceRemoved(Long resourceId) {
        this.resourcesLock.writeLock().lock();
        try {
            this.resources.remove(resourceId);
        }
        finally {
            this.resourcesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResource(Long resourceId) {
        this.resourcesLock.readLock().lock();
        try {
            Resource resource = this.resources.get(resourceId);
            return resource;
        }
        finally {
            this.resourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResource(String resourceName) {
        this.resourcesLock.readLock().lock();
        try {
            for (Resource resource : this.resources.values()) {
                if (!resource.getName().equals(resourceName)) continue;
                Resource resource2 = resource;
                return resource2;
            }
            Resource resource = null;
            return resource;
        }
        finally {
            this.resourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> getResources() {
        this.resourcesLock.readLock().lock();
        try {
            ArrayList<Resource> arrayList = new ArrayList<Resource>(this.resources.values());
            return arrayList;
        }
        finally {
            this.resourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenRemoved(Long tokenId) {
        this.tokensLock.writeLock().lock();
        try {
            this.tokens.remove(tokenId);
        }
        finally {
            this.tokensLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenSaved(Token token) {
        this.tokensLock.writeLock().lock();
        try {
            this.tokens.put(token.getId(), this.clone(token));
        }
        finally {
            this.tokensLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTokenCount(Long cloudProfileId) {
        this.tokensLock.readLock().lock();
        try {
            int count = 0;
            for (Token token : this.tokens.values()) {
                CloudProfile profile = token.getCloudProfile();
                if (profile == null || !profile.getId().equals(cloudProfileId)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getToken(Long tokenId) {
        this.tokensLock.readLock().lock();
        try {
            Token token = this.tokens.get(tokenId);
            return token;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getToken(String tokenValue) {
        this.tokensLock.readLock().lock();
        try {
            for (Token token : this.tokens.values()) {
                if (!token.getValue().equals(tokenValue)) continue;
                Token token2 = token;
                return token2;
            }
            Token token = null;
            return token;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getToken(String ip, int port) {
        this.tokensLock.readLock().lock();
        try {
            for (Token token : this.tokens.values()) {
                if (!token.getIp().equals(ip) || token.getPort() != port) continue;
                Token token2 = token;
                return token2;
            }
            Token token = null;
            return token;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getTokenByAddress(String address) {
        this.tokensLock.readLock().lock();
        try {
            for (Token token : this.tokens.values()) {
                if (!token.getAddress().equals(address)) continue;
                Token token2 = token;
                return token2;
            }
            Token token = null;
            return token;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userRemoved(Long userId) {
        this.usersLock.writeLock().lock();
        try {
            this.users.remove(userId);
        }
        finally {
            this.usersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userSaved(User user) {
        this.usersLock.writeLock().lock();
        try {
            this.users.put(user.getId(), this.clone(user));
        }
        finally {
            this.usersLock.writeLock().unlock();
        }
    }

    @Override
    public void resourceUsageSaved(ResourceAccess resourceUsage) {
        this.lastAccessTimeOfResources.put(resourceUsage.getResource().getId(), resourceUsage.getWhen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String userName) {
        this.usersLock.readLock().lock();
        try {
            for (User user : this.users.values()) {
                if (!user.getName().equals(userName)) continue;
                User user2 = user;
                return user2;
            }
            User user = null;
            return user;
        }
        finally {
            this.usersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(Long userId) {
        this.usersLock.readLock().lock();
        try {
            User user = this.users.get(userId);
            return user;
        }
        finally {
            this.usersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloudProfileRemoved(Long cloudProfileId) {
        this.cloudProfilesLock.writeLock().lock();
        try {
            this.cloudProfiles.remove(cloudProfileId);
        }
        finally {
            this.cloudProfilesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloudProfileSaved(CloudProfile cloudProfile) {
        this.cloudProfilesLock.writeLock().lock();
        try {
            this.cloudProfiles.put(cloudProfile.getId(), this.clone(cloudProfile));
        }
        finally {
            this.cloudProfilesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudProfile getCloudProfile(String cloudProfileName) {
        this.cloudProfilesLock.readLock().lock();
        try {
            for (CloudProfile profile : this.cloudProfiles.values()) {
                if (!profile.getName().equals(cloudProfileName)) continue;
                CloudProfile cloudProfile = profile;
                return cloudProfile;
            }
            CloudProfile cloudProfile = null;
            return cloudProfile;
        }
        finally {
            this.cloudProfilesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudProfile getCloudProfile(Long cloudProfileId) {
        this.cloudProfilesLock.readLock().lock();
        try {
            CloudProfile cloudProfile = this.cloudProfiles.get(cloudProfileId);
            return cloudProfile;
        }
        finally {
            this.cloudProfilesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CloudProfile> getCloudProfiles() {
        this.cloudProfilesLock.readLock().lock();
        try {
            ArrayList<CloudProfile> arrayList = new ArrayList<CloudProfile>(this.cloudProfiles.values());
            return arrayList;
        }
        finally {
            this.cloudProfilesLock.readLock().unlock();
        }
    }

    @Override
    public boolean isAgentAllowed(User user) {
        if (user.isRoot()) {
            return true;
        }
        for (Group each : this.getGroups(user.getId())) {
            if (!each.isAdmin() && !each.isAgentAllowed()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Token> getTokens() {
        this.tokensLock.readLock().lock();
        try {
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokens.values());
            return arrayList;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTokenCount() {
        this.tokensLock.readLock().lock();
        try {
            int n = this.tokens.size();
            return n;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    @Override
    public AlertRetentionSetting getAlertRetentionSetting() {
        return this.alertSetting;
    }

    @Override
    public void alertSettingSaved(AlertRetentionSetting alertSetting) {
        this.alertSetting = alertSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getTriggerDependents(Long configurationId) {
        this.triggerDependencesLock.readLock().lock();
        try {
            HashSet<Long> dependents = new HashSet<Long>();
            for (TriggerDependence dependence : this.triggerDependences.values()) {
                if (!dependence.getDependency().getId().equals(configurationId)) continue;
                dependents.add(dependence.getDependent().getId());
            }
            HashSet<Long> hashSet = dependents;
            return hashSet;
        }
        finally {
            this.triggerDependencesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Long> getTriggerDependencies(Long configurationId) {
        this.triggerDependencesLock.readLock().lock();
        try {
            HashMap<Long, Long> dependencies = new HashMap<Long, Long>();
            for (TriggerDependence dependence : this.triggerDependences.values()) {
                if (!dependence.getDependent().getId().equals(configurationId)) continue;
                dependencies.put(dependence.getDependency().getId(), dependence.getId());
            }
            HashMap<Long, Long> hashMap = dependencies;
            return hashMap;
        }
        finally {
            this.triggerDependencesLock.readLock().unlock();
        }
    }

    @Override
    public Date getLastAccessTimeOfResource(Long resourceId) {
        return this.lastAccessTimeOfResources.get(resourceId);
    }
}

