/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.CheckConditionTask;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.PromotionSource;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.RequestKey;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.RunningStepInfo;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildDependenceManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.ResourceAccessManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.entitymanager.TriggerDependenceManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.extensionpoint.ConfigurationDataPopulator;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.extensionpoint.TriggerDependencyContribution;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.grid.cloud.HasToWaitException;
import com.pmease.quickbuild.grid.cloud.TestInfo;
import com.pmease.quickbuild.license.CommercialLicense;
import com.pmease.quickbuild.license.CommercialLicense2;
import com.pmease.quickbuild.license.CommunityLicense;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.log.BuildLogger;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildDependence;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.ResourceAccess;
import com.pmease.quickbuild.model.Subscription;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.TriggerDependence;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.CheckoutBuildFinishTask;
import com.pmease.quickbuild.repositorysupport.CheckoutStep;
import com.pmease.quickbuild.repositorysupport.ProofBuildFinishTask;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.resource.ResourceAllocation;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.security.AuthenticationResult;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.ParentNodeMatcher;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepExecutionJob;
import com.pmease.quickbuild.stepsupport.StepExecutionTask;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.taskschedule.schedule.CronSchedule;
import com.pmease.quickbuild.taskschedule.schedule.NoSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.EasyList;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.ResourceUtils;
import com.pmease.quickbuild.util.SimpleCacheItem;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.PromptAsPasswordInput;
import com.pmease.quickbuild.variable.SecretValueProvider;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.variable.VariableWrapper;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.RandomUtils;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.util.SerializationHelper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultBuildEngine
implements BuildEngine,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBuildEngine.class);
    private static final int CACHE_DAYS = 3;
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private BuildManager buildManager;
    @Inject
    private UserManager userManager;
    @Inject
    private GroupManager groupManager;
    @Inject
    private AgentManager agentManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private MetricsManager metricsManager;
    @Inject
    private TriggerDependenceManager triggerDependenceManager;
    @Inject
    private Grid buildGrid;
    @Inject
    private BuildDependenceManager buildDependencyManager;
    @Inject
    private ResourceAccessManager resourceAccessManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private TaskScheduler taskScheduler;
    private List<BuildRequest> requests = new ArrayList<BuildRequest>();
    private Map<Long, Build> builds = new ConcurrentHashMap<Long, Build>();
    private ReadWriteLock requestsLock = new ReentrantReadWriteLock(true);
    private Map<RequestKey, SimpleCacheItem<String>> requestIdCache = new HashMap<RequestKey, SimpleCacheItem<String>>();
    private Map<String, SimpleCacheItem<Object>> buildIdCache = new HashMap<String, SimpleCacheItem<Object>>();
    private Map<Long, String> scheduledTasks = new HashMap<Long, String>();
    private volatile Thread thread;
    private Map<Long, Date> activityDates = new ConcurrentHashMap<Long, Date>();
    private Pattern emailPattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private Semaphore processingSemaphore = new Semaphore(1);

    private void ensureLicensed() {
        License license = CacheManager.instance.getLicense();
        Date releaseDate = Bootstrap.releaseDate;
        InputStream is = null;
        try {
            is = Quickbuild.class.getClassLoader().getResourceAsStream(ResourceUtils.getResourcePath(Quickbuild.class, "release"));
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                releaseDate = new Date(Long.valueOf(props.getProperty("date")));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        if (license instanceof CommercialLicense2) {
            CommercialLicense2 commercialLicense = (CommercialLicense2)license;
            if (commercialLicense.isExpired()) {
                throw new QuickbuildException("Trial commercial license expired");
            }
            if (commercialLicense.getExpirationDate() == null && !commercialLicense.isEligible(releaseDate)) {
                throw new QuickbuildException("Current license is only eligible for versions released before " + DateUtils.formatDate(commercialLicense.getServiceExpirationDate()) + ". Please re-generate the license by login to www.pmease.com with your service " + "account if you've renewed the service recently; otherwise, you will need to " + "renew the service to use this version.");
            }
        } else {
            long configurationCount;
            if (license instanceof CommercialLicense) {
                throw new QuickbuildException("Current license is for 2.0.x. Please generate and install 2.1.x license with your service account at our web site if it is not expired; otherwise, you will need to renew the service to use this version.");
            }
            if (license instanceof CommunityLicense && (configurationCount = (long)this.configurationManager.count()) > 16L) {
                throw new QuickbuildException("Number of configurations exceeds community license limit.");
            }
        }
    }

    private String newVersion(Configuration configuration) {
        String newVersion = configuration.getNextVersion(false);
        if (StringUtils.isBlank((String)newVersion)) {
            throw new QuickbuildException("Calculated new version is empty.");
        }
        if (Build.RESERVED_VERSIONS.contains((newVersion = newVersion.trim()).toLowerCase())) {
            throw new QuickbuildException("Build version '" + newVersion + "' is reserved for other purposes.");
        }
        if (!StringUtils.containsNone((String)newVersion, (String)"*%")) {
            throw new QuickbuildException("Build version '" + newVersion + "' contains " + "disallowed characters: " + "*%");
        }
        logger.info("New build version is calculated as '{}'.", (Object)newVersion);
        return newVersion;
    }

    private void checkSteps(Step step, List<String> stepPath) {
        if (step instanceof CompositeStep) {
            CompositeStep compositeStep = (CompositeStep)step;
            for (String childName : compositeStep.getChildStepNames()) {
                if (stepPath.contains(childName)) {
                    String circular = StringUtils.join(stepPath, (String)">");
                    circular = circular + ">" + childName;
                    throw new QuickbuildException("Step circular reference found: " + circular);
                }
                Step childStep = Context.getConfiguration().findStep(childName);
                if (childStep == null) {
                    throw new QuickbuildException("Step '" + childName + "' is not found in " + "configuration hierarchy.");
                }
                ArrayList<String> childStepPath = new ArrayList<String>(stepPath);
                childStepPath.add(childName);
                this.checkSteps(childStep, childStepPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(BuildRequest request) {
        Build build = request.getBuild();
        Lock lock = Configuration.lock(request.getConfigurationId());
        try {
            block52: {
                Configuration configuration = (Configuration)this.configurationManager.load(build.getRequest().getConfigurationId());
                BuildRequest buildRequest = build.getRequest();
                synchronized (buildRequest) {
                    build.setConfiguration(configuration);
                }
                Context.getLogger().info("Processing build request (configuration:{}, request id:{})", (Object)configuration.getPathName(), (Object)request.getId());
                User requester = request.getRequesterId() != null ? (User)this.userManager.load(request.getRequesterId()) : null;
                BuildRequest buildRequest2 = build.getRequest();
                synchronized (buildRequest2) {
                    build.setRequester(requester);
                }
                Context.push(build);
                try {
                    Object object;
                    this.ensureLicensed();
                    this.configurationManager.saveStatus(configuration, null, new Date());
                    FileUtils.createDir(configuration.getPublishDir());
                    logger.info("Checking build condition on node (address: {}, ip: {})...", (Object)build.getMasterStep().getNode().getAddress(), (Object)build.getMasterStep().getNode().getIp());
                    GridTaskFuture<Boolean> taskFuture = Grid.instance.execute(new CheckConditionTask(build), build);
                    boolean buildNecessary = taskFuture.get();
                    if (!buildNecessary) {
                        Build latestBuild = this.buildManager.getLatest(configuration);
                        if (latestBuild != null) {
                            logger.info("Build condition not satisfied, new build won't be generated.");
                            object = build.getRequest();
                            synchronized (object) {
                                build.setId(latestBuild.getId());
                                build.setBeginDate(latestBuild.getBeginDate());
                                build.setVersion(latestBuild.getVersion());
                                build.setStatus(latestBuild.getStatus());
                                build.setStatusDate(latestBuild.getStatusDate());
                                build.setScheduled(latestBuild.isScheduled());
                            }
                            this.builds.put(build.getId(), build);
                            object = this.buildIdCache;
                            synchronized (object) {
                                this.buildIdCache.put(build.getRequest().getId(), new SimpleCacheItem<Long>(build.getId()));
                            }
                            this.notifyBuildId(request, build.getId());
                            if (build.isFinished()) {
                                this.notifyBuildStatus(build);
                            }
                        } else {
                            buildNecessary = true;
                        }
                    }
                    if (!buildNecessary) break block52;
                    String newVersion = this.newVersion(configuration);
                    object = build.getRequest();
                    synchronized (object) {
                        build.getRequest().setStatus(BuildRequest.Status.RUNNING_BUILD);
                        build.setStatus(Build.Status.RUNNING);
                        build.setStatusDate(new Date());
                        build.setBeginDate(new Date());
                        build.setVersion(newVersion);
                    }
                    configuration.runPreBuildScript(build);
                    object = build.getRequest();
                    synchronized (object) {
                        for (VariableWrapper variableWrapper : build.getVariables().values()) {
                            build.getSecretAwareVariableValues().put(variableWrapper.getName(), new SecretAwareString(variableWrapper.getSnapshot(), null));
                        }
                        for (Map.Entry entry : build.getSecretAwareVariableValues().entrySet()) {
                            if (((SecretAwareString)entry.getValue()).getString() == null) continue;
                            String masked = build.obfuscateSecrets(((SecretAwareString)entry.getValue()).getString());
                            if (((SecretAwareString)entry.getValue()).getString().equals(masked)) continue;
                            ((SecretAwareString)entry.getValue()).setMasked(masked);
                        }
                    }
                    this.buildManager.save(build);
                    this.builds.put(build.getId(), build);
                    object = this.buildIdCache;
                    synchronized (object) {
                        this.buildIdCache.put(build.getRequest().getId(), new SimpleCacheItem<Long>(build.getId()));
                    }
                    this.activityDates.put(build.getRequest().getConfigurationId(), new Date());
                    this.notifyBuildId(build.getRequest(), build.getId());
                    lock.unlock();
                    try {
                        this.run(build);
                    }
                    finally {
                        lock.lock();
                        if (build.isFinished()) {
                            this.notifyBuildStatus(build);
                        }
                    }
                    if (BuildManager.instance.get(build.getId()) == null) break block52;
                    if (System.getProperty("DISABLE_METRICS") == null) {
                        object = build.getRequest();
                        synchronized (object) {
                            build.getRequest().setStatus(BuildRequest.Status.COLLECTING_BUILD_METRICS);
                        }
                        this.activityDates.put(build.getRequest().getConfigurationId(), new Date());
                        for (StatisticsSupport each : this.pluginManager.getExtensions(StatisticsSupport.class)) {
                            Context.getLogger().info("Collecting statistics '{}'...", (Object)each.getStatisticsName());
                            each.collectStatistics(build);
                        }
                        Context.getLogger().info("Populating configuration data...");
                        LinkedHashMap<String, Serializable> data = new LinkedHashMap<String, Serializable>();
                        for (ConfigurationDataPopulator configurationDataPopulator : this.pluginManager.getExtensions(ConfigurationDataPopulator.class)) {
                            configurationDataPopulator.populate(Context.getBuild(), data);
                        }
                        if (!data.equals(configuration.getData())) {
                            this.configurationManager.saveData(configuration, data);
                        }
                    }
                    object = build.getRequest();
                    synchronized (object) {
                        build.getRequest().setStatus(BuildRequest.Status.SENDING_BUILD_NOTIFICATIONS);
                    }
                    this.activityDates.put(build.getRequest().getConfigurationId(), new Date());
                    this.sendNotifications(build);
                    if (System.getProperty("DISABLE_METRICS") != null) break block52;
                    object = build.getRequest();
                    synchronized (object) {
                        build.getRequest().setStatus(BuildRequest.Status.AGGREGATING_METRICS);
                    }
                    this.activityDates.put(build.getRequest().getConfigurationId(), new Date());
                    this.aggregateMetrics(build);
                }
                catch (Throwable t) {
                    this.configurationManager.saveStatus(configuration, build.obfuscateSecrets(ExceptionUtils.extractImportantMessage(t)), new Date());
                    throw ExceptionUtils.wrapAsUnchecked(t);
                }
                finally {
                    Context.pop();
                }
            }
            Context.getLogger().info("Build request has been processed.");
            this.metricsManager.buildRequestProcessed();
        }
        finally {
            lock.unlock();
        }
    }

    private void aggregateMetrics(Build build) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        for (Configuration current = build.getConfiguration(); current != null; current = current.getParent()) {
            for (Aggregation aggregation : current.findAggregations()) {
                if (!aggregation.isEnabled() || !(aggregation = (Aggregation)scriptEngine.installInterpolator(aggregation)).getBuildMatcher().matches(current, build)) continue;
                Context.getLogger().info("Aggregating metrics (aggregation: {}, from: {}:{}, to: {})...", new Object[]{aggregation.getName(), build.getConfiguration().getPathName(), build.getVersion(), current.getPathName()});
                aggregation.aggregate(current, build);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void run(final Build build) {
        block99: {
            Serializable masterStep;
            Object listener2;
            if (!build.getPublishDir().exists()) {
                FileUtils.createDir(build.getPublishDir());
            } else {
                FileUtils.cleanDir(build.getPublishDir());
            }
            FileUtils.createFile(build.getLogFile());
            build.setLogger(new BuildLogger(build.getLogFile(), build.getConfiguration().findLogLevel(build)));
            for (Object listener2 : this.pluginManager.getExtensions(BuildListener.class)) {
                listener2.buildStarted();
            }
            listener2 = build.getRequest();
            synchronized (listener2) {
                masterStep = build.getMasterStep();
            }
            this.checkSteps((Step)masterStep, EasyList.create("master"));
            GridTaskFuture<Void> taskFuture = this.buildGrid.execute(new StepExecutionTask(build){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void buildVersionChanged() {
                    BuildRequest buildRequest = this.getBuild().getRequest();
                    synchronized (buildRequest) {
                        super.buildVersionChanged();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Map<GridJob, GridNode> map(StepPath arg) {
                    Step step;
                    BuildRequest buildRequest = build.getRequest();
                    synchronized (buildRequest) {
                        step = this.getBuild().getStep(arg);
                    }
                    Validate.notNull((Object)step);
                    HashMap<GridJob, GridNode> map = new HashMap<GridJob, GridNode>();
                    GridNode node = Grid.instance.getNode(step.getNodeAddress());
                    if (node == null) {
                        throw new QuickbuildException("Unable to run step on node '" + step.getNodeAddress() + "' as it goes offline just now.");
                    }
                    build.getLogger().trace("Will execute master step on node {}...", (Object)step.getNodeAddress());
                    map.put(new StepExecutionJob(this.getId(), this.getBuild(), arg), node);
                    return map;
                }
            }, StepPath.fromString("master"));
            taskFuture.get(build.getRemainingTime());
            if (taskFuture.getException() != null) {
                throw taskFuture.getException();
            }
            BuildRequest buildRequest = build.getRequest();
            synchronized (buildRequest) {
                masterStep = build.getMasterStep();
                if (masterStep.isSuccessful()) {
                    build.setStatus(Build.Status.SUCCESSFUL);
                } else {
                    build.setStatus(Build.Status.FAILED);
                }
                build.setStatusDate(new Date());
                build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
            }
            for (Step step : build.getSteps()) {
                CheckoutStep checkoutStep;
                if (!step.isEnabled() || !step.isFinished() || step.getNodeAddress() == null || !(step instanceof CheckoutStep) || !(checkoutStep = (CheckoutStep)step).getRepository().isCheckout()) continue;
                this.buildGrid.execute(new CheckoutBuildFinishTask(build), checkoutStep).get();
            }
            for (Repository repository : build.getRepositories()) {
                QuickbuildRepository quickbuildRepository;
                if (repository.getProofBuildSupport() != null && repository.getProofBuildSupport().getProofCondition().satisfied(repository)) {
                    this.buildGrid.execute(new ProofBuildFinishTask(build), repository.getName()).get();
                }
                if (!(repository instanceof QuickbuildRepository) || !repository.isCheckout() || (quickbuildRepository = (QuickbuildRepository)repository).getServer() != null || quickbuildRepository.getRevision() == null) continue;
                for (DependencyInfo info : quickbuildRepository.getRevision().getValue()) {
                    BuildDependence dependence;
                    Build dependency = (Build)this.buildManager.get(info.getBuildId());
                    if (dependency == null || (dependence = this.buildDependencyManager.get(build, dependency)) != null) continue;
                    dependence = new BuildDependence();
                    dependence.setDependent(build);
                    dependence.setDependency(dependency);
                    this.buildDependencyManager.save(dependence);
                }
            }
            masterStep = build.getRequest();
            synchronized (masterStep) {
                for (Step step : build.getSteps()) {
                    if (!step.isRunning() && !step.isWaiting()) continue;
                    step.setStatus(StepRuntime.Status.FAILED);
                    step.setErrorMessage("Build is already stopped.");
                }
                for (VariableWrapper var : build.getVariables().values()) {
                    build.getSecretAwareVariableValues().put(var.getName(), new SecretAwareString(var.getSnapshot(), null));
                }
                for (Map.Entry entry : build.getSecretAwareVariableValues().entrySet()) {
                    if (((SecretAwareString)entry.getValue()).getString() == null) continue;
                    String masked = build.obfuscateSecrets(((SecretAwareString)entry.getValue()).getString());
                    if (((SecretAwareString)entry.getValue()).getString().equals(masked)) continue;
                    ((SecretAwareString)entry.getValue()).setMasked(masked);
                }
                build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
            }
            if (build.getLogger() != null) {
                build.getLogger().close();
                build.setLogger(null);
            }
            this.buildManager.save(build);
            try {
                HashMap<String, ResourceAccess> resourceAccesses = new HashMap<String, ResourceAccess>();
                for (Step step : build.getSteps()) {
                    for (Map.Entry<String, Integer> entry : step.getResources().entrySet()) {
                        ResourceAccess access = (ResourceAccess)resourceAccesses.get(entry.getKey());
                        if (access == null) {
                            access = new ResourceAccess();
                            access.setConfiguration(build.getConfiguration());
                            access.setWhen(build.getBeginDate());
                            resourceAccesses.put(entry.getKey(), access);
                        }
                        if (step.getDuration() != null && entry.getValue() != null) {
                            access.setDuration(access.getDuration() + (long)entry.getValue().intValue() * step.getDuration());
                        }
                        access.getSteps().add(step.getName());
                    }
                }
                for (Map.Entry entry : resourceAccesses.entrySet()) {
                    Resource resource = this.cacheManager.getResource((String)entry.getKey());
                    if (resource == null) continue;
                    ((ResourceAccess)entry.getValue()).setResource(resource);
                    this.resourceAccessManager.saveOrUpdate((ResourceAccess)entry.getValue());
                }
            }
            catch (Exception e) {
                logger.error("Error writing resource access info.", (Throwable)e);
            }
            this.metricsManager.buildFinished(build);
            for (Promotion promotion : build.getConfiguration().findPromotions()) {
                if (!promotion.isAutoPromote() || !(promotion = (Promotion)ScriptEngine.instance.installInterpolator(promotion)).getCondition().satisfied(promotion)) continue;
                promotion.promote(build, new HashMap<String, String>(), true);
            }
            build.getConfiguration().runPostBuildScript(build);
            for (Object listener2 : this.pluginManager.getExtensions(BuildListener.class)) {
                listener2.buildFinished();
            }
            HashSet<Long> triggerDependencies = new HashSet<Long>();
            for (TriggerDependencyContribution each : this.pluginManager.getExtensions(TriggerDependencyContribution.class)) {
                triggerDependencies.addAll(each.getTriggerDependencies(build));
            }
            Map<Long, Long> cachedTriggerDependencies = this.cacheManager.getTriggerDependencies(build.getConfiguration().getId());
            if (!((Object)triggerDependencies).equals(cachedTriggerDependencies.keySet())) {
                for (Long each : cachedTriggerDependencies.values()) {
                    this.triggerDependenceManager.delete(this.triggerDependenceManager.load(each));
                }
                for (Long each : triggerDependencies) {
                    TriggerDependence triggerDependence = new TriggerDependence();
                    triggerDependence.setDependency((Configuration)this.configurationManager.load(each));
                    triggerDependence.setDependent(build.getConfiguration());
                    this.triggerDependenceManager.save(triggerDependence);
                }
            }
            if (build.isSuccessful() && build.getConfiguration().findTriggerDependents().booleanValue()) {
                for (Long configurationId : this.cacheManager.getTriggerDependents(build.getConfiguration().getId())) {
                    BuildRequest request = new BuildRequest();
                    request.getTriggerDependencies().addAll(build.getRequest().getTriggerDependencies());
                    request.getTriggerDependencies().add(build.getConfiguration().getId());
                    if (request.getTriggerDependencies().contains(configurationId)) continue;
                    request.setConfigurationId(configurationId);
                    request.setRespectBuildCondition(false);
                    request.setRequesterId(build.getRequest().getRequesterId());
                    request.setScheduled(build.getRequest().isScheduled());
                    this.requestBuild(build.getRequester(), request.isScheduled(), request);
                }
            }
            break block99;
            catch (Throwable throwable222222) {
                Serializable canceller;
                if (ExceptionUtils.extractException(throwable222222, TimeoutException.class) != null) {
                    cachedTriggerDependencies = build.getRequest();
                    synchronized (cachedTriggerDependencies) {
                        build.setStatus(Build.Status.TIMEOUT);
                        build.setStatusDate(new Date());
                    }
                    Context.getLogger().error("Build is timed out.", throwable222222);
                } else if (ExceptionUtils.extractException(throwable222222, InterruptedException.class) != null) {
                    canceller = build.getRequest().getCancellerId() != null ? (User)UserManager.instance.load(build.getRequest().getCancellerId()) : null;
                    Iterator<Object> i$ = build.getRequest();
                    synchronized (i$) {
                        build.setCanceller((User)canceller);
                        build.setStatus(Build.Status.CANCELLED);
                        build.setStatusDate(new Date());
                    }
                    Context.getLogger().error("Build is cancelled.", throwable222222);
                } else {
                    canceller = build.getRequest();
                    synchronized (canceller) {
                        build.setStatus(Build.Status.FAILED);
                        build.setStatusDate(new Date());
                        build.setErrorMessage(build.obfuscateSecrets(ExceptionUtils.extractImportantMessage(throwable222222)));
                    }
                    Context.getLogger().error("Build is failed.", throwable222222);
                }
                BuildRequest throwable222222 = build.getRequest();
                synchronized (throwable222222) {
                    for (Step step : build.getSteps()) {
                        if (!step.isRunning() && !step.isWaiting()) continue;
                        step.setStatus(StepRuntime.Status.FAILED);
                        step.setErrorMessage("Build is already stopped.");
                    }
                    for (VariableWrapper var : build.getVariables().values()) {
                        build.getSecretAwareVariableValues().put(var.getName(), new SecretAwareString(var.getSnapshot(), null));
                    }
                    for (Map.Entry entry : build.getSecretAwareVariableValues().entrySet()) {
                        if (((SecretAwareString)entry.getValue()).getString() == null) continue;
                        String masked = build.obfuscateSecrets(((SecretAwareString)entry.getValue()).getString());
                        if (((SecretAwareString)entry.getValue()).getString().equals(masked)) continue;
                        ((SecretAwareString)entry.getValue()).setMasked(masked);
                    }
                    build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
                }
                if (build.getLogger() != null) {
                    build.getLogger().close();
                    build.setLogger(null);
                }
                this.buildManager.save(build);
                try {
                    HashMap<String, ResourceAccess> resourceAccesses = new HashMap<String, ResourceAccess>();
                    for (Step step : build.getSteps()) {
                        for (Map.Entry<String, Integer> entry : step.getResources().entrySet()) {
                            ResourceAccess access = (ResourceAccess)resourceAccesses.get(entry.getKey());
                            if (access == null) {
                                access = new ResourceAccess();
                                access.setConfiguration(build.getConfiguration());
                                access.setWhen(build.getBeginDate());
                                resourceAccesses.put(entry.getKey(), access);
                            }
                            if (step.getDuration() != null && entry.getValue() != null) {
                                access.setDuration(access.getDuration() + (long)entry.getValue().intValue() * step.getDuration());
                            }
                            access.getSteps().add(step.getName());
                        }
                    }
                    for (Map.Entry entry : resourceAccesses.entrySet()) {
                        Resource resource = this.cacheManager.getResource((String)entry.getKey());
                        if (resource == null) continue;
                        ((ResourceAccess)entry.getValue()).setResource(resource);
                        this.resourceAccessManager.saveOrUpdate((ResourceAccess)entry.getValue());
                    }
                }
                catch (Exception e) {
                    logger.error("Error writing resource access info.", (Throwable)e);
                }
                this.metricsManager.buildFinished(build);
                for (Promotion promotion : build.getConfiguration().findPromotions()) {
                    if (!promotion.isAutoPromote() || !(promotion = (Promotion)ScriptEngine.instance.installInterpolator(promotion)).getCondition().satisfied(promotion)) continue;
                    promotion.promote(build, new HashMap<String, String>(), true);
                }
                build.getConfiguration().runPostBuildScript(build);
                for (BuildListener listener3 : this.pluginManager.getExtensions(BuildListener.class)) {
                    listener3.buildFinished();
                }
                triggerDependencies = new HashSet<Long>();
                for (TriggerDependencyContribution each : this.pluginManager.getExtensions(TriggerDependencyContribution.class)) {
                    triggerDependencies.addAll(each.getTriggerDependencies(build));
                }
                cachedTriggerDependencies = this.cacheManager.getTriggerDependencies(build.getConfiguration().getId());
                if (!((Object)triggerDependencies).equals(cachedTriggerDependencies.keySet())) {
                    for (Long each : cachedTriggerDependencies.values()) {
                        this.triggerDependenceManager.delete(this.triggerDependenceManager.load(each));
                    }
                    for (Long each : triggerDependencies) {
                        TriggerDependence triggerDependence = new TriggerDependence();
                        triggerDependence.setDependency((Configuration)this.configurationManager.load(each));
                        triggerDependence.setDependent(build.getConfiguration());
                        this.triggerDependenceManager.save(triggerDependence);
                    }
                }
                if (build.isSuccessful() && build.getConfiguration().findTriggerDependents().booleanValue()) {
                    for (Long configurationId : this.cacheManager.getTriggerDependents(build.getConfiguration().getId())) {
                        BuildRequest request = new BuildRequest();
                        request.getTriggerDependencies().addAll(build.getRequest().getTriggerDependencies());
                        request.getTriggerDependencies().add(build.getConfiguration().getId());
                        if (request.getTriggerDependencies().contains(configurationId)) continue;
                        request.setConfigurationId(configurationId);
                        request.setRespectBuildCondition(false);
                        request.setRequesterId(build.getRequest().getRequesterId());
                        request.setScheduled(build.getRequest().isScheduled());
                        this.requestBuild(build.getRequester(), request.isScheduled(), request);
                    }
                }
                catch (Throwable throwable3) {
                    BuildRequest buildRequest2 = build.getRequest();
                    synchronized (buildRequest2) {
                        for (Step step : build.getSteps()) {
                            if (!step.isRunning() && !step.isWaiting()) continue;
                            step.setStatus(StepRuntime.Status.FAILED);
                            step.setErrorMessage("Build is already stopped.");
                        }
                        for (VariableWrapper var : build.getVariables().values()) {
                            build.getSecretAwareVariableValues().put(var.getName(), new SecretAwareString(var.getSnapshot(), null));
                        }
                        for (Map.Entry entry : build.getSecretAwareVariableValues().entrySet()) {
                            if (((SecretAwareString)entry.getValue()).getString() == null) continue;
                            String masked = build.obfuscateSecrets(((SecretAwareString)entry.getValue()).getString());
                            if (((SecretAwareString)entry.getValue()).getString().equals(masked)) continue;
                            ((SecretAwareString)entry.getValue()).setMasked(masked);
                        }
                        build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
                    }
                    if (build.getLogger() != null) {
                        build.getLogger().close();
                        build.setLogger(null);
                    }
                    this.buildManager.save(build);
                    try {
                        HashMap<String, ResourceAccess> resourceAccesses = new HashMap<String, ResourceAccess>();
                        for (Step step : build.getSteps()) {
                            for (Map.Entry<String, Integer> entry : step.getResources().entrySet()) {
                                ResourceAccess access = (ResourceAccess)resourceAccesses.get(entry.getKey());
                                if (access == null) {
                                    access = new ResourceAccess();
                                    access.setConfiguration(build.getConfiguration());
                                    access.setWhen(build.getBeginDate());
                                    resourceAccesses.put(entry.getKey(), access);
                                }
                                if (step.getDuration() != null && entry.getValue() != null) {
                                    access.setDuration(access.getDuration() + (long)entry.getValue().intValue() * step.getDuration());
                                }
                                access.getSteps().add(step.getName());
                            }
                        }
                        for (Map.Entry entry : resourceAccesses.entrySet()) {
                            Resource resource = this.cacheManager.getResource((String)entry.getKey());
                            if (resource == null) continue;
                            ((ResourceAccess)entry.getValue()).setResource(resource);
                            this.resourceAccessManager.saveOrUpdate((ResourceAccess)entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error writing resource access info.", (Throwable)e);
                    }
                    this.metricsManager.buildFinished(build);
                    for (Promotion promotion : build.getConfiguration().findPromotions()) {
                        if (!promotion.isAutoPromote() || !(promotion = (Promotion)ScriptEngine.instance.installInterpolator(promotion)).getCondition().satisfied(promotion)) continue;
                        promotion.promote(build, new HashMap<String, String>(), true);
                    }
                    build.getConfiguration().runPostBuildScript(build);
                    for (BuildListener listener4 : this.pluginManager.getExtensions(BuildListener.class)) {
                        listener4.buildFinished();
                    }
                    HashSet<Long> triggerDependencies2 = new HashSet<Long>();
                    for (TriggerDependencyContribution each : this.pluginManager.getExtensions(TriggerDependencyContribution.class)) {
                        triggerDependencies2.addAll(each.getTriggerDependencies(build));
                    }
                    Map<Long, Long> cachedTriggerDependencies2 = this.cacheManager.getTriggerDependencies(build.getConfiguration().getId());
                    if (!((Object)triggerDependencies2).equals(cachedTriggerDependencies2.keySet())) {
                        for (Long each : cachedTriggerDependencies2.values()) {
                            this.triggerDependenceManager.delete(this.triggerDependenceManager.load(each));
                        }
                        for (Long each : triggerDependencies2) {
                            TriggerDependence triggerDependence = new TriggerDependence();
                            triggerDependence.setDependency((Configuration)this.configurationManager.load(each));
                            triggerDependence.setDependent(build.getConfiguration());
                            this.triggerDependenceManager.save(triggerDependence);
                        }
                    }
                    if (build.isSuccessful() && build.getConfiguration().findTriggerDependents().booleanValue()) {
                        for (Long configurationId : this.cacheManager.getTriggerDependents(build.getConfiguration().getId())) {
                            BuildRequest request = new BuildRequest();
                            request.getTriggerDependencies().addAll(build.getRequest().getTriggerDependencies());
                            request.getTriggerDependencies().add(build.getConfiguration().getId());
                            if (request.getTriggerDependencies().contains(configurationId)) continue;
                            request.setConfigurationId(configurationId);
                            request.setRespectBuildCondition(false);
                            request.setRequesterId(build.getRequest().getRequesterId());
                            request.setScheduled(build.getRequest().isScheduled());
                            this.requestBuild(build.getRequester(), request.isScheduled(), request);
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private User getUser(Repository<?> repository, String committer) {
        String userName = repository.getUserName(committer);
        if (userName != null) {
            Context.getLogger().debug("Committer '{}' is mapped to QuickBuild user name '{}'.", (Object)committer, (Object)userName);
            User user = this.userManager.get(userName);
            if (user == null) {
                user = new User();
                user.setName(userName);
                if (this.emailPattern.matcher(userName).matches()) {
                    user.setEmail(userName);
                } else {
                    Context.getLogger().warn("Can not find mapped QuickBuild user '{}', trying to lookup email of committer '{}' from repository...", (Object)userName, (Object)committer);
                    try {
                        user.setEmail(repository.getEmail(committer));
                    }
                    catch (Exception e) {
                        Context.getLogger().error("Error retrieving email of user '{}' from repository '{}'.", (Object)committer, (Object)repository.getName());
                    }
                    if (user.getEmail() == null) {
                        Context.getLogger().warn("Committer email can not be found in repository, trying to lookup email of user '{}' from authenticators...", (Object)userName);
                        for (Authenticator authenticator : Quickbuild.getInstance(SettingManager.class).getSecuritySetting().getAuthenticators(true)) {
                            try {
                                AuthenticationResult result = authenticator.authenticate(userName, null);
                                if (result != null) {
                                    user.setEmail(result.getEmail());
                                }
                            }
                            catch (Exception e) {
                                Context.getLogger().error("Error retrieving email of user '{}' from authenticator '{}'.", (Object)userName, (Object)authenticator.getName());
                            }
                            if (user.getEmail() == null) continue;
                            break;
                        }
                    }
                }
            } else if (user.getEmail() == null) {
                if (userName.contains("@")) {
                    user.setEmail(userName);
                } else {
                    Context.getLogger().warn("Email of mapped QuickBuild user '{}' is not specified,  trying to lookup email of committer '{}' from repository...", (Object)userName, (Object)committer);
                    user.setEmail(repository.getEmail(committer));
                    if (user.getEmail() == null) {
                        Context.getLogger().warn("Committer email can not be found in repository,  trying to lookup email of user '{}' from authenticators...", (Object)userName);
                        for (Authenticator authenticator : Quickbuild.getInstance(SettingManager.class).getSecuritySetting().getAuthenticators(true)) {
                            AuthenticationResult result = authenticator.authenticate(userName, null);
                            if (result != null) {
                                user.setEmail(result.getEmail());
                            }
                            if (user.getEmail() == null) continue;
                            break;
                        }
                    }
                }
            }
            return user;
        }
        Context.getLogger().debug("Committer '{}' is ignored since it is mapped to null.", (Object)committer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotifications(Build build) {
        logger.info("Sending build notifications...");
        HashSet<User> committers = new HashSet<User>();
        for (Repository<?> repository : build.getRepositories()) {
            if (!repository.isCheckout()) continue;
            for (String committer : repository.getCommitters()) {
                User user = this.getUser(repository, committer);
                if (user == null) continue;
                committers.add(user);
            }
        }
        HashSet<User> committersSincePrevSuccess = null;
        HashMap notifyUsers = new HashMap();
        List<Notifier> notifiers = this.pluginManager.getExtensions(Notifier.class);
        for (Notifier notifier : notifiers) {
            for (String each : notifier.getChannelNames()) {
                notifyUsers.put(each, new HashSet());
            }
        }
        for (Map.Entry entry : notifyUsers.entrySet()) {
            HashSet<User> included = new HashSet<User>();
            HashSet<User> excluded = new HashSet<User>();
            if (!this.cacheManager.getSystemSetting().isDisableSubscriptions()) {
                Configuration current = build.getConfiguration();
                do {
                    HashSet<User> subscribers = new HashSet<User>();
                    HashSet<User> satisfiedSubscribers = new HashSet<User>();
                    try {
                        Session session = SessionManager.openSession();
                        session.lock((Object)current, LockMode.NONE);
                        for (Subscription subscription : current.getSubscriptions()) {
                            if (!current.getId().equals(build.getConfiguration().getId()) && !subscription.isSubscribeDescendents() || !subscription.getNotifier().equals(entry.getKey())) continue;
                            subscribers.add(subscription.getUser());
                            if (!subscription.getCondition().isSatisfied(build)) continue;
                            if (subscription.isCommitOnly()) {
                                if (!committers.contains(subscription.getUser())) continue;
                                satisfiedSubscribers.add(subscription.getUser());
                                continue;
                            }
                            satisfiedSubscribers.add(subscription.getUser());
                        }
                    }
                    finally {
                        SessionManager.closeSession();
                    }
                    for (User user : subscribers) {
                        if (excluded.contains(user)) continue;
                        if (satisfiedSubscribers.contains(user)) {
                            included.add(user);
                            continue;
                        }
                        excluded.add(user);
                    }
                } while ((current = current.getParent()) != null);
            }
            for (Notification notification : build.getConfiguration().findNotifications()) {
                if (!notification.getNotifier().equals(entry.getKey()) || !notification.getCondition().satisfied(notification)) continue;
                for (String receiver : notification.getReceivers()) {
                    User user;
                    if (receiver.equals("<trigger>")) {
                        if (build.getRequester() == null) continue;
                        included.add(build.getRequester());
                        continue;
                    }
                    if (receiver.equals("<committers since previous build>")) {
                        included.addAll(committers);
                        continue;
                    }
                    if (receiver.equals("<committers since previous successful>")) {
                        if (committersSincePrevSuccess == null) {
                            committersSincePrevSuccess = new HashSet<User>();
                            for (Repository repository : build.getRepositories()) {
                                if (!repository.isCheckout()) continue;
                                for (String committer : repository.getCommittersSincePrevSuccess()) {
                                    User user2 = this.getUser(repository, committer);
                                    if (user2 == null) continue;
                                    committersSincePrevSuccess.add(user2);
                                }
                            }
                        }
                        included.addAll(committersSincePrevSuccess);
                        continue;
                    }
                    if (receiver.startsWith("[")) {
                        SessionManager.openSession();
                        try {
                            String groupName = StringUtils.strip((String)receiver, (String)"[]");
                            Group group = this.groupManager.get(groupName);
                            if (group == null) {
                                logger.error("Can not notify group '" + groupName + "' as it does not exist.");
                                continue;
                            }
                            for (Membership membership : group.getMemberships()) {
                                included.add(membership.getUser());
                            }
                            continue;
                        }
                        finally {
                            SessionManager.closeSession();
                            continue;
                        }
                    }
                    user = this.userManager.get(receiver);
                    if (user == null) {
                        logger.error("Can not notify user '" + receiver + "' as it does not exist.");
                        continue;
                    }
                    included.add(user);
                }
            }
            if (Context.getLogger().isDebugEnabled()) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (User user : included) {
                    userNames.add(user.getName());
                }
                Collections.sort(userNames);
                Context.getLogger().debug("Sending {} notifications to: {}", entry.getKey(), (Object)StringUtils.join(userNames, (String)", "));
            }
            entry.setValue(included);
        }
        for (Notifier notifier : notifiers) {
            HashMap<String, Set<User>> notifierUsers = new HashMap<String, Set<User>>();
            for (String each : notifier.getChannelNames()) {
                Set channelUsers = (Set)notifyUsers.get(each);
                if (channelUsers == null || channelUsers.isEmpty()) continue;
                notifierUsers.put(each, channelUsers);
            }
            if (notifierUsers.isEmpty()) continue;
            notifier.notify(notifierUsers, Context.getBuild());
        }
    }

    @Override
    public void processImmediately() {
        this.processingSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                this.processingSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
                this.processingSemaphore.drainPermits();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DefaultBuildEngine defaultBuildEngine = this;
            synchronized (defaultBuildEngine) {
                List<BuildRequest> copyOfRequests = this.copyOfRequests();
                if (copyOfRequests.isEmpty() && this.thread == null) {
                    break;
                }
                if (copyOfRequests.isEmpty() || this.cacheManager.getSystemSetting().getPauseSystem() != null) {
                    continue;
                }
                try {
                    Date now = new Date();
                    HashSet<Long> processingConfigurationIds = new HashSet<Long>();
                    Iterator<BuildRequest> i$ = copyOfRequests.iterator();
                    while (i$.hasNext()) {
                        BuildRequest request;
                        BuildRequest buildRequest = request = i$.next();
                        synchronized (buildRequest) {
                            if (request.getStatus() != BuildRequest.Status.WAITING_PROCESS) {
                                processingConfigurationIds.add(request.getConfigurationId());
                            }
                        }
                    }
                    List<Resource> resources = CacheManager.instance.getResources();
                    Collection<GridNode> nodes = Grid.instance.getAllNodes();
                    ArrayList<GridNode> allNodesAndUserAgents = new ArrayList<GridNode>(nodes);
                    allNodesAndUserAgents.addAll(AgentManager.instance.getUserAgents());
                    for (GridNode node : allNodesAndUserAgents) {
                        node.getResources().clear();
                        node.setStepCount(0);
                        for (Resource resource : resources) {
                            node.getResources().put(resource.getName(), resource.getCount(node));
                        }
                        node.getWorkspaceUsages().clear();
                        for (BuildRequest request : copyOfRequests) {
                            Build build = request.getBuild();
                            BuildRequest buildRequest = request;
                            synchronized (buildRequest) {
                                for (final Step step : build.getSteps()) {
                                    if (!step.isRunning() || !step.getNodeAddress().equals(node.getAddress())) continue;
                                    for (Map.Entry<String, Integer> entry : step.getResources().entrySet()) {
                                        Integer count = node.getResources().get(entry.getKey());
                                        if (count == null) {
                                            count = 0;
                                        }
                                        count = count - entry.getValue();
                                        node.getResources().put(entry.getKey(), count);
                                    }
                                    node.setStepCount(node.getStepCount() + 1);
                                    node.getWorkspaceUsages().put(build.getConfiguration().getId(), request.getId());
                                }
                            }
                        }
                    }
                    for (final BuildRequest request : copyOfRequests) {
                        final Build build = request.getBuild();
                        GridNode userAgent = null;
                        User user = build.getRequester();
                        if (user != null) {
                            userAgent = AgentManager.instance.getUserAgent(user);
                        }
                        Context.push(build);
                        try {
                            List<Step> steps;
                            BuildRequest i$2 = request;
                            synchronized (i$2) {
                                block78: {
                                    if (!request.getBuild().isFinished()) break block78;
                                    continue;
                                }
                                if (request.getStatus() == BuildRequest.Status.WAITING_PROCESS) {
                                    if (!request.getRequestDate().before(now)) {
                                        String requestDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate());
                                        request.setWaitReason("Scheduled to run at " + requestDate);
                                    } else if (!request.getBuild().getConfiguration().findConcurrent().booleanValue() && processingConfigurationIds.contains(request.getConfigurationId())) {
                                        request.setWaitReason("A build request of this configuration is already in queue \nand builds of this configuration is set to run sequentially");
                                    } else {
                                        request.setWaitReason(null);
                                        request.setStatus(BuildRequest.Status.WAITING_NODE);
                                        this.activityDates.put(request.getConfigurationId(), new Date());
                                        Step masterStep = request.getBuild().getMasterStep();
                                        masterStep.setStatus(StepRuntime.Status.WAITING);
                                        processingConfigurationIds.add(request.getConfigurationId());
                                    }
                                }
                                steps = build.getSteps();
                            }
                            for (final Step step : steps) {
                                Context.pushStep(step);
                                try {
                                    StepRuntime.Status stepStatus;
                                    BuildRequest buildRequest = request;
                                    synchronized (buildRequest) {
                                        stepStatus = step.getStatus();
                                    }
                                    if (stepStatus != StepRuntime.Status.WAITING) continue;
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("Allocating step resource (configuration: {}, build: {}, step: {})...", new Object[]{build.getConfiguration(), build.getVersion() != null ? build.getVersion() : "not assigned", step.getPath()});
                                    }
                                    try {
                                        CloudProfile cloudProfile;
                                        ArrayList<GridNode> arrayList = new ArrayList<GridNode>();
                                        HashMap<String, Integer> requestedNodeInstanceIds = new HashMap<String, Integer>();
                                        logger.trace("Calculating candidate nodes...");
                                        HashMap<String, List<String>> waitingReasons = new HashMap<String, List<String>>();
                                        for (GridNode gridNode : nodes) {
                                            if (gridNode.isStopping()) continue;
                                            gridNode.setResourceChecked(false);
                                            MatchResult result = this.checkCandidate(gridNode, step);
                                            if (result.isMatched()) {
                                                arrayList.add(gridNode);
                                            } else if (!result.getReasons().isEmpty()) {
                                                waitingReasons.put(gridNode.getAddress(), result.getReasons());
                                            }
                                            if (gridNode.getLaunchId() == null) continue;
                                            requestedNodeInstanceIds.put(gridNode.getLaunchId(), gridNode.getStepCount());
                                        }
                                        if (userAgent != null) {
                                            userAgent.setResourceChecked(false);
                                            MatchResult result = this.checkCandidate(userAgent, step);
                                            if (result.isMatched()) {
                                                arrayList.add(userAgent);
                                            } else if (!result.getReasons().isEmpty()) {
                                                waitingReasons.put(userAgent.getAddress(), result.getReasons());
                                            }
                                        }
                                        if (!arrayList.isEmpty()) {
                                            logger.trace("Selecting preferred node from candiates...");
                                            GridNode selected = step.getNodePreference().getPreference(arrayList, step);
                                            Validate.notNull((Object)selected);
                                            selected.increaseUsedCount();
                                            selected.setLastJobDate(new Date());
                                            BuildRequest buildRequest2 = request;
                                            synchronized (buildRequest2) {
                                                step.setNode(selected);
                                                step.setResources(selected.getReservedResources());
                                                step.setStatus(StepRuntime.Status.RUNNING);
                                                step.setWaitReasons(null);
                                            }
                                            selected.takeReservedResources();
                                            selected.getWorkspaceUsages().put(build.getConfiguration().getId(), request.getId());
                                            CacheManager.instance.buildActive(build);
                                            if (!step.isMaster()) continue;
                                            BuildRequest buildRequest3 = request;
                                            synchronized (buildRequest3) {
                                                request.getBuild().setWaitDuration(System.currentTimeMillis() - request.getRequestDate().getTime());
                                                step.setWaitDuration(request.getBuild().getWaitDuration());
                                                request.setStatus(BuildRequest.Status.CHECKING_BUILD_CONDITION);
                                                this.activityDates.put(request.getConfigurationId(), new Date());
                                            }
                                            Quickbuild.getInstance().getExecutor().execute(new Runnable(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public void run() {
                                                    request.setThread(Thread.currentThread());
                                                    try {
                                                        try {
                                                            DefaultBuildEngine.this.process(request);
                                                        }
                                                        catch (Throwable e) {
                                                            logger.error("Error processing build request.", e);
                                                        }
                                                        Iterator i$ = DefaultBuildEngine.this.copyOfRequests().iterator();
                                                        while (i$.hasNext()) {
                                                            BuildRequest each;
                                                            BuildRequest buildRequest = each = (BuildRequest)i$.next();
                                                            synchronized (buildRequest) {
                                                                each.getUpstreamRequestIds().remove(request.getId());
                                                            }
                                                        }
                                                        DefaultBuildEngine.this.requestsLock.writeLock().lock();
                                                        try {
                                                            Iterator it = DefaultBuildEngine.this.requests.iterator();
                                                            while (it.hasNext()) {
                                                                if (!((BuildRequest)it.next()).getId().equals(request.getId())) continue;
                                                                DefaultBuildEngine.this.activityDates.put(request.getConfigurationId(), new Date());
                                                                it.remove();
                                                                break;
                                                            }
                                                        }
                                                        finally {
                                                            DefaultBuildEngine.this.requestsLock.writeLock().unlock();
                                                        }
                                                        if (request.getBuild().getId() != null) {
                                                            DefaultBuildEngine.this.builds.remove(request.getBuild().getId());
                                                        }
                                                        DefaultBuildEngine.this.processImmediately();
                                                        String errorMessage = null;
                                                        Map map = DefaultBuildEngine.this.buildIdCache;
                                                        synchronized (map) {
                                                            if (build.getId() != null) {
                                                                DefaultBuildEngine.this.buildIdCache.put(request.getId(), new SimpleCacheItem<Long>(build.getId()));
                                                            } else {
                                                                errorMessage = "Can not resolve requested build for configuration '" + build.getConfiguration() + "'. Check server log for details.";
                                                                DefaultBuildEngine.this.buildIdCache.put(request.getId(), new SimpleCacheItem<String>(errorMessage));
                                                            }
                                                        }
                                                        if (errorMessage != null) {
                                                            DefaultBuildEngine.this.notifyBuildId(request, errorMessage);
                                                        }
                                                    }
                                                    finally {
                                                        request.setThread(null);
                                                    }
                                                }
                                            });
                                            continue;
                                        }
                                        logger.trace("No candiate nodes found, checking cloud profiles...");
                                        boolean resourceChecked = false;
                                        for (GridNode node : nodes) {
                                            if (!node.isResourceChecked()) continue;
                                            resourceChecked = true;
                                            break;
                                        }
                                        if (userAgent != null && userAgent.isResourceChecked()) {
                                            resourceChecked = true;
                                        }
                                        if (!waitingReasons.isEmpty()) {
                                            step.setWaitReasons(waitingReasons);
                                        }
                                        if ((cloudProfile = this.findCloudProfile(step, resources)) != null) {
                                            try {
                                                if (step.getNodeLaunchId() != null) {
                                                    Integer stepCount = (Integer)requestedNodeInstanceIds.get(step.getNodeLaunchId());
                                                    if (stepCount == null) continue;
                                                    if (resourceChecked && stepCount != 0) {
                                                        if (cloudProfile.getMaxNodesToLaunch() != 0 && this.cacheManager.getTokenCount(cloudProfile.getId()) >= cloudProfile.getMaxNodesToLaunch()) continue;
                                                        this.launchNode(cloudProfile, step);
                                                        continue;
                                                    }
                                                    throw new QuickbuildException("Launched node does not match step node requirement.");
                                                }
                                                if (cloudProfile.getMaxNodesToLaunch() != 0 && this.cacheManager.getTokenCount(cloudProfile.getId()) >= cloudProfile.getMaxNodesToLaunch()) continue;
                                                this.launchNode(cloudProfile, step);
                                            }
                                            catch (HasToWaitException e) {
                                                logger.warn("Cloud profile '" + cloudProfile.getName() + "' is not able " + "to launch node for now: " + e.getMessage());
                                            }
                                            continue;
                                        }
                                        if (resourceChecked) continue;
                                        if (!waitingReasons.isEmpty() && logger.isDebugEnabled()) {
                                            logger.debug("No existing nodes matching step criteria (configuration: {}, step: {})", (Object)build.getConfiguration().getPathName(), (Object)step.getPath().toString());
                                            logger.debug("Reason: ");
                                            for (Map.Entry entry2 : waitingReasons.entrySet()) {
                                                logger.debug((String)entry2.getKey() + ": " + StringUtils.join((Collection)((Collection)entry2.getValue()), (String)"; "));
                                            }
                                        }
                                        throw new QuickbuildException("Can not find any node matching specified criteria.");
                                    }
                                    catch (Exception exception) {
                                        logger.error("Error allocating node for step '" + step.getPath() + "'.", (Throwable)exception);
                                        BuildRequest buildRequest4 = request;
                                        synchronized (buildRequest4) {
                                            step.setStatus(StepRuntime.Status.FAILED);
                                            step.setErrorMessage("Error allocating node for step '" + step.getPath() + "': " + build.obfuscateSecrets(ExceptionUtils.extractImportantMessage(exception)));
                                            if (step.isMaster()) {
                                                step.setStatus(StepRuntime.Status.FAILED);
                                                Quickbuild.getInstance().getExecutor().execute(new Runnable(){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void run() {
                                                        Object it;
                                                        Iterator i$ = DefaultBuildEngine.this.copyOfRequests().iterator();
                                                        while (i$.hasNext()) {
                                                            BuildRequest each;
                                                            BuildRequest buildRequest = each = (BuildRequest)i$.next();
                                                            synchronized (buildRequest) {
                                                                each.getUpstreamRequestIds().remove(request.getId());
                                                            }
                                                        }
                                                        DefaultBuildEngine.this.requestsLock.writeLock().lock();
                                                        try {
                                                            it = DefaultBuildEngine.this.requests.iterator();
                                                            while (it.hasNext()) {
                                                                if (!((BuildRequest)it.next()).getId().equals(request.getId())) continue;
                                                                it.remove();
                                                                break;
                                                            }
                                                        }
                                                        finally {
                                                            DefaultBuildEngine.this.requestsLock.writeLock().unlock();
                                                        }
                                                        if (request.getBuild().getId() != null) {
                                                            DefaultBuildEngine.this.builds.remove(request.getBuild().getId());
                                                        }
                                                        it = DefaultBuildEngine.this.buildIdCache;
                                                        synchronized (it) {
                                                            DefaultBuildEngine.this.buildIdCache.put(request.getId(), new SimpleCacheItem<String>(step.getErrorMessage()));
                                                        }
                                                        DefaultBuildEngine.this.notifyBuildId(request, step.getErrorMessage());
                                                        Session session = SessionManager.openSession();
                                                        try {
                                                            Configuration reloaded = (Configuration)DefaultBuildEngine.this.configurationManager.load(build.getConfiguration().getId());
                                                            reloaded.setErrorMessage(step.getErrorMessage());
                                                            reloaded.setStatusDate(new Date());
                                                            session.flush();
                                                        }
                                                        finally {
                                                            SessionManager.closeSession();
                                                        }
                                                        DefaultBuildEngine.this.activityDates.put(request.getConfigurationId(), new Date());
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                                finally {
                                    Context.popStep();
                                }
                            }
                        }
                        finally {
                            Context.pop();
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Error processing build requests.", t);
                }
            }
        }
    }

    private CloudProfile findCloudProfile(Step step, List<Resource> resources) {
        ArrayList<GridNode> virtualNodes = new ArrayList<GridNode>();
        for (CloudProfile profile : CacheManager.instance.getCloudProfiles()) {
            TestInfo testInfo = profile.getTestInfo();
            if (testInfo == null || testInfo.getNodeCharacteristics() == null) continue;
            GridNode node = new GridNode(UUID.randomUUID(), "0.0.0.0", 0, testInfo.isNodeOverSSL());
            node.setBenchmark(testInfo.getNodeBenchmark());
            node.setHostName("unknown");
            node.setIsServer(false);
            node.setSystemAttributes(testInfo.getNodeCharacteristics().getSystemAttributes());
            HashMap<String, String> userAttributes = new HashMap<String, String>(testInfo.getNodeCharacteristics().getUserAttributes());
            for (Property property : profile.getProfileAttributes()) {
                userAttributes.put(property.getName(), property.getValue());
            }
            node.setUserAttributes(userAttributes, false);
            node.setCloudProfile(profile);
            virtualNodes.add(node);
        }
        ArrayList<GridNode> candidates = new ArrayList<GridNode>();
        for (GridNode node : virtualNodes) {
            for (Resource resource : resources) {
                node.getResources().put(resource.getName(), resource.getCount(node));
            }
            node.setResourceChecked(false);
            if (!this.checkCandidate(node, step).isMatched()) continue;
            candidates.add(node);
        }
        if (!candidates.isEmpty()) {
            GridNode selected;
            ArrayList<GridNode> viableNodes = new ArrayList<GridNode>();
            for (GridNode candidate : candidates) {
                CloudProfile profile = candidate.getCloudProfile();
                if (profile.getMaxNodesToLaunch() != 0 && this.cacheManager.getTokenCount(profile.getId()) >= profile.getMaxNodesToLaunch()) continue;
                viableNodes.add(candidate);
            }
            if (!viableNodes.isEmpty()) {
                selected = step.getNodePreference().getPreference(viableNodes, step);
                Validate.notNull((Object)selected);
                return selected.getCloudProfile();
            }
            selected = step.getNodePreference().getPreference(candidates, step);
            Validate.notNull((Object)selected);
            return selected.getCloudProfile();
        }
        return null;
    }

    private void launchNode(CloudProfile cloudProfile, Step step) {
        logger.info("Launching cloud node (profile: {}, configuration: {}, step: {})...", new Object[]{cloudProfile.getName(), step.getBuild().getConfiguration().getPathName(), step.getName()});
        Token token = new Token();
        token.setHostName("Unknown");
        token.setPort(0);
        token.setIp(UUID.randomUUID().toString());
        token.setCloudProfile(cloudProfile);
        token.setValue(UUID.randomUUID().toString());
        step.setNodeLaunchId(cloudProfile.getNodeLauncher().launchNode("<$CloudNodeUserData$>" + token.getValue()));
        token.setNodeLaunchId(step.getNodeLaunchId());
        TokenManager.instance.save(token);
    }

    private MatchResult checkCandidate(GridNode node, Step step) {
        String requestId = node.getWorkspaceUsages().get(step.getBuild().getConfiguration().getId());
        if (requestId == null || requestId.equals(step.getBuild().getRequest().getId())) {
            node.getReservedResources().clear();
            if (!step.getBuild().getConfiguration().findNodeAssignment().matches(node)) {
                return new MatchResult(false, "Excluded by node assignment rule of the configuration");
            }
            return step.getNodeMatcher().matches(step, node);
        }
        node.setResourceChecked(true);
        return new MatchResult(false, "Workspace already occupied by another build of the same configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BuildRequest> copyOfRequests() {
        this.requestsLock.readLock().lock();
        try {
            ArrayList<BuildRequest> arrayList = new ArrayList<BuildRequest>(this.requests);
            return arrayList;
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getCanceller(String requestId) {
        this.requestsLock.readLock().lock();
        try {
            for (BuildRequest request : this.requests) {
                if (!request.getId().equals(requestId)) continue;
                BuildRequest buildRequest = request;
                synchronized (buildRequest) {
                    Long l = request.getCancellerId();
                    return l;
                }
            }
            Long l = null;
            return l;
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
    }

    @Override
    public List<BuildRequest> getBuildRequests(Long configurationId) {
        return this.getBuildRequests(configurationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BuildRequest> getBuildRequests(Long configurationId, Long triggerUserId) {
        ArrayList<BuildRequest> requestsClone = new ArrayList<BuildRequest>();
        for (BuildRequest request : this.copyOfRequests()) {
            if (configurationId != null && !configurationId.equals(request.getConfigurationId()) || triggerUserId != null && !triggerUserId.equals(request.getRequesterId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                BuildRequest requestClone = request.clone();
                Build buildClone = request.getBuild().clone();
                requestClone.setBuild(buildClone);
                buildClone.setRequest(requestClone);
                requestsClone.add(requestClone);
            }
        }
        return requestsClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Integer> getBuildRequestCountAsMap() {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        this.requestsLock.readLock().lock();
        try {
            for (BuildRequest request : this.requests) {
                Integer count = (Integer)map.get(request.getConfigurationId());
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                map.put(request.getConfigurationId(), count);
            }
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBuildRequestCount(Long configurationId) {
        this.requestsLock.readLock().lock();
        try {
            int count = 0;
            for (BuildRequest request : this.requests) {
                if (!request.getConfigurationId().equals(configurationId)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
    }

    @Override
    public void cancelRequest(String requestId) {
        this.cancelRequest(null, requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cancelRequest(String initiatingRequestId, String requestId) {
        Long buildId = null;
        BuildRequest requestToCancel = null;
        String errorMessage = null;
        this.requestsLock.writeLock().lock();
        try {
            Iterator<BuildRequest> it = this.requests.iterator();
            while (it.hasNext()) {
                BuildRequest request = it.next();
                if (!request.getId().equals(requestId)) continue;
                BuildRequest buildRequest = request;
                synchronized (buildRequest) {
                    if (request.getStatus() == BuildRequest.Status.WAITING_PROCESS || request.getStatus() == BuildRequest.Status.WAITING_NODE) {
                        it.remove();
                        buildId = request.getBuild().getId();
                        errorMessage = "Build request is cancelled.";
                        Map<String, SimpleCacheItem<Object>> map = this.buildIdCache;
                        synchronized (map) {
                            this.buildIdCache.put(requestId, new SimpleCacheItem<String>(errorMessage));
                        }
                        requestToCancel = request;
                    } else {
                        Long cancellerId = null;
                        if (initiatingRequestId != null) {
                            cancellerId = this.getCanceller(initiatingRequestId);
                        }
                        if (cancellerId != null) {
                            request.setCancellerId(cancellerId);
                        } else if (Context.getUser() != null) {
                            request.setCancellerId(Context.getUser().getId());
                        }
                        Thread thread = request.getThread();
                        if (thread != null) {
                            thread.interrupt();
                        }
                    }
                    break;
                }
            }
        }
        finally {
            this.requestsLock.writeLock().unlock();
        }
        if (requestToCancel != null) {
            this.notifyBuildId(requestToCancel, errorMessage);
        }
        if (buildId != null) {
            this.builds.remove(buildId);
        }
    }

    @Override
    public void startup() {
        File requestsFile = this.getRequestsFile();
        if (requestsFile.exists()) {
            this.requests = (List)SerializationHelper.deserialize(FileUtils.readFileAsBytes(requestsFile));
            logger.warn("Found persist requests: will process in 5 minutes in order to make sure all agents are connected.");
            Date processTime = new DateTime().plusMinutes(5).toDate();
            for (BuildRequest request : this.requests) {
                if (!request.getRequestDate().before(processTime)) continue;
                request.setRequestDate(processTime);
            }
            FileUtils.deleteFile(requestsFile);
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRequests() {
        this.requestsLock.readLock().lock();
        try {
            boolean bl = !this.requests.isEmpty();
            return bl;
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
    }

    private File getRequestsFile() {
        return new File(Bootstrap.installDir, "requests.ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<BuildRequest> persistRequests = new ArrayList<BuildRequest>();
        DefaultBuildEngine defaultBuildEngine = this;
        synchronized (defaultBuildEngine) {
            this.thread = null;
            this.requestsLock.writeLock().lock();
            try {
                Iterator<BuildRequest> it = this.requests.iterator();
                while (it.hasNext()) {
                    BuildRequest request = it.next();
                    if (request.getStatus() != BuildRequest.Status.WAITING_PROCESS && request.getStatus() != BuildRequest.Status.WAITING_NODE) continue;
                    persistRequests.add(request);
                    it.remove();
                }
            }
            finally {
                this.requestsLock.writeLock().unlock();
            }
        }
        this.processImmediately();
        if (persistRequests.isEmpty()) {
            if (this.getRequestsFile().exists()) {
                FileUtils.deleteFile(this.getRequestsFile());
            }
        } else {
            FileUtils.writeFile(this.getRequestsFile(), SerializationHelper.serialize(persistRequests));
        }
        logger.info("Waiting for finish of existing build requests...");
        while (this.hasRequests()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestResult requestBuild(User requester, boolean scheduled, BuildRequest request) {
        if (this.thread == null) {
            throw new QuickbuildException("SYSTEM IS BEING SHUT DOWN NOW: not builds can be requesed");
        }
        request.setStatus(BuildRequest.Status.WAITING_PROCESS);
        request.setScheduled(scheduled);
        Configuration configuration = (Configuration)this.configurationManager.load(request.getConfigurationId());
        if (!request.getTriggerDependencies().isEmpty() && configuration.findDisabled().booleanValue()) {
            logger.warn("Build request is ignored as configuration '{}' is triggered by dependency but it is disabled.", (Object)configuration);
            return new RequestResult(null, false, "Build request is ignored as the configuration is disabled and trigger source is a dependency.");
        }
        Build build = new Build();
        build.setConfiguration(configuration);
        build.setRequester(requester);
        if (requester != null && request.getRequesterId() == null) {
            request.setRequesterId(requester.getId());
        }
        HashMap<String, String> variableValues = new HashMap<String, String>();
        if (request.getPromotionSource() != null) {
            Build promotedFrom;
            PromotionSource source = request.getPromotionSource();
            if (source.getServer() != null) {
                WebResource resource = RestModule.resource(source.getServer().getUrl(), "rest/builds/" + source.getBuildId(), source.getServer().getUserName(), source.getServer().getPassword());
                promotedFrom = (Build)resource.get(Build.class);
                promotedFrom.setConfiguration(configuration);
            } else {
                promotedFrom = (Build)this.buildManager.load(source.getBuildId());
                build.setPromotedFrom(promotedFrom);
            }
            build.getRepositoryRuntimes().putAll(promotedFrom.getRepositoryRuntimes());
            for (Map.Entry<String, SecretAwareString> entry : promotedFrom.getSecretAwareVariableValues().entrySet()) {
                if (configuration.findVar(entry.getKey()) != null) continue;
                variableValues.put(entry.getKey(), entry.getValue().getString());
            }
        }
        variableValues.putAll(request.getVariables());
        for (Map.Entry entry : variableValues.entrySet()) {
            VariableWrapper var = new VariableWrapper((String)entry.getKey(), (String)entry.getValue());
            Variable varDef = configuration.findVar(var.getName());
            if (varDef != null && (varDef.getValueProvider() instanceof SecretValueProvider || varDef.getPromptSetting() instanceof PromptAsPasswordInput)) {
                var.setSecret(true);
            }
            var.setSnapshot((String)entry.getValue());
            build.getVariables().put((String)entry.getKey(), var);
        }
        build.setScheduled(scheduled);
        Date now = new Date();
        request.setRequestDate(new Date(now.getTime() - 1L));
        build.setRequest(request);
        request.setBuild(build);
        Context.push(build);
        try {
            request.setPriority(configuration.findPriority());
            if (!configuration.runPreQueueScript()) {
                Map.Entry entry;
                logger.warn("Build request for '{}' is ignored as pre-queue script evaluates to false.", (Object)configuration.getPathName());
                entry = new RequestResult(null, false, "Build request is ignored pre-queue script evaluates to false.");
                return entry;
            }
            if (request.getShortBranch() == null) {
                ArrayList<ShortBranch> shortBranches = null;
                HashSet<String> processedRepoNames = new HashSet<String>();
                for (Repository<?> repository : configuration.getReferencedRepositories()) {
                    if (processedRepoNames.contains(repository.getName())) continue;
                    processedRepoNames.add(repository.getName());
                    Collection<ShortBranch> eachShortBranches = repository.getShortBranches();
                    if (eachShortBranches == null) continue;
                    if (shortBranches == null) {
                        shortBranches = new ArrayList<ShortBranch>(eachShortBranches);
                        continue;
                    }
                    throw new QuickbuildException("Only one repository can build against multiple branches in a single configuration.");
                }
                if (shortBranches != null) {
                    Serializable lastShortBranches;
                    if (shortBranches.isEmpty()) {
                        logger.warn("No any short branches to build.");
                    } else {
                        lastShortBranches = configuration.getShortBranches();
                        if (lastShortBranches == null) {
                            lastShortBranches = new ArrayList();
                        }
                        HashMap<String, ShortBranch> hashMap = new HashMap<String, ShortBranch>();
                        for (ShortBranch each : lastShortBranches) {
                            hashMap.put(each.getName(), each);
                        }
                        for (ShortBranch shortBranch : shortBranches) {
                            ShortBranch lastShortBranch;
                            if (configuration.findQueueChangedBranchesOnly().booleanValue() && (lastShortBranch = (ShortBranch)hashMap.get(shortBranch.getName())) != null && shortBranch.getRevision().equals(lastShortBranch.getRevision())) {
                                Context.getLogger().info("Will not queue build request for branch '{}' of configuration '{}' as it does not have new commits since last check.", (Object)shortBranch.getName(), (Object)configuration.getPathName());
                                continue;
                            }
                            Context.getLogger().info("Requesting build of branch {} of configuration '{}'...", (Object)shortBranch, (Object)configuration.getPathName());
                            final User newRequester = requester;
                            final boolean newScheduled = scheduled;
                            final BuildRequest newRequest = new BuildRequest();
                            newRequest.setConfigurationId(request.getConfigurationId());
                            newRequest.setRespectBuildCondition(request.isRespectBuildCondition());
                            newRequest.setShortBranch(shortBranch);
                            newRequest.getVariables().putAll(request.getVariables());
                            newRequest.setPromotionSource(request.getPromotionSource());
                            newRequest.getTriggerDependencies().addAll(request.getTriggerDependencies());
                            newRequest.setUpstreamConfigurationId(request.getUpstreamConfigurationId());
                            newRequest.getUpstreamRequestIds().addAll(request.getUpstreamRequestIds());
                            Quickbuild.getInstance().getExecutor().submit(new Runnable(){

                                @Override
                                public void run() {
                                    DefaultBuildEngine.this.requestBuild(newRequester, newScheduled, newRequest);
                                }
                            });
                        }
                    }
                    this.configurationManager.saveShortBranches(configuration, shortBranches);
                    lastShortBranches = new RequestResult(null, false, "Build requested for configured branches.");
                    return lastShortBranches;
                }
            } else {
                build.setShortBranch(request.getShortBranch().getName());
            }
        }
        finally {
            Context.pop();
        }
        HashMap<String, BuildRequest> id2request = new HashMap<String, BuildRequest>();
        this.requestsLock.readLock().lock();
        try {
            for (BuildRequest each : this.requests) {
                id2request.put(each.getId(), each);
            }
        }
        finally {
            this.requestsLock.readLock().unlock();
        }
        BuildRequest upstreamRequest = !request.getUpstreamRequestIds().isEmpty() ? (BuildRequest)id2request.get(request.getUpstreamRequestIds().iterator().next()) : null;
        if (upstreamRequest != null) {
            SimpleCacheItem<String> simpleCacheItem;
            request.setInitialRequestId(upstreamRequest.getInitialRequestId());
            BuildRequest loopedRequest = this.findLoopedRequest(id2request, upstreamRequest, request);
            if (loopedRequest != null) {
                return new RequestResult(loopedRequest.getId(), true, null);
            }
            Map<RequestKey, SimpleCacheItem<String>> i$ = this.requestIdCache;
            synchronized (i$) {
                simpleCacheItem = this.requestIdCache.get(new RequestKey(request.getInitialRequestId(), request.getConfigurationId(), request.getVariables()));
            }
            if (simpleCacheItem != null) {
                BuildRequest identicalRequest = (BuildRequest)id2request.get(simpleCacheItem.getData());
                if (identicalRequest != null) {
                    BuildRequest buildRequest = identicalRequest;
                    synchronized (buildRequest) {
                        identicalRequest.getUpstreamRequestIds().add(upstreamRequest.getId());
                    }
                    this.processImmediately();
                }
                return new RequestResult(simpleCacheItem.getData());
            }
            request.setId(UUID.randomUUID().toString());
        } else {
            request.setId(UUID.randomUUID().toString());
            request.setInitialRequestId(request.getId());
        }
        if (request.getRequestDate().before(now) && request.getPromotionSource() == null && request.getUpstreamRequestIds().isEmpty()) {
            for (BuildRequest buildRequest : this.copyOfRequests()) {
                boolean noUpstreamRequests;
                if (!buildRequest.getRequestDate().before(now) || buildRequest.getStatus() != BuildRequest.Status.WAITING_PROCESS && buildRequest.getStatus() != BuildRequest.Status.WAITING_NODE || buildRequest.getPromotionSource() != null || !ObjectUtils.equals((Object)buildRequest.getShortBranch(), (Object)request.getShortBranch()) || !buildRequest.getConfigurationId().equals(request.getConfigurationId()) || !ObjectUtils.equals((Object)buildRequest.getRequesterId(), (Object)request.getRequesterId()) || !((Object)buildRequest.getVariables()).equals(request.getVariables())) continue;
                BuildRequest buildRequest2 = buildRequest;
                synchronized (buildRequest2) {
                    noUpstreamRequests = buildRequest.getUpstreamRequestIds().isEmpty();
                }
                if (!noUpstreamRequests) continue;
                logger.warn("Build request for '{}' is ignored as there is an identical request in queue.", (Object)configuration.getPathName());
                return new RequestResult(null, false, "Build request is ignored as there is an identical request in queue.");
            }
        }
        if (this.thread == null) {
            throw new QuickbuildException("System is being shutting down.");
        }
        this.requestsLock.writeLock().lock();
        try {
            if (this.thread == null) {
                throw new QuickbuildException("SYSTEM IS BEING SHUT DOWN NOW: not builds can be requesed");
            }
            int index = 0;
            for (BuildRequest each : this.requests) {
                if (build.getRequest().getPriority() > each.getPriority()) break;
                if (build.getRequest().getPriority() < each.getPriority()) {
                    ++index;
                    continue;
                }
                if (build.getRequest().getRequestDate().before(each.getRequestDate())) break;
                ++index;
            }
            this.requests.add(index, request);
        }
        finally {
            this.requestsLock.writeLock().unlock();
        }
        this.metricsManager.buildRequestSubmitted();
        Map<Object, SimpleCacheItem<Object>> map = this.buildIdCache;
        synchronized (map) {
            this.buildIdCache.put(request.getId(), new SimpleCacheItem<Object>(null));
        }
        this.processImmediately();
        map = this.requestIdCache;
        synchronized (map) {
            this.requestIdCache.put(new RequestKey(request.getInitialRequestId(), request.getConfigurationId(), request.getVariables()), new SimpleCacheItem<String>(request.getId()));
        }
        this.activityDates.put(request.getConfigurationId(), new Date());
        return new RequestResult(request.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildRequest findLoopedRequest(Map<String, BuildRequest> id2request, BuildRequest current, BuildRequest target) {
        HashSet<String> upstreamRequestIds;
        if (current.getInitialRequestId().equals(target.getInitialRequestId()) && current.getConfigurationId().equals(target.getConfigurationId())) {
            return current;
        }
        BuildRequest buildRequest = current;
        synchronized (buildRequest) {
            upstreamRequestIds = new HashSet<String>(current.getUpstreamRequestIds());
        }
        for (String upstreamId : upstreamRequestIds) {
            BuildRequest looped;
            BuildRequest upstream = id2request.get(upstreamId);
            if (upstream == null || (looped = this.findLoopedRequest(id2request, upstream, target)) == null) continue;
            return looped;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(final Configuration configuration) {
        Map<Long, String> map = this.scheduledTasks;
        synchronized (map) {
            String taskId = this.scheduledTasks.remove(configuration.getId());
            if (taskId != null) {
                logger.debug("Unscheduling configuration '" + configuration + "'...");
                this.taskScheduler.unschedule(taskId);
            }
            Context.push(configuration);
            try {
                final Schedule schedule = configuration.findSchedule();
                if (!(configuration.isDisabled() || schedule instanceof NoSchedule || schedule.isPaused())) {
                    logger.debug("Scheduling configuration '" + configuration + "'...");
                    taskId = this.taskScheduler.schedule(new SchedulableTask(){

                        @Override
                        public void execute() {
                            Quickbuild.getInstance().getExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    logger.debug("Scheduled time reaches for configuration '" + configuration + "', " + "checking for schedule random setting...");
                                    BuildRequest request = new BuildRequest();
                                    request.setConfigurationId(configuration.getId());
                                    request.setRespectBuildCondition(true);
                                    if (schedule.getRandomRange() != 0) {
                                        long secondsToSleep = RandomUtils.nextInt((int)schedule.getRandomRange());
                                        logger.debug("Sleep for '" + secondsToSleep + "' seconds before triggering " + "configuration '" + configuration + "...");
                                        try {
                                            Thread.sleep((long)RandomUtils.nextInt((int)schedule.getRandomRange()) * 1000L);
                                        }
                                        catch (InterruptedException e) {
                                            // empty catch block
                                        }
                                    }
                                    logger.debug("Requesting build for configuration '" + configuration + "'...");
                                    DefaultBuildEngine.this.requestBuild(null, true, request);
                                    if (configuration.findAuditBuildRequest().booleanValue()) {
                                        AuditManager.instance.audit(configuration, "Build request was submitted by scheduler.");
                                    }
                                }
                            });
                        }

                        @Override
                        public Schedule getSchedule() {
                            return schedule;
                        }
                    });
                    this.scheduledTasks.put(configuration.getId(), taskId);
                }
            }
            catch (Exception e) {
                logger.error("Error scheduling configuration: " + configuration, (Throwable)e);
            }
            finally {
                Context.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleChanged(Configuration configuration) {
        this.schedule(configuration);
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        Session session = SessionManager.openSession();
        try {
            Query query = session.createQuery("select id, name, schedule, disabled, variables from Configuration where parent.id=:id");
            query.setParameter("id", (Object)configuration.getId());
            for (Object[] row : query.list()) {
                Configuration child = new Configuration();
                child.setId((Long)row[0]);
                child.setName((String)row[1]);
                child.setSchedule((Schedule)row[2]);
                child.setDisabled((Boolean)row[3]);
                child.setVariables((ArrayList)row[4]);
                child.setParent(configuration);
                if (child.getSchedule() != null && child.getDisabled() != null) continue;
                children.add(child);
            }
        }
        finally {
            SessionManager.closeSession();
        }
        for (Configuration child : children) {
            this.scheduleChanged(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleAll() {
        HashMap<Long, Configuration> configurations = new HashMap<Long, Configuration>();
        Session session = SessionManager.openSession();
        try {
            Query query = session.createQuery("select id, name, schedule, disabled, variables, parent.id from Configuration");
            for (Object[] row : query.list()) {
                Configuration each = new Configuration();
                each.setId((Long)row[0]);
                each.setName((String)row[1]);
                each.setSchedule((Schedule)row[2]);
                each.setDisabled((Boolean)row[3]);
                each.setVariables((ArrayList)row[4]);
                if (row[5] != null) {
                    each.setParent(new Configuration());
                    each.getParent().setId((Long)row[5]);
                }
                configurations.put(each.getId(), each);
            }
            for (Configuration each : configurations.values()) {
                if (each.getParent() == null) continue;
                each.setParent((Configuration)configurations.get(each.getParent().getId()));
            }
        }
        finally {
            SessionManager.closeSession();
        }
        for (Configuration each : configurations.values()) {
            this.schedule(each);
        }
    }

    @Override
    public boolean isStarted() {
        return this.thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getBuildId(String requestId, String nodeAddress) {
        SimpleCacheItem<Object> cacheItem;
        if (nodeAddress != null) {
            for (BuildRequest buildRequest : this.copyOfRequests()) {
                if (!buildRequest.getId().equals(requestId)) continue;
                Long buildId = buildRequest.getBuild().getId();
                if (buildId == null) {
                    BuildRequest buildRequest2 = buildRequest;
                    synchronized (buildRequest2) {
                        buildRequest.getWaitingNodes().add(nodeAddress);
                    }
                }
                return buildId;
            }
        }
        Map<String, SimpleCacheItem<Object>> map = this.buildIdCache;
        synchronized (map) {
            cacheItem = this.buildIdCache.get(requestId);
        }
        if (cacheItem != null) {
            Object object = cacheItem.getData();
            if (object == null) {
                return null;
            }
            if (object instanceof Long) {
                return (Long)object;
            }
            throw new QuickbuildException(object.toString());
        }
        throw new QuickbuildException("Build is too old to be requested.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleCacheItem<Object> getBuildIdCacheItem(String requestId) {
        Map<String, SimpleCacheItem<Object>> map = this.buildIdCache;
        synchronized (map) {
            return this.buildIdCache.get(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Build getBuild(Long buildId) {
        Build build = this.builds.get(buildId);
        if (build != null) {
            BuildRequest buildRequest = build.getRequest();
            synchronized (buildRequest) {
                if (build.isFinished()) {
                    return null;
                }
                return build.clone();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBuildDescription(Long buildId, String buildDescription) {
        Build build = this.builds.get(buildId);
        if (build != null) {
            BuildRequest buildRequest = build.getRequest();
            synchronized (buildRequest) {
                build.setDescription(buildDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelAllRequests() {
        BuildRequest request;
        ArrayList<BuildRequest> requestsToCancel = new ArrayList<BuildRequest>();
        this.requestsLock.writeLock().lock();
        try {
            Iterator<BuildRequest> it = this.requests.iterator();
            while (it.hasNext()) {
                BuildRequest buildRequest = request = it.next();
                // MONITORENTER : buildRequest
                if (request.getStatus() == BuildRequest.Status.WAITING_PROCESS || request.getStatus() == BuildRequest.Status.WAITING_NODE) {
                    it.remove();
                    requestsToCancel.add(request);
                    String errorMessage = "Build request is cancelled.";
                    Map<String, SimpleCacheItem<Object>> map = this.buildIdCache;
                    // MONITORENTER : map
                    this.buildIdCache.put(request.getId(), new SimpleCacheItem<String>(errorMessage));
                    // MONITOREXIT : map
                } else {
                    Thread thread = request.getThread();
                    if (thread != null) {
                        thread.interrupt();
                    }
                    if (Context.getUser() != null) {
                        request.setCancellerId(Context.getUser().getId());
                    }
                }
                // MONITOREXIT : buildRequest
            }
        }
        finally {
            this.requestsLock.writeLock().unlock();
        }
        Iterator i$ = requestsToCancel.iterator();
        while (i$.hasNext()) {
            request = (BuildRequest)i$.next();
            this.notifyBuildId(request, "Build request is cancelled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBuild(Long buildId) {
        for (BuildRequest request : this.copyOfRequests()) {
            if (!buildId.equals(request.getBuild().getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                Thread thread;
                if (Context.getUser() != null) {
                    request.setCancellerId(Context.getUser().getId());
                }
                if ((thread = request.getThread()) != null) {
                    thread.interrupt();
                }
                return;
            }
        }
        Build build = (Build)this.buildManager.load(buildId);
        if (build.isRunning()) {
            build.setStatus(Build.Status.CANCELLED);
            build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
            build.setCanceller(Context.getUser());
            for (StepRuntime runtime : build.getStepRuntimes().values()) {
                if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                runtime.setStatus(StepRuntime.Status.CANCELLED);
            }
            this.buildManager.save(build);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Map.Entry<Object, SimpleCacheItem<Object>> entry;
        Iterator<Map.Entry<Object, SimpleCacheItem<Object>>> it;
        Map<Object, SimpleCacheItem<Object>> map = this.requestIdCache;
        synchronized (map) {
            it = this.requestIdCache.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().getTimestamp().before(DateUtils.addDays((Date)new Date(), (int)-3))) continue;
                it.remove();
            }
        }
        map = this.buildIdCache;
        synchronized (map) {
            it = this.buildIdCache.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().getTimestamp().before(DateUtils.addDays((Date)new Date(), (int)-3))) continue;
                it.remove();
            }
        }
    }

    @Override
    public Schedule getSchedule() {
        CronSchedule schedule = new CronSchedule();
        schedule.setExpression("0 0 0 * * ?");
        return schedule;
    }

    @Override
    public Date getActivityDate(Long configurationId) {
        Date activityDate = this.activityDates.get(configurationId);
        if (activityDate != null) {
            return activityDate;
        }
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationRemoved(Long configurationId) {
        this.activityDates.remove(configurationId);
        Map<Long, String> map = this.scheduledTasks;
        synchronized (map) {
            String taskId = this.scheduledTasks.remove(configurationId);
            if (taskId != null) {
                this.taskScheduler.unschedule(taskId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBuildId(BuildRequest request, Object buildId) {
        HashSet<String> waitingNodes;
        BuildRequest buildRequest = request;
        synchronized (buildRequest) {
            waitingNodes = new HashSet<String>(request.getWaitingNodes());
        }
        for (String nodeAddress : waitingNodes) {
            try {
                GridNode node = Grid.instance.getNode(nodeAddress);
                if (node == null) continue;
                node.getNodeService().cacheBuildId(request.getId(), buildId);
            }
            catch (Exception e) {
                logger.warn("Error caching build id on node '" + nodeAddress + ".", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBuildStatus(Build build) {
        Build.Status buildStatus;
        Long buildId;
        ArrayList<String> waitingNodes;
        BuildRequest buildRequest = build.getRequest();
        synchronized (buildRequest) {
            waitingNodes = new ArrayList<String>(build.getWaitingNodes());
            buildId = build.getId();
            buildStatus = build.getStatus();
        }
        for (String nodeAddress : waitingNodes) {
            try {
                GridNode node = Grid.instance.getNode(nodeAddress);
                if (node == null) continue;
                node.getNodeService().cacheBuildStatus(buildId, buildStatus);
            }
            catch (Exception e) {
                logger.warn("Error caching build status on node '" + nodeAddress + ".", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceAllocation allocateResource(Long buildId, Map<String, VariableWrapper> vars, StepPath stepPath) {
        Build build = null;
        for (BuildRequest request : this.copyOfRequests()) {
            build = request.getBuild();
            if (!buildId.equals(build.getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                Step step = build.getStep(stepPath);
                Validate.notNull((Object)step);
                step.setVariableWrappers(vars);
                if (!step.isMaster() && step.getNodeMatcher() instanceof ParentNodeMatcher) {
                    Context.push(build);
                    try {
                        GridNode parentNode = step.getParent().getNode();
                        parentNode.increaseUsedCount();
                        step.setNode(parentNode);
                        step.setStatus(StepRuntime.Status.RUNNING);
                        step.setWaitReasons(null);
                        CacheManager.instance.buildActive(build);
                        ResourceAllocation resourceAllocation = new ResourceAllocation(parentNode, step.getResources(), step.getVariableWrappers());
                        return resourceAllocation;
                    }
                    finally {
                        Context.pop();
                    }
                }
                step.setStatus(StepRuntime.Status.WAITING);
                CacheManager.instance.buildActive(build);
                this.processImmediately();
                break;
            }
        }
        if (build == null) {
            throw new QuickbuildException("Can not allocate resource as build is not being processed.");
        }
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            BuildRequest buildRequest = build.getRequest();
            synchronized (buildRequest) {
                Step step = build.getStep(stepPath);
                Validate.notNull((Object)step);
                if (step.getErrorMessage() != null) {
                    throw new QuickbuildException(step.getErrorMessage());
                }
                if (step.getNode() != null) {
                    return new ResourceAllocation(step.getNode(), step.getResources(), step.getVariableWrappers());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepUpdated(Long buildId, StepPath stepPath, StepRuntime runtime) {
        for (BuildRequest request : this.copyOfRequests()) {
            Build build = request.getBuild();
            if (!buildId.equals(build.getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                GridNode node;
                build.getStepRuntimes().put(stepPath.toString(), runtime);
                if ((runtime.getStatus() == StepRuntime.Status.FAILED || runtime.getStatus() == StepRuntime.Status.SUCCESSFUL || runtime.getStatus() == StepRuntime.Status.CANCELLED || runtime.getStatus() == StepRuntime.Status.TIMEOUT) && (node = Grid.instance.getNode(runtime.getNodeAddress())) != null) {
                    node.setLastJobDate(new Date());
                }
                CacheManager.instance.buildActive(build);
                this.processImmediately();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepSkipped(Long buildId, StepPath stepPath) {
        for (BuildRequest request : this.copyOfRequests()) {
            Build build = request.getBuild();
            if (!buildId.equals(build.getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                StepRuntime runtime = new StepRuntime();
                runtime.setStatus(StepRuntime.Status.IDLE);
                build.getStepRuntimes().put(stepPath.toString(), runtime);
                CacheManager.instance.buildActive(build);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Build.Status getBuildStatus(Long buildId, String nodeAddress) {
        for (BuildRequest request : this.copyOfRequests()) {
            if (!buildId.equals(request.getBuild().getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                if (!request.getBuild().isFinished() && nodeAddress != null) {
                    request.getBuild().getWaitingNodes().add(nodeAddress);
                }
                return request.getBuild().getStatus();
            }
        }
        return BuildManager.instance.getStatus(buildId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Build> getPromotions() {
        ArrayList<Build> builds = new ArrayList<Build>();
        for (BuildRequest request : this.copyOfRequests()) {
            if (request.getBuild().getPromotedFrom() == null) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                Build buildClone = request.getBuild().clone();
                buildClone.setRequest(new BuildRequest());
                buildClone.getRequest().setId(request.getId());
                builds.add(buildClone);
            }
        }
        return builds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getWaitReasons(String requestId, String stepPath) {
        for (BuildRequest request : this.copyOfRequests()) {
            if (!requestId.equals(request.getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                Step step = request.getBuild().getStep(stepPath);
                if (step != null) {
                    return step.getWaitReasons();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getWaitReasons(Long buildId, String stepPath) {
        for (BuildRequest request : this.copyOfRequests()) {
            if (!buildId.equals(request.getBuild().getId())) continue;
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                Step step = request.getBuild().getStep(stepPath);
                if (step != null) {
                    return step.getWaitReasons();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunningStepInfo> getRunningSteps(String nodeAddress) {
        ArrayList<RunningStepInfo> runningSteps = new ArrayList<RunningStepInfo>();
        Iterator<BuildRequest> i$ = this.copyOfRequests().iterator();
        while (i$.hasNext()) {
            BuildRequest request;
            BuildRequest buildRequest = request = i$.next();
            synchronized (buildRequest) {
                for (Step step : request.getBuild().getSteps()) {
                    if (!nodeAddress.equals(step.getNodeAddress()) || !step.isRunning()) continue;
                    RunningStepInfo stepInfo = new RunningStepInfo();
                    stepInfo.setBuildId(request.getBuild().getId());
                    stepInfo.setConfigurationId(request.getConfigurationId());
                    stepInfo.setRequestId(request.getId());
                    stepInfo.setStepPath(step.getPath().toString());
                    stepInfo.setStepRuntime(step.getRuntime().clone());
                    runningSteps.add(stepInfo);
                }
            }
        }
        return runningSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void terminateIdleBuildAgents() {
        HashSet<String> nodeAddressesInUse;
        List<GridNode> activeBuildAgents;
        ArrayList<GridNode> agentsToStop = new ArrayList<GridNode>();
        DefaultBuildEngine defaultBuildEngine = this;
        synchronized (defaultBuildEngine) {
            activeBuildAgents = this.agentManager.getBuildAgents();
            nodeAddressesInUse = new HashSet<String>();
            this.requestsLock.readLock().lock();
            try {
                Iterator<BuildRequest> i$ = this.requests.iterator();
                while (i$.hasNext()) {
                    BuildRequest request;
                    BuildRequest buildRequest = request = i$.next();
                    synchronized (buildRequest) {
                        for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                            if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                            nodeAddressesInUse.add(runtime.getNodeAddress());
                        }
                    }
                }
            }
            finally {
                this.requestsLock.readLock().unlock();
            }
            long now = System.currentTimeMillis();
            for (GridNode buildAgent : activeBuildAgents) {
                if (buildAgent.getCloudProfile() == null || buildAgent.getLaunchId() == null || nodeAddressesInUse.contains(buildAgent.getAddress())) continue;
                try {
                    if ((now - buildAgent.getLastJobDate().getTime()) / 60000L <= (long)buildAgent.getCloudProfile().getIdleTimeToTerminate()) continue;
                    logger.info("Stopping idle launched node (address: {}, launch id: {})...", (Object)buildAgent.getAddress(), (Object)buildAgent.getLaunchId());
                    buildAgent.setStopping(true);
                    agentsToStop.add(buildAgent);
                }
                catch (Exception e) {
                    logger.error("Error stopping idle on-demand nodes.", (Throwable)e);
                }
            }
        }
        for (GridNode agent : agentsToStop) {
            agent.getNodeService().stop();
        }
        HashSet<String> activeTokens = new HashSet<String>();
        for (GridNode each : activeBuildAgents) {
            activeTokens.add(each.getToken());
        }
        Iterator<Serializable> i$ = CacheManager.instance.getTokens().iterator();
        while (i$.hasNext()) {
            Token token = (Token)i$.next();
            if (token.getCloudProfile() == null || token.getNodeLaunchId() == null || token.getPort() == 0 || activeTokens.contains(token.getValue()) || nodeAddressesInUse.contains(token.getAddress())) continue;
            try {
                logger.info("Terminating inactive launched node (address: {}, launch id: {})...", (Object)token.getAddress(), (Object)token.getNodeLaunchId());
                CloudProfile cloudProfile = CacheManager.instance.getCloudProfile(token.getCloudProfile().getId());
                if (cloudProfile == null) continue;
                cloudProfile.getNodeLauncher().terminateNode(token.getNodeLaunchId());
                TokenManager.instance.delete(TokenManager.instance.load(token.getId()));
            }
            catch (Exception e) {
                logger.error("Error terminating idle launched nodes.", (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }
}

