/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.RepositoryAccessor;
import com.pmease.quickbuild.stepsupport.ParameterAccessor;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepAccessor;
import com.pmease.quickbuild.util.CookieUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.util.Util;
import com.pmease.quickbuild.variable.VariableAccessor;
import com.pmease.quickbuild.web.ContextAware;
import com.pmease.quickbuild.web.page.BasePage;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    public static final String USER_TIMEZONE_ATTRNAME = "QuickBuildUserTimeZone";
    private static final ThreadLocal<TimeZone> userTimeZoneHolder = new ThreadLocal();
    private static ThreadLocal<Stack<Build>> buildStack = new ThreadLocal<Stack<Build>>(){

        @Override
        protected Stack<Build> initialValue() {
            return new Stack<Build>();
        }
    };
    private static ThreadLocal<User> userHolder = new ThreadLocal();
    private static ThreadLocal<Stack<Step>> stepStack = new ThreadLocal<Stack<Step>>(){

        @Override
        protected Stack<Step> initialValue() {
            return new Stack<Step>();
        }
    };
    private static ThreadLocal<Stack<Component>> componentStack = new ThreadLocal<Stack<Component>>(){

        @Override
        protected Stack<Component> initialValue() {
            return new Stack<Component>();
        }
    };
    private static final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    public static final String NODE_KEY = "node";
    public static final String CONFIGURATION_KEY = "configuration";
    public static final String BUILD_KEY = "build";

    public static Configuration getConfiguration() {
        Build build = Context.get();
        if (build != null) {
            return build.getConfiguration();
        }
        return null;
    }

    public static Build getBuild() {
        Build build = Context.get();
        if (build != null && HibernateUtils.getId(build) != null) {
            return build;
        }
        return null;
    }

    public static BuildRequest getRequest() {
        Build build = Context.get();
        if (build != null) {
            return build.getRequest();
        }
        return null;
    }

    public static Build get() {
        if (!buildStack.get().isEmpty()) {
            return buildStack.get().peek();
        }
        Component component = Context.getComponent();
        while (component != null) {
            if (component instanceof ContextAware) {
                return ((ContextAware)((Object)component)).getContext();
            }
            Component trigger = component.getMetaData(BasePage.TRIGGER);
            if (trigger != null) {
                component = trigger;
                continue;
            }
            component = component.getParent();
        }
        return null;
    }

    public static boolean isBackend() {
        return Context.get() != null && Context.get().getRequest() != null;
    }

    public static void push(Build build) {
        buildStack.get().push(build);
    }

    public static void push(Configuration configuration) {
        Build build = new Build();
        build.setConfiguration(configuration);
        buildStack.get().push(build);
    }

    public static void pop() {
        buildStack.get().pop();
    }

    public static void clear() {
        buildStack.get().clear();
    }

    public static User getUser() {
        if (Context.isBackend()) {
            return Context.get().getRequester();
        }
        return userHolder.get();
    }

    public static void setUser(User user) {
        userHolder.set(user);
    }

    public static void pushStep(Step step) {
        stepStack.get().push(step);
    }

    public static void popStep() {
        stepStack.get().pop();
    }

    public static Step getStep() {
        if (!stepStack.get().isEmpty()) {
            return stepStack.get().peek();
        }
        return null;
    }

    public static Logger getLogger(int stackBacktrackCount) {
        Build build = Context.getBuild();
        if (build != null && build.getLogger() != null && !build.getLogger().isClosed()) {
            return build.getLogger();
        }
        if (stackBacktrackCount == -1) {
            return logger;
        }
        String className = StringUtils.substringBefore((String)new Throwable().getStackTrace()[stackBacktrackCount].getClassName(), (String)"$");
        Logger logger = loggers.get(className);
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)className);
            loggers.put(className, logger);
        }
        return logger;
    }

    public static Logger getLogger() {
        return Context.getLogger(2);
    }

    public static Map<String, Object> buildEvalContext(Object currentObj, Map customContext) {
        HashMap<String, Object> context = customContext != null ? new HashMap(customContext) : new HashMap<String, Object>();
        if (context.get(BUILD_KEY) == null) {
            context.put(BUILD_KEY, Context.getBuild());
        }
        if (context.get(CONFIGURATION_KEY) == null) {
            context.put(CONFIGURATION_KEY, Context.getConfiguration());
        }
        context.put("request", Context.getRequest());
        context.put("user", Context.getUser());
        Grid buildGrid = Quickbuild.getInstance(Grid.class);
        context.put("grid", buildGrid);
        if (context.get(NODE_KEY) == null) {
            context.put(NODE_KEY, buildGrid.getLocalNode());
        }
        context.put("system", Quickbuild.getInstance());
        context.put("util", new Util());
        context.put("vars", new VariableAccessor());
        context.put("steps", new StepAccessor());
        context.put("step", Context.getStep());
        context.put("repositories", new RepositoryAccessor());
        context.put("current", currentObj);
        context.put("logger", Context.getLogger(-1));
        context.put("params", new ParameterAccessor());
        return context;
    }

    public static TimeZone getTimeZone() {
        if (Context.getUserTimeZone() != null) {
            return Context.getUserTimeZone();
        }
        return TimeZone.getDefault();
    }

    public static void clearUserTimeZone() {
        userTimeZoneHolder.set(null);
    }

    public static TimeZone getUserTimeZone() {
        return userTimeZoneHolder.get();
    }

    public static void detectUserTimeZone(HttpServletRequest request) {
        if (CacheManager.instance.getSystemSetting().isDetectTimeZone()) {
            HttpSession session = request.getSession(true);
            TimeZone userTimeZone = (TimeZone)session.getAttribute(USER_TIMEZONE_ATTRNAME);
            if (userTimeZone == null) {
                String cookieValue = CookieUtils.getCookieValue(request, USER_TIMEZONE_ATTRNAME);
                if (cookieValue != null) {
                    logger.debug("Detected user time zone for current request: " + cookieValue);
                    userTimeZone = Context.toTimeZone(cookieValue);
                    session.setAttribute(USER_TIMEZONE_ATTRNAME, (Object)userTimeZone);
                    userTimeZoneHolder.set(userTimeZone);
                }
            } else {
                userTimeZoneHolder.set(userTimeZone);
            }
        }
    }

    private static TimeZone toTimeZone(String timeZoneCookieValue) {
        boolean isDST = timeZoneCookieValue.contains(" ");
        String tempStr = StringUtils.substringBefore((String)timeZoneCookieValue, (String)" ");
        boolean isNegative = tempStr.startsWith("-");
        tempStr = StringUtils.stripStart((String)tempStr, (String)"+-");
        int hour = Integer.parseInt(StringUtils.substringBefore((String)tempStr, (String)":"));
        int minute = Integer.parseInt(StringUtils.substringAfter((String)tempStr, (String)":"));
        long offsetMillis = (long)(hour * 3600) * 1000L + (long)(minute * 60) * 1000L;
        if (isNegative) {
            offsetMillis *= -1L;
        }
        for (String id : TimeZone.getAvailableIDs()) {
            TimeZone timeZone;
            if (id.equals("America/Creston") || (long)(timeZone = TimeZone.getTimeZone(id)).getRawOffset() != offsetMillis || timeZone.useDaylightTime() != isDST) continue;
            return timeZone;
        }
        logger.warn("Can not find id for user time zone '" + timeZoneCookieValue + "', use server time zone instead.");
        return TimeZone.getDefault();
    }

    public static void pushComponent(Component component) {
        componentStack.get().push(component);
    }

    public static void popComponent() {
        componentStack.get().pop();
    }

    public static Component getComponent() {
        if (!componentStack.get().isEmpty()) {
            return componentStack.get().peek();
        }
        return null;
    }
}

