/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CheckConditionJob;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTask;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class CheckConditionTask
extends GridTask<Build, Boolean> {
    private Build build;

    public CheckConditionTask(Build build) {
        this.build = build;
    }

    @Override
    protected Map<? extends GridJob, GridNode> map(Build build) {
        HashMap<CheckConditionJob, GridNode> map = new HashMap<CheckConditionJob, GridNode>();
        Step masterStep = build.getMasterStep();
        GridNode node = masterStep.getNode();
        Validate.notNull((Object)node);
        map.put(new CheckConditionJob(this.getId(), build), node);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean reduce(Collection<GridJob> jobs) {
        CheckConditionJob job = (CheckConditionJob)jobs.iterator().next();
        if (job.getException() != null) {
            throw new RuntimeException("Error executing check condition job.", job.getException());
        }
        Build jobBuild = job.getBuild();
        BuildRequest buildRequest = this.build.getRequest();
        synchronized (buildRequest) {
            this.build.getRepositoryRuntimes().putAll(jobBuild.getRepositoryRuntimes());
            this.build.getRepositoryCache().putAll(jobBuild.getRepositoryCache());
            for (Repository<?> repository : this.build.getRepositoryCache().values()) {
                if (repository == null) continue;
                repository.setBuild(this.build);
            }
            this.build.getVariables().putAll(jobBuild.getVariables());
            for (Map.Entry entry : jobBuild.getSecretAwareVariableValues().entrySet()) {
                this.build.getSecretAwareVariableValues().put((String)entry.getKey(), new SecretAwareString((SecretAwareString)entry.getValue()));
            }
        }
        return job.isNecessary();
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void jobFinished(GridJob job, GridNode node) {
    }
}

