/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckConditionJob
extends GridJob {
    private static final Logger logger = LoggerFactory.getLogger(CheckConditionJob.class);
    private Build build;
    private boolean necessary;

    public CheckConditionJob(String taskId, Build build) {
        super(taskId);
        this.build = build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        Configuration configuration = this.build.getConfiguration();
        Context.push(this.build);
        try {
            FileUtils.createDir(configuration.getWorkspaceDir());
            logger.info("Taking repository snapshots...");
            configuration.takeSnapshot();
            if (this.build.getRequest().isRespectBuildCondition()) {
                logger.info("Evaluating build condition...");
                this.necessary = configuration.isBuildNecessary();
            } else {
                this.necessary = true;
            }
        }
        finally {
            Context.pop();
        }
    }

    public Build getBuild() {
        return this.build;
    }

    public boolean isNecessary() {
        return this.necessary;
    }
}

