/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.google.inject.ImplementedBy;
import com.pmease.quickbuild.DefaultCacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.ResourceAccess;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.TriggerDependence;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.setting.system.AlertRetentionSetting;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.setting.system.SystemSetting;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.util.Pair;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ImplementedBy(value=DefaultCacheManager.class)
public interface CacheManager
extends SchedulableTask {
    public static final CacheManager instance = Quickbuild.getCacheManager();

    public Configuration getConfiguration(Long var1);

    public Configuration cloneConfiguration(Long var1);

    public int getConfigurationCount();

    public Map<Long, Configuration> getConfigurations();

    public Map<Long, Configuration> cloneConfigurations();

    public Build getFirstBuild(Long var1);

    public Build getLatestBuild(Long var1);

    public Map<Long, Build> getLatestBuilds();

    public Build cloneLatestBuild(Long var1);

    public long getBaseDuration(Long var1);

    public long getHistoryCount(Long var1);

    public void configurationSaved(Configuration var1, boolean var2);

    public void configurationRemoved(Long var1);

    public int getChildrenCount(Long var1);

    public List<Configuration> getChildren(Long var1);

    public List<Configuration> getDescendents(Long var1);

    public Set<Long> getDescendentIds(Long var1);

    public Set<Long> getTriggerDependents(Long var1);

    public Date getLastAccessTimeOfResource(Long var1);

    public void resourceUsageSaved(ResourceAccess var1);

    public Map<Long, Long> getTriggerDependencies(Long var1);

    public void triggerDependenceSaved(TriggerDependence var1);

    public void triggerDependenceRemoved(Long var1);

    public boolean hasChildren(Long var1);

    public void buildRemoved(Build var1);

    public void buildActive(Build var1);

    public void buildSaved(Build var1, boolean var2);

    public void buildMoved(Build var1, Long var2);

    public Pair<Build, Date> getActiveBuild(Long var1);

    public void initialize();

    public List<Authorization> getAuthorizations(Long var1);

    public List<Group> getGroups(Long var1);

    public List<Dashboard> getDashboardsOwnedByUser(Long var1);

    public List<Dashboard> getDashboardsAccessibleByGroup(Long var1);

    public List<Dashboard> getDashboardsAccessibleByUser(Long var1);

    public List<String> getGroupsSharedWithDashboard(Long var1);

    public List<String> getUsersSharedWithDashboard(Long var1);

    public void membershipRemoved(Long var1);

    public void membershipSaved(Membership var1);

    public void dashboardSaved(Dashboard var1);

    public void dashboardRemoved(Long var1);

    public Dashboard getDashboard(Long var1);

    public void groupShareSaved(GroupShare var1);

    public void groupShareRemoved(Long var1);

    public void alarmSaved(Alarm var1);

    public void alarmRemoved(Long var1);

    public List<Alarm> getUserAlarms(Long var1);

    public GroupShare getGroupShare(Long var1);

    public void userShareSaved(UserShare var1);

    public void userShareRemoved(Long var1);

    public UserShare getUserShare(Long var1);

    public void authorizationRemoved(Long var1);

    public void authorizationSaved(Authorization var1);

    public void groupRemoved(Long var1);

    public void groupSaved(Group var1);

    public void permissionSetRemoved(Long var1);

    public void permissionSetSaved(PermissionSet var1);

    public PermissionSet getPermissionSet(Long var1);

    public PermissionSet getPermissionSet(String var1);

    public Group getGroup(String var1);

    public Group getGroup(Long var1);

    public void tokenRemoved(Long var1);

    public void tokenSaved(Token var1);

    public Token getToken(String var1);

    public Token getToken(String var1, int var2);

    public Token getTokenByAddress(String var1);

    public Token getToken(Long var1);

    public List<Token> getTokens();

    public int getTokenCount();

    public void userRemoved(Long var1);

    public void userSaved(User var1);

    public User getUser(Long var1);

    public User getUser(String var1);

    public void cloudProfileRemoved(Long var1);

    public void cloudProfileSaved(CloudProfile var1);

    public CloudProfile getCloudProfile(String var1);

    public CloudProfile getCloudProfile(Long var1);

    public List<CloudProfile> getCloudProfiles();

    public SystemSetting getSystemSetting();

    public AlertRetentionSetting getAlertRetentionSetting();

    public License getLicense();

    public void systemSettingSaved(SystemSetting var1);

    public EmailSetting getEmailSetting();

    public void emailSettingSaved(EmailSetting var1);

    public void alertSettingSaved(AlertRetentionSetting var1);

    public void licenseSaved(License var1);

    public void resourceSaved(Resource var1);

    public void resourceRemoved(Long var1);

    public Resource getResource(Long var1);

    public Resource getResource(String var1);

    public List<Resource> getResources();

    public boolean isAgentAllowed(User var1);

    public int getTokenCount(Long var1);
}

