/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.PromotionSource;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BuildRequest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Long configurationId;
    private boolean respectBuildCondition;
    private Set<Long> triggerDependencies;
    private ShortBranch shortBranch;
    private Map<String, String> variables;
    private PromotionSource promotionSource;
    private Set<String> upstreamRequestIds;
    private Long upstreamConfigurationId;
    private transient Set<String> waitingNodes;
    private volatile transient String waitReason;
    private String id;
    private String initialRequestId;
    private Integer priority;
    private Date requestDate;
    private Long requesterId;
    private Long cancellerId;
    private Boolean scheduled;
    private Build build;
    private volatile Status status = Status.WAITING_PROCESS;
    private volatile transient Thread thread;

    @ScriptApi(value="Get identifier of this build request.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ScriptApi(value="Get status of this build request.")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @ScriptApi(value="Get identifier of the configuration against which build is requested.")
    public Long getConfigurationId() {
        return this.configurationId;
    }

    public ShortBranch getShortBranch() {
        return this.shortBranch;
    }

    public void setShortBranch(ShortBranch shortBranch) {
        this.shortBranch = shortBranch;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    @ScriptApi(value="Get promotion source. Null if the build process is not a promotion.")
    public PromotionSource getPromotionSource() {
        return this.promotionSource;
    }

    public void setPromotionSource(PromotionSource promotionSource) {
        this.promotionSource = promotionSource;
    }

    @ScriptApi(value="Whether or not respect build condition.")
    public boolean isRespectBuildCondition() {
        return this.respectBuildCondition;
    }

    @ScriptApi(value="Specify whether or not to respect build condition.")
    public void setRespectBuildCondition(boolean respectBuildCondition) {
        this.respectBuildCondition = respectBuildCondition;
    }

    public Map<String, String> getVariables() {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        return this.variables;
    }

    public Set<Long> getTriggerDependencies() {
        if (this.triggerDependencies == null) {
            this.triggerDependencies = new HashSet<Long>();
        }
        return this.triggerDependencies;
    }

    public String getInitialRequestId() {
        return this.initialRequestId;
    }

    public void setInitialRequestId(String initialRequestId) {
        this.initialRequestId = initialRequestId;
    }

    public Set<String> getUpstreamRequestIds() {
        if (this.upstreamRequestIds == null) {
            this.upstreamRequestIds = new HashSet<String>();
        }
        return this.upstreamRequestIds;
    }

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    @ScriptApi(value="Get priority of the build request.")
    public Integer getPriority() {
        return this.priority;
    }

    @ScriptApi(value="Specify priority of the build request.")
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @ScriptApi(value="Get request date of this build request.")
    public Date getRequestDate() {
        return this.requestDate;
    }

    @ScriptApi(value="Set request date of this build request.")
    public void setRequestDate(Date scheduleDate) {
        this.requestDate = scheduleDate;
    }

    @ScriptApi(value="Get identifier of the user who requested the build. Null for anonymous user or build scheduler.")
    public Long getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(Long requesterId) {
        this.requesterId = requesterId;
    }

    @ScriptApi(value="Get identifier of the user who cancelled the build. Null for anonymous user.")
    public Long getCancellerId() {
        return this.cancellerId;
    }

    public void setCancellerId(Long cancellerId) {
        this.cancellerId = cancellerId;
    }

    @ScriptApi(value="Whether or not this is a scheduled build.")
    public Boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
    }

    public Long getUpstreamConfigurationId() {
        return this.upstreamConfigurationId;
    }

    public void setUpstreamConfigurationId(Long upstreamConfigurationId) {
        this.upstreamConfigurationId = upstreamConfigurationId;
    }

    @ScriptApi(value="Get display name of the user who requested the build.")
    public String getRequesterName() {
        if (this.isScheduled().booleanValue()) {
            return "Scheduler";
        }
        if (this.getRequesterId() == null) {
            return "Anonymous";
        }
        User requester = (User)Quickbuild.getInstance(UserManager.class).load(this.getRequesterId());
        if (requester.getFullName() != null) {
            return requester.getName() + " (" + requester.getFullName() + ")";
        }
        return requester.getName();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Set<String> getWaitingNodes() {
        if (this.waitingNodes == null) {
            this.waitingNodes = new HashSet<String>();
        }
        return this.waitingNodes;
    }

    public String getWaitReason() {
        return this.waitReason;
    }

    public void setWaitReason(String waitReason) {
        this.waitReason = waitReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildRequest)) {
            return false;
        }
        BuildRequest otherRequest = (BuildRequest)other;
        return new EqualsBuilder().append((Object)this.getId(), (Object)otherRequest.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }

    public BuildRequest clone() {
        BuildRequest clone = new BuildRequest();
        clone.cancellerId = this.cancellerId;
        clone.configurationId = this.configurationId;
        clone.id = this.id;
        clone.priority = this.priority;
        clone.promotionSource = this.promotionSource;
        clone.requestDate = this.requestDate;
        clone.requesterId = this.requesterId;
        clone.respectBuildCondition = this.respectBuildCondition;
        clone.upstreamConfigurationId = this.upstreamConfigurationId;
        clone.scheduled = this.scheduled;
        clone.waitReason = this.waitReason;
        clone.status = this.status;
        clone.variables = this.variables;
        clone.upstreamRequestIds = new HashSet<String>(this.upstreamRequestIds);
        return clone;
    }

    public static enum Status {
        WAITING_PROCESS,
        WAITING_NODE,
        CHECKING_BUILD_CONDITION,
        RUNNING_BUILD,
        COLLECTING_BUILD_METRICS,
        SENDING_BUILD_NOTIFICATIONS,
        AGGREGATING_METRICS;

    }
}

