/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTask;
import com.pmease.quickbuild.log.BuildLogger;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;

public abstract class BuildAwareTask<T, R>
extends GridTask<T, R> {
    private Build build;

    public BuildAwareTask(Build build) {
        this.build = build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinished(GridJob job, GridNode node) {
        BuildAwareJob buildAwareJob = (BuildAwareJob)job;
        GridNode localNode = Grid.instance.getLocalNode();
        if (!node.getId().equals(localNode.getId())) {
            File tempFile = new File(Bootstrap.getTempDir(), buildAwareJob.getLogName());
            try {
                Grid.instance.transferFile(node, buildAwareJob.getLogDir() + "/" + tempFile.getName(), localNode, tempFile.getAbsolutePath(), null, null);
                BuildLogger logger = this.build.getLogger();
                if (logger != null) {
                    logger.append(tempFile);
                }
            }
            finally {
                if (tempFile.exists()) {
                    FileUtils.deleteFile(tempFile);
                }
            }
        }
    }

    public Build getBuild() {
        return this.build;
    }

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("buildVersion")) {
            this.build.setVersion(value);
            this.buildVersionChanged();
        }
    }

    protected void buildVersionChanged() {
    }
}

