/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.BuildAwareTask;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.log.BuildLogger;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.step.FileTransferOption;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;

public abstract class BuildAwareJob
extends GridJob {
    private static final long serialVersionUID = 1L;
    public static final String BUILDVERSION_ATTRNAME = "buildVersion";
    private Build build;
    private String logDir;

    public BuildAwareJob(String taskId, Build build) {
        super(taskId);
        this.build = build;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getLogName() {
        return "job_" + this.getId() + ".log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        BuildLogger logger = null;
        this.logDir = Bootstrap.getTempDir().getAbsolutePath();
        GridTaskFuture<?> taskFuture = Grid.instance.getTaskFuture(this.getTaskId());
        if (taskFuture != null) {
            BuildAwareTask task = (BuildAwareTask)taskFuture.getTask();
            logger = task.getBuild().getLogger();
        }
        if (logger == null) {
            this.build.setLogger(new BuildLogger(new File(Bootstrap.getTempDir(), this.getLogName()), this.build.getConfiguration().findLogLevel(this.build)));
        } else {
            this.build.setLogger(logger);
        }
        this.build.setJob(this);
        Context.push(this.build);
        try {
            this.executeBuildAwareJob();
        }
        finally {
            Context.pop();
            if (logger == null) {
                this.build.getLogger().close();
            }
        }
    }

    @Override
    protected void cleanup() {
        File logFile = new File(Bootstrap.getTempDir(), this.getLogName());
        if (logFile.exists()) {
            FileUtils.deleteFile(logFile);
        }
    }

    public void fetchInputFiles(FileTransferOption option) {
        String localDir;
        String remoteDir;
        Configuration configuration = this.getBuild().getConfiguration();
        GridNode localNode = Quickbuild.getInstance(Grid.class).getLocalNode();
        if (option.getSrcPath() != null) {
            if (this.getTaskNode().isAbsolute(option.getSrcPath())) {
                remoteDir = option.getSrcPath();
            } else {
                remoteDir = this.getTaskNode().getWorkspaceDir(configuration.getId());
                remoteDir = remoteDir + "/" + option.getSrcPath();
            }
        } else {
            remoteDir = this.getTaskNode().getWorkspaceDir(configuration.getId());
        }
        if (option.getDestPath() != null) {
            if (new File(option.getDestPath()).isAbsolute()) {
                localDir = option.getDestPath();
            } else {
                localDir = configuration.getWorkspaceDir().getAbsolutePath();
                localDir = localDir + "/" + option.getDestPath();
            }
        } else {
            localDir = configuration.getWorkspaceDir().getAbsolutePath();
        }
        Grid.instance.transferFiles(this.getTaskNode(), remoteDir, option.getFilePatterns(), localNode, localDir, option.isCompress(), null, null);
    }

    public void sendOutputFiles(FileTransferOption option) {
        String remoteDir;
        String localDir;
        GridNode localNode = Quickbuild.getInstance(Grid.class).getLocalNode();
        Configuration configuration = this.getBuild().getConfiguration();
        if (option.getSrcPath() != null) {
            if (new File(option.getSrcPath()).isAbsolute()) {
                localDir = option.getSrcPath();
            } else {
                localDir = configuration.getWorkspaceDir().getAbsolutePath();
                localDir = localDir + "/" + option.getSrcPath();
            }
        } else {
            localDir = configuration.getWorkspaceDir().getAbsolutePath();
        }
        if (option.getDestPath() != null) {
            if (this.getTaskNode().isAbsolute(option.getDestPath())) {
                remoteDir = option.getDestPath();
            } else {
                remoteDir = this.getTaskNode().getWorkspaceDir(configuration.getId());
                remoteDir = remoteDir + "/" + option.getDestPath();
            }
        } else {
            remoteDir = this.getTaskNode().getWorkspaceDir(configuration.getId());
        }
        Grid.instance.transferFiles(localNode, localDir, option.getFilePatterns(), this.getTaskNode(), remoteDir, option.isCompress(), null, null);
    }

    public String getLogDir() {
        return this.logDir;
    }

    protected abstract void executeBuildAwareJob();

    public void buildVersionChanged() {
        this.setTaskAttribute(BUILDVERSION_ATTRNAME, this.build.getVersion());
    }
}

