/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild;

import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class ArtifactFile
extends File {
    private static final long serialVersionUID = 1L;
    private static final String MARK = "<$QuickbuildArtifact$>";
    private Long artifactSize;

    public ArtifactFile(File file) {
        super(file.getAbsolutePath());
        if (file.isFile()) {
            FileInputStream is;
            block5: {
                is = null;
                try {
                    byte[] mark = new byte[MARK.length() * 2];
                    is = new FileInputStream(file);
                    int len = ((InputStream)is).read(mark);
                    if (len <= MARK.length() || !new String(mark, 0, MARK.length(), "UTF-8").equals(MARK)) break block5;
                    this.artifactSize = Long.parseLong(new String(mark, MARK.length(), len - MARK.length(), "UTF-8"));
                }
                catch (Exception e) {
                    try {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static void writeTo(File file, long artifactSize) {
        FileUtils.writeFile(file, MARK + artifactSize, "UTF-8");
    }

    @Override
    public long length() {
        if (this.artifactSize != null) {
            return this.artifactSize;
        }
        return super.length();
    }
}

