/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;

public class ExceptionUtils {
    public static RuntimeException wrapAsUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Throwable extractException(Throwable throwable, Class<?> exceptionClass) {
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            return throwable;
        }
        HashSet<Throwable> examinedCauses = new HashSet<Throwable>();
        examinedCauses.add(throwable);
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (exceptionClass.isAssignableFrom(cause.getClass())) {
                return cause;
            }
            examinedCauses.add(cause);
            if (examinedCauses.contains(cause.getCause())) break;
        }
        return null;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

