/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.service;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.google.common.base.Throwables;
import com.opensymphony.module.propertyset.PropertySet;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.model.BuildChangeset;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.IssueChange;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.service.QuickBuildClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QuickBuildManagerImpl
implements QuickBuildManager {
    private static Logger logger = Logger.getLogger(QuickBuildManagerImpl.class);
    public static final String APP_PROPERTY_KEY = "com.pmease.quickbuild.addons.jira";
    public static final String DATA_VERSION = "com.pmease.quickbuild.addons.jira.data.version";
    public static final String SERVER_PROPERTY_PREFIX = "quickbuild.addons.jira.server";
    public static final String NEXT_SERVER_ID = "quickbuild.addons.jira.server.nextId";
    public static final String SERVER_NAME_SUFFIX = ".serverName";
    public static final String SERVER_ID_SUFFIX = ".serverId";
    private static final int CURRENT_DATA_VERSION = 1;
    private int version;
    private PropertySet pluginProperties;
    private Map<Long, QuickBuild> servers = new LinkedHashMap<Long, QuickBuild>();
    private Map<String, Long> nameIdMapping = new HashMap<String, Long>();
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private static final Pattern pMigrator = Pattern.compile("migrate(\\d+)");

    public QuickBuildManagerImpl(JiraPropertySetFactory jiraPropertySetFactory) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.servers = this.loadServers();
    }

    private static String buildKeyOfServerKey(Long serverId) {
        return SERVER_PROPERTY_PREFIX + serverId + SERVER_ID_SUFFIX;
    }

    protected Map<Long, QuickBuild> loadServers() {
        this.pluginProperties = this.jiraPropertySetFactory.buildCachingDefaultPropertySet(APP_PROPERTY_KEY, true);
        this.version = this.pluginProperties.getInt(DATA_VERSION);
        if (this.version == 0) {
            this.pluginProperties.setInt(DATA_VERSION, 1);
            return new LinkedHashMap<Long, QuickBuild>();
        }
        if (1 > this.version) {
            logger.info((Object)("Migrating plugin properties from version " + this.version + " to " + 1));
            this.doMigrate();
            this.pluginProperties.setInt(DATA_VERSION, 1);
        }
        Collection keys = this.pluginProperties.getKeys(SERVER_PROPERTY_PREFIX);
        LinkedHashMap<Long, QuickBuild> servers = new LinkedHashMap<Long, QuickBuild>();
        for (Object each : keys) {
            String key = (String)each;
            if (!key.endsWith(SERVER_ID_SUFFIX)) continue;
            Long id = Long.valueOf(StringUtils.substringBetween((String)key, (String)SERVER_PROPERTY_PREFIX, (String)SERVER_ID_SUFFIX));
            String xml = this.pluginProperties.getText(key);
            if (StringUtils.isEmpty((String)xml)) continue;
            QuickBuild server = new QuickBuild();
            server.fromXML(xml);
            if (server == null) continue;
            servers.put(id, server);
            this.nameIdMapping.put(server.getName(), id);
        }
        return servers;
    }

    protected void reset() {
        Collection keys = this.pluginProperties.getKeys();
        for (Object key : keys) {
            this.pluginProperties.remove((String)key);
        }
        this.pluginProperties.setInt(DATA_VERSION, 1);
    }

    private static int getMigratorVersion(Method method) {
        Matcher matcher = pMigrator.matcher(method.getName());
        if (matcher.find()) {
            int migrateVersion = Integer.parseInt(matcher.group(1));
            if (migrateVersion == 0) {
                throw new IllegalArgumentException("Invalid migrate method name: " + method.getName());
            }
            return migrateVersion;
        }
        return 0;
    }

    protected void doMigrate() {
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<Method> queue = new ArrayList<Method>();
        for (Method each : methods) {
            int ver = QuickBuildManagerImpl.getMigratorVersion(each);
            if (ver <= this.version) continue;
            queue.add(each);
        }
        Collections.sort(queue, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int v1 = QuickBuildManagerImpl.getMigratorVersion(o1);
                int v2 = QuickBuildManagerImpl.getMigratorVersion(o2);
                return v1 - v2;
            }
        });
        for (Method each : queue) {
            each.setAccessible(true);
            try {
                each.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Failed to migrate from version " + this.version + " to version " + 1 + ". Clear all old data."), (Throwable)e);
                this.reset();
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("Failed to migrate from version " + this.version + " to version " + 1 + ". Clear all old data."), (Throwable)e);
                this.reset();
            }
            catch (InvocationTargetException e) {
                logger.error((Object)("Failed to migrate from version " + this.version + " to version " + 1 + ". Clear all old data."), (Throwable)e);
                this.reset();
            }
        }
    }

    private void migrator0() {
    }

    @Override
    public void add(QuickBuild server) {
        server.setId(this.generateServerId());
        this.servers.put(server.getId(), server);
        this.nameIdMapping.put(server.getName().toLowerCase(), server.getId());
        String serverKey = QuickBuildManagerImpl.buildKeyOfServerKey(server.getId());
        this.pluginProperties.setText(serverKey, server.toXML());
    }

    protected synchronized Long generateServerId() {
        Long nextServerId = this.pluginProperties.getLong(NEXT_SERVER_ID) + 1L;
        this.pluginProperties.setLong(NEXT_SERVER_ID, nextServerId.longValue());
        return nextServerId;
    }

    @Override
    public void remove(Long serverId) {
        QuickBuild original = this.servers.get(serverId);
        if (original == null) {
            return;
        }
        try {
            String serverKey = QuickBuildManagerImpl.buildKeyOfServerKey(serverId);
            this.servers.remove(serverId);
            this.nameIdMapping.remove(original.getName().toLowerCase());
            this.pluginProperties.remove(serverKey);
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not remove quickbuild index", (Throwable)e);
        }
    }

    @Override
    public void update(QuickBuild server) {
        this.servers.put(server.getId(), server);
        for (String name : this.nameIdMapping.keySet()) {
            Long id = this.nameIdMapping.get(name);
            if (id != server.getId()) continue;
            this.nameIdMapping.remove(name);
            this.nameIdMapping.put(server.getName().toLowerCase(), id);
            break;
        }
        String serverKey = QuickBuildManagerImpl.buildKeyOfServerKey(server.getId());
        this.pluginProperties.setText(serverKey, server.toXML());
    }

    @Override
    public QuickBuild get(String serverName) {
        Long id = this.nameIdMapping.get(serverName.toLowerCase());
        if (id == null) {
            return null;
        }
        return this.servers.get(id);
    }

    @Override
    public QuickBuild get(Long serverId) {
        return this.servers.get(serverId);
    }

    @Override
    public Collection<QuickBuild> getServers() {
        return this.servers.values();
    }

    @Override
    public boolean hasServer(String serverName) {
        return this.get(serverName) != null;
    }

    public Set<String> getConfigurations(String projectKey) {
        HashSet<String> configurations = new HashSet<String>();
        for (QuickBuild each : this.servers.values()) {
            Set<String> set = each.getConfigurations(projectKey);
            if (set.size() <= 0) continue;
            configurations.addAll(set);
        }
        return configurations;
    }

    @Override
    public boolean isProjectAssociated(String projectKey) {
        for (QuickBuild each : this.servers.values()) {
            if (each.getConfigurations(projectKey).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RestResult<BuildSet>> getIssueBuilds(Issue issue) {
        ArrayList<RestResult<BuildSet>> result = new ArrayList<RestResult<BuildSet>>();
        String projectKey = issue.getProjectObject().getKey();
        for (QuickBuild server : this.servers.values()) {
            if (!server.isProjectDefined(projectKey)) continue;
            RestResult<BuildSet> rr = new RestResult<BuildSet>(server);
            try {
                QuickBuildClient client = server.createClient();
                BuildSet b = client.getBuildsOfIssue(issue);
                rr.setResult(b);
            }
            catch (Exception e) {
                rr.addError(StringEscapeUtils.escapeHtml((String)Throwables.getStackTraceAsString((Throwable)e)));
            }
            result.add(rr);
        }
        return result;
    }

    @Override
    public List<RestResult<List<BuildChangeset>>> getIssueChanges(Issue issue) {
        ArrayList<RestResult<List<BuildChangeset>>> result = new ArrayList<RestResult<List<BuildChangeset>>>();
        String projectKey = issue.getProjectObject().getKey();
        for (QuickBuild server : this.servers.values()) {
            if (!server.isProjectDefined(projectKey)) continue;
            RestResult<List<BuildChangeset>> rr = new RestResult<List<BuildChangeset>>(server);
            try {
                QuickBuildClient client = server.createClient();
                List<BuildChangeset> changes = client.getChangesOfIssue(issue);
                rr.setResult(changes);
            }
            catch (Exception e) {
                rr.setResult(new ArrayList());
                rr.addError(StringEscapeUtils.escapeHtml((String)Throwables.getStackTraceAsString((Throwable)e)));
            }
            result.add(rr);
        }
        return result;
    }

    @Deprecated
    protected List<IssueChange> generateChanges(List<BuildChangeset> changesets) {
        ArrayList<IssueChange> changes = new ArrayList<IssueChange>();
        HashSet<String> keys = new HashSet<String>();
        for (BuildChangeset changeset : changesets) {
            for (Changeset c : changeset.getChangesets()) {
                String key = c.getId() + ":" + c.getRepositoryName();
                if (keys.contains(key)) continue;
                keys.add(key);
                IssueChange change = new IssueChange(c);
                changes.add(change);
            }
        }
        Collections.sort(changes);
        return changes;
    }

    @Override
    public List<RestResult<BuildSet>> getProjectBuilds(Project project) {
        ArrayList<RestResult<BuildSet>> result = new ArrayList<RestResult<BuildSet>>();
        for (QuickBuild server : this.getServers()) {
            if (!server.isProjectDefined(project.getKey())) continue;
            RestResult<BuildSet> rr = new RestResult<BuildSet>(server);
            try {
                QuickBuildClient client = server.createClient();
                BuildSet buildset = client.getBuildsOfProject(project.getKey());
                rr.setResult(buildset);
            }
            catch (Exception e) {
                rr.addError(StringEscapeUtils.escapeHtml((String)Throwables.getStackTraceAsString((Throwable)e)));
            }
            result.add(rr);
        }
        return result;
    }
}

