/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.service;

import com.pmease.quickbuild.addons.jira.service.QuickBuildClient;
import com.pmease.quickbuild.addons.jira.utils.EncryptionUtils;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import com.pmease.quickbuild.addons.jira.utils.XMLHelper;
import com.pmease.quickbuild.addons.jira.utils.csv.CSVParser;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class QuickBuild
implements Comparable<QuickBuild> {
    private Long id;
    private String name;
    private String description;
    private String host;
    private String username;
    private String password;
    private Map<String, String> projectPathAssociations = new LinkedHashMap<String, String>();

    public QuickBuild() {
    }

    public QuickBuild(QuickBuild other) {
        this.id = other.id;
        this.name = other.name;
        this.description = other.description;
        this.host = other.host;
        this.username = other.username;
        this.password = other.password;
        this.projectPathAssociations = new LinkedHashMap<String, String>();
        this.projectPathAssociations.putAll(other.projectPathAssociations);
    }

    public void addPathMap(String project, String path) {
        this.projectPathAssociations.put(project, path);
    }

    public void removePathMap(String project) {
        this.projectPathAssociations.remove(project);
    }

    public QuickBuildClient createClient() {
        return new QuickBuildClient(this);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHost() {
        return Utils.normalizeUrl(this.host);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return EncryptionUtils.decrypt(this.password);
    }

    public void setPassword(String password) {
        this.password = EncryptionUtils.encrypt(password);
    }

    public Map<String, String> getProjectPathAssociations() {
        return this.projectPathAssociations;
    }

    public void setProjectPathAssociations(Map<String, String> projectPathAssociations) {
        this.projectPathAssociations = projectPathAssociations;
    }

    public Set<String> getConfigurations(String projectKey) {
        String[] configurations;
        String str = this.projectPathAssociations.get(projectKey);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (StringUtils.isBlank((String)str)) {
            return result;
        }
        str = str.trim();
        for (String each : configurations = new CSVParser().parse(str)) {
            if (StringUtils.isEmpty((String)each)) continue;
            result.add(each);
        }
        return result;
    }

    public Set<String> getConfigurations() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String key : this.projectPathAssociations.keySet()) {
            Set<String> configurations = this.getConfigurations(key);
            if (configurations.size() <= 0) continue;
            result.addAll(configurations);
        }
        return result;
    }

    public boolean isProjectDefined(String projectKey) {
        return !this.getConfigurations(projectKey).isEmpty();
    }

    public void fromXML(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            Document doc = DocumentHelper.parseText((String)text);
            Element node = doc.getRootElement();
            this.id = XMLHelper.getLong((Node)node, "id", 0L);
            this.name = XMLHelper.getString((Node)node, "name");
            this.description = XMLHelper.getString((Node)node, "description");
            this.host = XMLHelper.getString((Node)node, "host");
            this.username = XMLHelper.getString((Node)node, "user");
            this.password = XMLHelper.getString((Node)node, "password");
            Element projectsNode = node.element("projects");
            if (projectsNode != null) {
                String str = projectsNode.getText();
                this.projectPathAssociations = Utils.stringToMap(str);
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXML() {
        Element node = DocumentHelper.createElement((String)"qbserver");
        node.addAttribute("id", String.valueOf(this.id));
        node.addAttribute("name", this.name);
        node.addAttribute("description", this.description);
        node.addAttribute("host", this.host);
        node.addAttribute("user", this.username);
        node.addAttribute("password", this.password);
        Element projectsNode = node.addElement("projects");
        projectsNode.addCDATA(Utils.mapToString(this.projectPathAssociations));
        return node.asXML();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName()).append(", Host: ").append(this.getHost()).append(", User: ").append(this.getUsername());
        return sb.toString();
    }

    @Override
    public int compareTo(QuickBuild other) {
        return this.id.compareTo(other.id);
    }
}

