/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.projectpanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import java.util.HashMap;
import java.util.List;

public class ProjectBuildPanel
extends AbstractProjectTabPanel
implements ProjectTabPanel {
    private final QuickBuildManager qbManager;
    private final PermissionManager permissionManager;

    public ProjectBuildPanel(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, QuickBuildManager qbManager) {
        super(jiraAuthenticationContext);
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
    }

    public String getHtml(BrowseContext browseContext) {
        Project project = browseContext.getProject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<RestResult<BuildSet>> builds = this.qbManager.getProjectBuilds(project);
        params.put("buildsets", builds);
        params.put("action", (Object)this);
        params.put("qbutils", new Utils());
        return this.descriptor.getHtml("view", params);
    }

    public QuickBuild getQuickBuild(Long serverId) {
        return this.qbManager.get(serverId);
    }

    public boolean showPanel(BrowseContext browseContext) {
        return this.permissionManager.hasPermission(29, browseContext.getProject(), ApplicationUsers.from((User)browseContext.getUser())) && this.qbManager.isProjectAssociated(browseContext.getProject().getKey());
    }
}

