/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import org.apache.commons.lang.StringUtils;

public class ChangeFormatter {
    static final int ID_LENGTH = 12;

    public static String formatHashId(String hash) {
        if (StringUtils.isEmpty((String)hash)) {
            return "";
        }
        if (hash.length() < 40) {
            return hash;
        }
        return hash.substring(0, 12);
    }

    public static String formatHashId(String hash, String revno) {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)revno)) {
            sb.append(revno).append(": ");
        }
        sb.append(ChangeFormatter.formatHashId(hash));
        return sb.toString();
    }

    public static String formatBzrId(String id, String revno) {
        if (StringUtils.isEmpty((String)revno)) {
            int pos = id.lastIndexOf(45);
            if (pos > 0) {
                return id.substring(pos + 1);
            }
            return id;
        }
        return revno;
    }

    public static enum RepositoryType {
        MERCURIAL,
        GIT,
        BAZAAR,
        UNKNOWN;


        public static RepositoryType fromString(String str) {
            if (StringUtils.isEmpty((String)str)) {
                return UNKNOWN;
            }
            try {
                return RepositoryType.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

