/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BuildSet {
    private final QuickBuild server;
    private Map<String, List<BuildFragment>> builds = new LinkedHashMap<String, List<BuildFragment>>();

    public BuildSet(QuickBuild server) {
        this.server = server;
    }

    public QuickBuild getServer() {
        return this.server;
    }

    public Map<String, List<BuildFragment>> getBuilds() {
        return this.builds;
    }

    public void setBuilds(Map<String, List<BuildFragment>> builds) {
        this.builds = builds;
    }

    public Collection<String> getConfigurations() {
        return this.builds.keySet();
    }

    public List<BuildFragment> getBuilds(String configuration) {
        return this.builds.get(configuration);
    }

    public void sort(final boolean asc) {
        for (List<BuildFragment> values : this.builds.values()) {
            Collections.sort(values, new Comparator<BuildFragment>(){

                @Override
                public int compare(BuildFragment o1, BuildFragment o2) {
                    int x = asc ? 1 : -1;
                    return o1.compareTo(o2) * x;
                }
            });
        }
    }

    public String getBuildLink(BuildFragment b) {
        return b.formatAsLink();
    }

    public String getBuildUrl(BuildFragment b) {
        return this.server.getHost() + "/build/" + b.getId();
    }
}

