/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.issuepanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.issuepanel.FeedbackAction;
import com.pmease.quickbuild.addons.jira.issuepanel.IssueChangesAction;
import com.pmease.quickbuild.addons.jira.model.BuildChangeset;
import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.IssueChange;
import com.pmease.quickbuild.addons.jira.model.IssueChanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class IssueChangesTabPanel
extends AbstractIssueTabPanel2 {
    private static final Logger logger = Logger.getLogger(IssueChangesTabPanel.class);
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final QuickBuildManager qbManager;

    public IssueChangesTabPanel(QuickBuildManager qbManager, PermissionManager permissionManager, WebResourceManager webResourceManager) {
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
    }

    static void reverseChanges(List<BuildChangeset> changes) {
        if (changes.isEmpty()) {
            return;
        }
        Collections.reverse(changes);
        for (BuildChangeset each : changes) {
            Collections.reverse(each.getChangesets());
        }
    }

    static List<RestResult<IssueChanges>> mergeChanges(List<RestResult<List<BuildChangeset>>> buildChangesets) {
        logger.debug((Object)("Merge changes, original size: " + buildChangesets.size()));
        ArrayList<RestResult<IssueChanges>> result = new ArrayList<RestResult<IssueChanges>>();
        for (RestResult<List<BuildChangeset>> each : buildChangesets) {
            RestResult<IssueChanges> rr = new RestResult<IssueChanges>(each.getServer());
            if (each.hasErrors()) {
                rr.setErrors(each.getErrors());
            } else {
                IssueChanges changes = IssueChangesTabPanel.toIssueChanges(each.getResult());
                logger.debug((Object)("to issue changes, size: " + changes.size()));
                rr.setResult(changes);
            }
            result.add(rr);
        }
        logger.debug((Object)("Merged, size: " + result.size()));
        return result;
    }

    static IssueChanges toIssueChanges(List<BuildChangeset> changesets) {
        LinkedHashMap<String, IssueChange> changes = new LinkedHashMap<String, IssueChange>();
        for (BuildChangeset each : changesets) {
            BuildFragment build = each.getBuild();
            for (Changeset changeset : each.getChangesets()) {
                String id = changeset.getChangesetId();
                IssueChange issuechange = (IssueChange)changes.get(id);
                if (issuechange == null) {
                    issuechange = new IssueChange(changeset);
                    issuechange.addBuild(build);
                    changes.put(id, issuechange);
                    continue;
                }
                issuechange.addBuild(build);
            }
        }
        return new IssueChanges(changes.values());
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-css");
        ArrayList actions = Lists.newArrayList();
        try {
            List<RestResult<List<BuildChangeset>>> allchanges = this.qbManager.getIssueChanges(request.issue());
            List<RestResult<IssueChanges>> rr = IssueChangesTabPanel.mergeChanges(allchanges);
            logger.debug((Object)("Merged changes total: " + rr.size()));
            IssueChangesAction action = new IssueChangesAction(rr, this.descriptor());
            actions.add(action);
        }
        catch (Exception e) {
            logger.error((Object)"Retrieve changes failed.", (Throwable)e);
            FeedbackAction action = new FeedbackAction("<h3>Retrive Changes Failed!</h3><p>" + e.getMessage() + "</p>", FeedbackAction.Level.ERROR);
            actions.add(action);
        }
        return GetActionsReply.create((Iterable)actions);
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        Issue issue = request.issue();
        return ShowPanelReply.create((this.permissionManager.hasPermission(29, issue, ApplicationUsers.from((User)request.remoteUser())) && this.qbManager.isProjectAssociated(issue.getProjectObject().getKey()) ? 1 : 0) != 0);
    }
}

