/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.issuepanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.issuepanel.FeedbackAction;
import com.pmease.quickbuild.addons.jira.issuepanel.IssueBuildsAction;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IssueBuildsTabPanel
extends AbstractIssueTabPanel2 {
    private static final Logger logger = Logger.getLogger(IssueBuildsTabPanel.class);
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final QuickBuildManager qbManager;

    public IssueBuildsTabPanel(QuickBuildManager qbManager, PermissionManager permissionManager, WebResourceManager webResourceManager) {
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-css");
        ArrayList actions = Lists.newArrayList();
        try {
            List<RestResult<BuildSet>> builds = this.qbManager.getIssueBuilds(request.issue());
            boolean isDesc = true;
            for (RestResult<BuildSet> rr : builds) {
                BuildSet buildset = rr.getResult();
                if (buildset == null) continue;
                buildset.sort(false);
            }
            IssueBuildsAction action = new IssueBuildsAction(this.descriptor(), builds, this.qbManager);
            actions.add(action);
        }
        catch (Exception e) {
            logger.error((Object)"Retrieve builds failed.", (Throwable)e);
            FeedbackAction action = new FeedbackAction("<h3>Retrieve Builds Failed!</h3><p>" + e.getMessage() + "</p>", FeedbackAction.Level.ERROR);
            actions.add(action);
        }
        return GetActionsReply.create((Iterable)actions);
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        Issue issue = request.issue();
        return ShowPanelReply.create((this.permissionManager.hasPermission(29, issue, ApplicationUsers.from((User)request.remoteUser())) && this.qbManager.isProjectAssociated(issue.getProjectObject().getKey()) ? 1 : 0) != 0);
    }
}

