/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IsPriorToJiraVersion
implements Condition {
    private int maxMajorVersion;
    private int maxMinorVersion;
    private int majorVersion;
    private int minorVersion;
    static final String VERSION_REGEX = "^(\\d+)\\.(\\d+)$";
    static Pattern pVersion = Pattern.compile("^(\\d+)\\.(\\d+)$");

    public IsPriorToJiraVersion(ApplicationProperties applicationProperties) {
        String versionString = applicationProperties.getVersion();
        Matcher versionMatcher = pVersion.matcher(versionString);
        versionMatcher.find();
        this.majorVersion = Integer.decode(versionMatcher.group(1));
        this.minorVersion = Integer.decode(versionMatcher.group(2));
    }

    public void init(Map<String, String> paramMap) throws PluginParseException {
        this.maxMajorVersion = Integer.decode(paramMap.get("majorVersion"));
        this.maxMinorVersion = Integer.decode(paramMap.get("minorVersion"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.majorVersion < this.maxMajorVersion || this.majorVersion == this.maxMajorVersion && this.minorVersion < this.maxMinorVersion;
    }
}

