/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.action;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.action.QuickBuildActionSupport;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import org.apache.commons.lang.StringUtils;

public class AddQuickBuildServerAction
extends QuickBuildActionSupport {
    private static final long serialVersionUID = 1L;
    protected QuickBuild server = new QuickBuild();
    protected String password;
    protected String projectMapping;

    public AddQuickBuildServerAction(QuickBuildManager manager, WebResourceManager webResourceManager) {
        super(manager, webResourceManager);
    }

    public void doValidation() {
        super.doValidation();
        if (StringUtils.isEmpty((String)this.getName())) {
            this.addError("name", "Server name is required.");
        }
        if (StringUtils.isEmpty((String)this.getHost())) {
            this.addError("host", "Host Url is required.");
        }
        if (StringUtils.isEmpty((String)this.getUsername())) {
            this.addError("username", "User name is required.");
        }
        if (StringUtils.isEmpty((String)this.getPassword())) {
            this.addError("password", "Password is required.");
        }
    }

    public String doExecute() {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.getManager().hasServer(this.getName())) {
            this.addError("name", "The server name has been defined already.");
            return "error";
        }
        this.server.setPassword(this.password);
        if (!StringUtils.isEmpty((String)this.projectMapping)) {
            this.server.setProjectPathAssociations(Utils.stringToMap(this.projectMapping));
        }
        this.getManager().add(this.server);
        return this.getRedirect("ViewQuickBuildServers.jspa");
    }

    public String getName() {
        return this.server.getName();
    }

    public void setName(String name) {
        this.server.setName(name);
    }

    public String getDescription() {
        return this.server.getDescription();
    }

    public void setDescription(String description) {
        this.server.setDescription(description);
    }

    public String getHost() {
        return this.server.getHost();
    }

    public void setHost(String host) {
        if (host.endsWith("/")) {
            this.server.setHost(host.substring(0, host.length() - 1));
        } else {
            this.server.setHost(host);
        }
    }

    public String getUsername() {
        return this.server.getUsername();
    }

    public void setUsername(String username) {
        this.server.setUsername(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProjectMapping() {
        return this.projectMapping;
    }

    public void setProjectMapping(String projectMapping) {
        this.projectMapping = projectMapping;
    }
}

