/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.emma.migration;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;

public class EMMAMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        Map map = category.getDefaultStats(db, "packages", new Filter[0]);
        row.fromMap(map);
        row.setValue("buildId", (Object)context.getBuild().getId());
        row.setValue("packagesTotal", (Object)MapUtils.getLong((Map)map, (Object)"TOTALS", (Long)0L).intValue());
        double classCoverage = MathUtils.divide((int)row.getInt("classDetected"), (int)row.getInt("classTotal"));
        row.setValue("classCoverage", (Object)classCoverage);
        double methodCoverage = MathUtils.divide((int)row.getInt("methodDetected"), (int)row.getInt("methodTotal"));
        row.setValue("methodCoverage", (Object)methodCoverage);
        double blockCoverage = MathUtils.divide((int)row.getInt("blockDetected"), (int)row.getInt("blockTotal"));
        row.setValue("blockCoverage", (Object)blockCoverage);
        double lineCoverage = MathUtils.divide((int)row.getInt("lineDetected"), (int)row.getInt("lineTotal"));
        row.setValue("lineCoverage", (Object)lineCoverage);
        category.saveReport(db, statsReport);
    }
}

