/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.emma.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.emma.EMMAPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

@Editable(name="EMMA Report")
public class EMMAAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(EMMAPlugin.class);
    }

    static double getCoverage(DataRow row, String totalColumn, String detectedColumn) {
        int total = row.getInt(totalColumn);
        int detected = row.getInt(detectedColumn);
        return MathUtils.divide((int)detected, (int)total);
    }

    static double getCoverage(Map<String, Object> map, String totalColumn, String detectedColumn) {
        int total = MapUtils.getIntValue(map, (Object)totalColumn, (int)0);
        int detected = MapUtils.getIntValue(map, (Object)detectedColumn, (int)0);
        return MathUtils.divide((int)detected, (int)total);
    }

    static void updateRow(DataRow destRow) {
        destRow.setValue("classCoverage", (Object)EMMAAggregator.getCoverage(destRow, "classTotal", "classDetected"));
        destRow.setValue("methodCoverage", (Object)EMMAAggregator.getCoverage(destRow, "methodTotal", "methodDetected"));
        destRow.setValue("blockCoverage", (Object)EMMAAggregator.getCoverage(destRow, "blockTotal", "blockDetected"));
        destRow.setValue("lineCoverage", (Object)EMMAAggregator.getCoverage(destRow, "lineTotal", "lineDetected"));
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        EMMAAggregator.updateRow(destRow);
    }

    protected void updateStatsRow(DataRow row) {
        super.updateStatsRow(row);
        EMMAAggregator.updateRow(row);
    }

    protected String[] getAggregateColumns() {
        return new String[]{"packagesTotal", "classDetected", "classTotal", "methodDetected", "methodTotal", "blockDetected", "blockTotal", "lineDetected", "lineTotal"};
    }
}

