/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.emma;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.emma.EMMAPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;

@Editable(category={"Publish"}, name="EMMA Report", description="Publish EMMA reports")
@ScriptApi(value="This step publishes the original EMMA XML files.")
public class EMMAPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private double classCoverage;
    @XStreamOmitField
    private double methodCoverage;
    @XStreamOmitField
    private double blockCoverage;
    @XStreamOmitField
    private double lineCoverage;

    public EMMAPublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(EMMAPlugin.class);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        Map map = category.getDefaultStats(dbDir, "packages", new Filter[0]);
        try {
            db.open(DbStore.Mode.READ_WRITE, "EMMAPublisher::saveStatsReport");
            DataRow row = statsReport.addRow();
            row.fromMap(map);
            row.setValue("buildId", (Object)context.getCurrentBuild().getId());
            row.setValue("packagesTotal", (Object)MapUtils.getLong((Map)map, (Object)"TOTALS", (Long)0L).intValue());
            this.classCoverage = MathUtils.divide((int)row.getInt("classDetected"), (int)row.getInt("classTotal"));
            row.setValue("classCoverage", (Object)this.classCoverage);
            this.methodCoverage = MathUtils.divide((int)row.getInt("methodDetected"), (int)row.getInt("methodTotal"));
            row.setValue("methodCoverage", (Object)this.methodCoverage);
            this.blockCoverage = MathUtils.divide((int)row.getInt("blockDetected"), (int)row.getInt("blockTotal"));
            row.setValue("blockCoverage", (Object)this.blockCoverage);
            this.lineCoverage = MathUtils.divide((int)row.getInt("lineDetected"), (int)row.getInt("lineTotal"));
            row.setValue("lineCoverage", (Object)this.lineCoverage);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byPackageUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_package", (String)reportsetName)).build();
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @ScriptApi(value="Average classes coverage in EMMA report.")
    public double getClassCoverage() {
        return this.classCoverage;
    }

    public void setClassCoverage(double classCoverage) {
        this.classCoverage = classCoverage;
    }

    @ScriptApi(value="Average methods coverage in EMMA report.")
    public double getMethodCoverage() {
        return this.methodCoverage;
    }

    public void setMethodCoverage(double methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    @ScriptApi(value="Average blocks coverage in EMMA report.")
    public double getBlockCoverage() {
        return this.blockCoverage;
    }

    public void setBlockCoverage(double blockCoverage) {
        this.blockCoverage = blockCoverage;
    }

    @ScriptApi(value="Average lines coverage in EMMA report.")
    public double getLineCoverage() {
        return this.lineCoverage;
    }

    public void setLineCoverage(double lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "false");
        dom.setValue("stepFailureMessage", "");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        EMMAPublisher.removeElement((VersionedDocument)dom, (String)"classCoverage");
        EMMAPublisher.removeElement((VersionedDocument)dom, (String)"methodCoverage");
        EMMAPublisher.removeElement((VersionedDocument)dom, (String)"blockCoverage");
        EMMAPublisher.removeElement((VersionedDocument)dom, (String)"lineCoverage");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return EMMAChecksum.class;
    }

    public static class EMMAChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(EMMAPlugin.class);
        }
    }
}

