/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.emma;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageType;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMMAProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EMMAProcessor.class);

    public EMMAProcessor(ReportCategory category) {
        super(category);
    }

    static Pair<Integer, Integer> coveragePair(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return new Pair((Object)0, (Object)0);
        }
        Pair pair = new Pair();
        String s = StringUtils.substringAfter((String)StringUtils.substringBefore((String)str, (String)")"), (String)"(");
        String[] tokens = StringUtils.split((String)s, (String)"/");
        if (tokens.length == 2) {
            Integer detected = (Integer)DataTypes.INTEGER.fromString(tokens[0], null);
            Integer total = (Integer)DataTypes.INTEGER.fromString(tokens[1], null);
            if (detected == null || total == null) {
                logger.warn("Error parsing " + str);
            }
            pair.setFirst((Object)detected);
            pair.setSecond((Object)total);
        } else {
            logger.warn("Unable to parse coverage string " + str);
            pair.setFirst((Object)0);
            pair.setSecond((Object)0);
        }
        return pair;
    }

    static CoverageData coverageData(Element node) {
        String str = node.attributeValue("type");
        CoverageData data = new CoverageData();
        data.type = CoverageType.getType((String)str);
        str = node.attributeValue("value");
        Pair<Integer, Integer> pair = EMMAProcessor.coveragePair(str);
        data.detected = (Integer)pair.getFirst();
        data.total = (Integer)pair.getSecond();
        return data;
    }

    static void updateRowValue(CoverageData data, DataRow row) {
        row.setValue(data.type.name().toLowerCase() + "Detected", (Object)data.detected);
        row.setValue(data.type.name().toLowerCase() + "Total", (Object)data.total);
        row.setValue(data.type.name().toLowerCase() + "Coverage", (Object)data.getCoverage());
    }

    protected void processResource(GeneratorResource resource) {
        File inputFile = resource.getFile();
        if (!inputFile.exists()) {
            return;
        }
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        Document doc = XMLHelper.readXML((File)inputFile);
        AlwaysNewValue merger = new AlwaysNewValue();
        DataReport report = this.generateClasses(doc);
        category.saveReport(dbDir, report, (MergeFunction)merger);
        report = this.generatePackages(report);
        category.saveReport(dbDir, report, (MergeFunction)merger);
        report = this.generateMethods(doc);
        category.saveReport(dbDir, report, (MergeFunction)merger);
    }

    void updateCoverage(String type, DataRow dest, DataRow raw) {
        dest.setValue(type + "Detected", (Object)(dest.getInt(type + "Detected") + raw.getInt(type + "Detected")));
        dest.setValue(type + "Total", (Object)(dest.getInt(type + "Total") + raw.getInt(type + "Total")));
        dest.setValue(type + "Coverage", (Object)MathUtils.divide((int)dest.getInt(type + "Detected"), (int)dest.getInt(type + "Total")));
    }

    DataReport generatePackages(DataReport classReport) {
        DataReport destReport = this.category.createReport("packages");
        HashMap indexes = Maps.newHashMap();
        for (DataRow each : classReport.getRows()) {
            DataRow row;
            String packageName = each.getValueAsString("packageName");
            Integer i = (Integer)indexes.get(packageName);
            if (i == null) {
                row = destReport.addRow();
                indexes.put(packageName, destReport.getRowsCount() - 1);
                row.setValue("packageName", (Object)packageName);
            } else {
                row = destReport.getRow(i.intValue());
            }
            this.updateCoverage("class", row, each);
            this.updateCoverage("method", row, each);
            this.updateCoverage("block", row, each);
            this.updateCoverage("line", row, each);
        }
        return destReport;
    }

    DataReport generatePackages(Document doc) {
        DataReport report = this.category.createReport("packages");
        List nodes = doc.selectNodes("//package");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            row.setValue("packageName", (Object)each.attributeValue("name"));
            List cNodes = each.elements("coverage");
            for (Element cEach : cNodes) {
                CoverageData data = EMMAProcessor.coverageData(cEach);
                EMMAProcessor.updateRowValue(data, row);
            }
        }
        return report;
    }

    DataReport generateClasses(Document doc) {
        DataReport report = this.category.createReport("classes");
        List nodes = doc.selectNodes("//class");
        Build build = Context.getBuild();
        String workspaceDir = this.getContext().getWorkspaceDir();
        for (Element each : nodes) {
            DataRow row = report.addRow();
            row.setValue("packageName", (Object)each.valueOf("../../@name"));
            row.setValue("className", (Object)each.attributeValue("name"));
            String fileName = each.valueOf("../@name");
            fileName = ReportUtils.getRelativePath((String)fileName, (String)workspaceDir);
            row.setValue("fileName", (Object)fileName);
            List committers = ReportUtils.getCommitters((Build)build, (String)fileName, (boolean)false);
            row.setValue("committers", (Object)committers);
            List cNodes = each.elements("coverage");
            for (Element cEach : cNodes) {
                CoverageData data = EMMAProcessor.coverageData(cEach);
                EMMAProcessor.updateRowValue(data, row);
            }
        }
        return report;
    }

    DataReport generateMethods(Document doc) {
        DataReport report = this.category.createReport("methods");
        List nodes = doc.selectNodes("//method");
        Build build = Context.getBuild();
        String workspaceDir = this.getContext().getWorkspaceDir();
        for (Element each : nodes) {
            DataRow row = report.addRow();
            row.setValue("packageName", (Object)each.valueOf("../../../@name"));
            row.setValue("className", (Object)each.valueOf("../@name"));
            String fileName = each.valueOf("../../@name");
            fileName = ReportUtils.getRelativePath((String)fileName, (String)workspaceDir);
            row.setValue("fileName", (Object)fileName);
            List committers = ReportUtils.getCommitters((Build)build, (String)fileName, (boolean)false);
            row.setValue("committers", (Object)committers);
            row.setValue("methodName", (Object)each.valueOf("./@name"));
            List cNodes = each.elements("coverage");
            for (Element cEach : cNodes) {
                CoverageData data = EMMAProcessor.coverageData(cEach);
                EMMAProcessor.updateRowValue(data, row);
            }
        }
        return report;
    }

    static class CoverageData {
        CoverageType type;
        int detected;
        int total;

        CoverageData() {
        }

        public double getCoverage() {
            return MathUtils.divide((int)this.detected, (int)this.total);
        }
    }
}

