/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.versionupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Editable(name="Update Plugin Versions", category={"Misc"}, description="This step increases versions of changed QuickBuild plugins.")
public class IncreaseVersionStep
extends Step {
    private static final long serialVersionUID = 1L;

    public void run() {
        Build build = Context.getBuild();
        List changes = build.getChanges();
        ArrayList modifications = new ArrayList();
        File workspace = build.getConfiguration().getWorkspaceDir();
        for (BuildChangeset changeset : changes) {
            modifications.addAll(changeset.getModifications());
        }
        HashSet<String> names = new HashSet<String>();
        for (Modification modification : modifications) {
            String path = modification.getPath();
            String name = this.getPluginName(path);
            if (StringUtils.isBlank((String)name)) continue;
            names.add(this.getPluginName(path));
        }
        for (String name : names) {
            File file = new File(workspace, name + "/META-INF/MANIFEST.MF");
            if (!file.exists()) {
                Context.getLogger().warn("Can't find MANIFEST file: " + file);
                continue;
            }
            this.updateBundleVersion(file);
            Context.getLogger().warn("Update meta-info for plugin " + name + " finished.");
        }
    }

    private void updateBundleVersion(File file) {
        List lines = FileUtils.readFileAsLines((File)file);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (!line.startsWith("Bundle-Version")) continue;
            String[] tokens = StringUtils.split((String)line, (char)':');
            String from = tokens[1].trim();
            tokens = StringUtils.split((String)from, (char)'.');
            int patchVersion = Integer.valueOf(tokens[2]);
            String to = new StringBuffer().append(tokens[0]).append('.').append(tokens[1]).append('.').append(String.valueOf(++patchVersion)).toString();
            line = "Bundle-Version: " + to;
            lines.set(i, line);
            FileUtils.writeFile((File)file, (Collection)lines);
            return;
        }
    }

    private String getPluginName(String path) {
        int pos = path.indexOf("com.pmease.quickbuild");
        if (pos >= 0) {
            String name = path.substring(pos);
            if ((pos = name.indexOf(47)) > 0) {
                name = name.substring(0, pos);
            }
            return name;
        }
        return null;
    }
}

