/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.ant.backport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;

public class AntLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream output;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.output = new PrintStream(output, true);
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            message.append("BUILD SUCCESSFUL\n");
        } else {
            Throwable cause;
            message.append("BUILD FAILED");
            while (error instanceof BuildException && (cause = ((BuildException)error).getCause()) != null && cause.toString().equals(error.getMessage())) {
                error = cause;
            }
            String errorMessage = 3 <= this.msgOutputLevel || !(error instanceof BuildException) ? StringUtils.getStackTrace((Throwable)error) : error.toString();
            BufferedReader reader = new BufferedReader(new StringReader(errorMessage.toString()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    message.append("\n ").append(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        message.append("\nTotal time: ");
        message.append(DateUtils.formatElapsedTime((long)(System.currentTimeMillis() - this.startTime)));
        String msg = message.toString();
        if (error == null) {
            this.printMessage(msg, -1);
        } else {
            this.printMessage(msg, 0);
        }
    }

    private void printMessage(String msg, int priority) {
        if (priority == 4) {
            this.output.println("TRACE " + msg);
        } else if (priority == 0) {
            this.output.println("ERROR " + msg);
        } else if (priority == 2) {
            this.output.println("INFO " + msg);
        } else if (priority == 3) {
            this.output.println("DEBUG " + msg);
        } else if (priority == 1) {
            this.output.println("WARN " + msg);
        } else {
            this.output.println(msg);
        }
    }

    public void targetStarted(BuildEvent event) {
        if (!event.getTarget().getName().equals("")) {
            this.printMessage(event.getTarget().getName() + ":", 2);
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority <= 2 || priority <= this.msgOutputLevel) {
            StringBuffer message = new StringBuffer();
            if (event.getTask() != null) {
                String name = event.getTask().getTaskName();
                String label = "[" + name + "] ";
                int size = 12 - label.length();
                StringBuffer tmp = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    tmp.append(" ");
                }
                tmp.append(label);
                label = tmp.toString();
                BufferedReader reader = new BufferedReader(new StringReader(event.getMessage()));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (message.length() != 0) {
                            message.append("\n ").append(label).append(line);
                            continue;
                        }
                        message.append(label).append(line);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                message.append(event.getMessage());
            }
            Throwable ex = event.getException();
            if (4 <= this.msgOutputLevel && ex != null) {
                message.append(StringUtils.getStackTrace((Throwable)ex));
            }
            if (event.getTask() != null) {
                this.printMessage(event.getTask().getTaskName(), message.toString(), priority);
            } else {
                this.printMessage(message.toString(), priority);
            }
        }
    }

    private void printMessage(String taskName, String msg, int priority) {
        if (taskName.equals("javac")) {
            if (priority <= 1) {
                this.printMessage(msg, 1);
            } else {
                this.printMessage(msg, priority);
            }
        } else if (taskName.equals("groovyc")) {
            if (msg.contains("MultipleCompilationErrorsException")) {
                this.printMessage(msg, 0);
            } else {
                this.printMessage(msg, priority);
            }
        } else if (taskName.equals("echo")) {
            this.printMessage(msg, 2);
        } else {
            this.printMessage(msg, priority);
        }
    }
}

