/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.artifactory.ArtifactoryPlugin;
import com.pmease.quickbuild.plugin.artifactory.ArtifactoryRevision;
import com.pmease.quickbuild.plugin.artifactory.ArtifactorySetting;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Artifactory Artifacts", description="This defines a set of artifactory artifacts which can be checked out via checkout step during a build.")
public class ArtifactoryRepository
extends Repository<ArtifactoryRevision> {
    private String repoName;
    private String buildName;
    private String buildNumber = "LATEST";
    private String regexs;
    private String destPath;

    @Editable(name="Artifactory Repository Key", order=100, description="Specify key of the artifactory repository to retrieve artifacts from.")
    @NotEmpty
    @ExpressionProvider(value="getRepoNames")
    @Scriptable
    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    private static Map<String, String> getRepoNames() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String repoName : ArtifactoryPlugin.listRepositories()) {
            map.put(repoName, repoName);
        }
        return map;
    }

    @Editable(order=200, description="Specify name of the build managed at artifactory side. If the build is published via QuickBuild, it represents path of the configuration. Character '/' will be converted to '>' internally to conform to Artifactory build name requirement.")
    @ConfigurationPath
    @NotEmpty
    @Scriptable
    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @Editable(order=300, description="Specify number of the build managed at artifactory side. If the build is published via QuickBuild, it represents the build version as QuickBuild always publishes build version as build number to artifactory. Note that the string <strong>LATEST</strong> represents latest version.")
    @Scriptable
    @Expressions(value={"Latest build", "LATEST"})
    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Editable(name="Artifact Regular Expressions", order=400, description="Optionally specify regular expressions to match artifact files of above build. If specified, the setting will be used as input param of mapping of the <a href='http://www.jfrog.com/confluence/display/RTF/Artifactory+REST+API#ArtifactoryRESTAPI-RetrieveBuildArtifactsArchive'>artifactory retrieval request</a>. Multiple regular expressions can be specified if separated by comma or new line character. If left empty, all artifacts of above build will be retrieved.")
    @Scriptable
    public String getRegularExpressions() {
        return this.regexs;
    }

    public void setRegularExpressions(String regexs) {
        this.regexs = regexs;
    }

    @Editable(name="Destination Path", order=500, description="Optionally specify destination path to place retrieved artifacts. A non-absolute path is considered to be relative to current workspace directory.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkoutByRevision(ArtifactoryRevision revision) {
        String json;
        ArtifactorySetting setting = (ArtifactorySetting)PluginSettingHelper.getSetting(ArtifactoryPlugin.class, (boolean)true);
        WebResource resource = RestModule.resource((String)setting.getServerUrl(), (String)"/api/archive/buildArtifacts", (String)setting.getUserName(), (String)setting.getPassword());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buildName", this.normalizeBuildName());
        map.put("buildNumber", ((ArtifactoryRevision)this.getRevision()).getBuildNumber());
        map.put("repos", Lists.newArrayList((Object[])new String[]{this.getRepoName()}));
        map.put("archiveType", "tar");
        if (this.getRegularExpressions() != null) {
            ArrayList mappings = new ArrayList();
            for (String each : StringUtils.split((String)this.getRegularExpressions(), (String)",\n")) {
                HashMap<String, String> mapping = new HashMap<String, String>();
                mapping.put("input", each.trim());
                mappings.add(mapping);
            }
            map.put("mappings", mappings);
        }
        try {
            json = new ObjectMapper().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        ClientResponse response = (ClientResponse)resource.type("application/json").post(ClientResponse.class, (Object)json);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Failed to list build runs: " + (String)response.getEntity(String.class));
        }
        File destDir = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getDestPath());
        InputStream is = response.getEntityInputStream();
        try {
            FileUtils.untar((InputStream)is, (boolean)false, (File)destDir);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
    }

    protected ArtifactoryRevision getHeadRevision() {
        ArtifactoryRevision revision = new ArtifactoryRevision();
        if (this.getBuildNumber().equals("LATEST")) {
            List<BuildRun> buildRuns = this.listBuildRuns();
            Collections.sort(buildRuns);
            revision.setBuildNumber(buildRuns.get(buildRuns.size() - 1).getBuildNumber());
        } else {
            revision.setBuildNumber(this.getBuildNumber());
        }
        return revision;
    }

    protected void labelOnRevision(ArtifactoryRevision revision, String label, String comment) {
        Context.getLogger().warn("Label on revision is not supported for artifactory repository.");
    }

    protected List<Changeset> getChangesBetween(ArtifactoryRevision startRevision, ArtifactoryRevision endRevision) {
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        if (!startRevision.getBuildNumber().equals(endRevision.getBuildNumber())) {
            Changeset change = new Changeset();
            change.setId(endRevision.getBuildNumber());
            change.setComment("New build number found");
            changes.add(change);
        }
        return changes;
    }

    protected boolean isQuietSince(Date date) {
        for (BuildRun each : this.listBuildRuns()) {
            if (!each.getBeginDate().after(date)) continue;
            return true;
        }
        return false;
    }

    public ProofBuildSupport<? extends LocalChange> getProofBuildSupport() {
        return null;
    }

    public SourceViewSupport<ArtifactoryRevision> getSourceViewSupport() {
        return null;
    }

    private String normalizeBuildName() {
        return this.getBuildName().replace("/", ">");
    }

    private List<BuildRun> listBuildRuns() {
        ArtifactorySetting setting = (ArtifactorySetting)PluginSettingHelper.getSetting(ArtifactoryPlugin.class, (boolean)true);
        WebResource resource = RestModule.resource((String)setting.getServerUrl(), (String)("/api/build/" + this.normalizeBuildName()), (String)setting.getUserName(), (String)setting.getPassword());
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Failed to list build runs: " + (String)response.getEntity(String.class));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        ArrayList<BuildRun> buildRuns = new ArrayList<BuildRun>();
        String json = (String)response.getEntity(String.class);
        try {
            Map map = (Map)new ObjectMapper().readValue(json, Map.class);
            for (Map each : (List)map.get("buildsNumbers")) {
                BuildRun buildRun = new BuildRun();
                buildRun.setBuildNumber(((String)each.get("uri")).substring(1));
                buildRun.setBeginDate(sdf.parse((String)each.get("started")));
                buildRuns.add(buildRun);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        return buildRuns;
    }

    private static class BuildRun
    implements Comparable<BuildRun> {
        private String buildNumber;
        private Date beginDate;

        private BuildRun() {
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public void setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(Date beginDate) {
            this.beginDate = beginDate;
        }

        @Override
        public int compareTo(BuildRun buildRun) {
            return this.beginDate.compareTo(buildRun.getBeginDate());
        }
    }
}

