/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.RepositoryProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.artifactory.ArtifactDeployStep;
import com.pmease.quickbuild.plugin.artifactory.ArtifactItem;
import com.pmease.quickbuild.plugin.artifactory.ArtifactPanel;
import com.pmease.quickbuild.plugin.artifactory.ArtifactoryRepository;
import com.pmease.quickbuild.plugin.artifactory.ArtifactoryRevision;
import com.pmease.quickbuild.plugin.artifactory.ArtifactorySetting;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.html.panel.Panel;
import org.hibernate.util.SerializationHelper;

public class ArtifactoryPlugin
extends AbstractPlugin {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public Class<?> getSettingClass() {
        return ArtifactorySetting.class;
    }

    public static List<String> listRepositories() {
        ArtifactorySetting setting = (ArtifactorySetting)PluginSettingHelper.getSetting(ArtifactoryPlugin.class, (boolean)true);
        WebResource resource = RestModule.resource((String)setting.getServerUrl(), (String)"/api/repositories", (String)setting.getUserName(), (String)setting.getPassword());
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Failed to list repositories: " + (String)response.getEntity(String.class));
        }
        try {
            List repositories = (List)new ObjectMapper().readValue((String)response.getEntity(String.class), List.class);
            ArrayList<String> repoKeys = new ArrayList<String>();
            for (Map repo : repositories) {
                repoKeys.add((String)repo.get("key"));
            }
            return repoKeys;
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public Object[] getExtensions() {
        return new Object[]{new RepositoryProvider(){

            public Class<? extends Repository<?>> getRepositoryClass() {
                return ArtifactoryRepository.class;
            }
        }, new BuildOverviewContribution(){

            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                File artifactsInfo = new File(Context.getBuild().getPublishDir(), "artifactoryArtifacts");
                if (artifactsInfo.exists()) {
                    creators.add(new PanelCreator(){

                        public Panel newPanel(String id) {
                            return new ArtifactPanel(id);
                        }
                    });
                }
                return creators;
            }

            public int getOrder() {
                return 20;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                return ArtifactDeployStep.class;
            }
        }, new BuildListener(){

            public void buildUnRecommended() {
            }

            public void buildStarted() {
            }

            public void buildRecommended() {
            }

            public void buildFinished() {
                Build build = Context.getBuild();
                List items = (List)build.getReports().get("artifactoryArtifacts");
                if (build.isSuccessful() && items != null) {
                    HashMap<String, Object> buildInfo = new HashMap<String, Object>();
                    buildInfo.put("version", build.getVersion());
                    String transformedConfigurationPath = StringUtils.replace((String)build.getConfiguration().getPathName(), (String)"/", (String)">");
                    buildInfo.put("name", transformedConfigurationPath);
                    buildInfo.put("number", build.getVersion());
                    buildInfo.put("type", "GENERIC");
                    HashMap<String, String> agentInfo = new HashMap<String, String>();
                    agentInfo.put("name", "QuickBuild");
                    agentInfo.put("version", Bootstrap.buildVersion);
                    buildInfo.put("agent", agentInfo);
                    buildInfo.put("started", new SimpleDateFormat(ArtifactoryPlugin.DATE_FORMAT).format(build.getBeginDate()));
                    buildInfo.put("durationMillis", build.getDuration());
                    buildInfo.put("principal", build.getRequesterName());
                    buildInfo.put("url", build.getUrl());
                    ArrayList modules = new ArrayList();
                    HashMap<String, Object> module = new HashMap<String, Object>();
                    module.put("id", transformedConfigurationPath + ":" + build.getId());
                    ArrayList artifacts = new ArrayList();
                    for (ArtifactItem item : items) {
                        HashMap<String, String> artifact = new HashMap<String, String>();
                        artifact.put("name", item.getPath());
                        artifact.put("sha1", item.getSha1());
                        artifact.put("md5", item.getMd5());
                        artifacts.add(artifact);
                    }
                    module.put("artifacts", artifacts);
                    modules.add(module);
                    buildInfo.put("modules", modules);
                    ArrayList dependencies = new ArrayList();
                    for (Repository repo : build.getRepositories()) {
                        if (!repo.isCheckout() || !(repo instanceof ArtifactoryRepository)) continue;
                        ArtifactoryRepository artifactoryRepo = (ArtifactoryRepository)repo;
                        HashMap<String, String> dependency = new HashMap<String, String>();
                        dependency.put("name", artifactoryRepo.getBuildName());
                        dependency.put("number", ((ArtifactoryRevision)artifactoryRepo.getRevision()).getBuildNumber());
                        dependencies.add(dependency);
                    }
                    if (!dependencies.isEmpty()) {
                        buildInfo.put("buildDependencies", dependencies);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.writeValue((OutputStream)baos, buildInfo);
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                    }
                    byte[] bytes = baos.toByteArray();
                    ArtifactorySetting setting = (ArtifactorySetting)PluginSettingHelper.getSetting(ArtifactoryPlugin.class, (boolean)true);
                    WebResource resource = RestModule.resource((String)setting.getServerUrl(), (String)"/api/build", (String)setting.getUserName(), (String)setting.getPassword());
                    ClientResponse response = (ClientResponse)resource.type("application/json").put(ClientResponse.class, (Object)new ByteArrayInputStream(bytes));
                    if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 204) {
                        throw new QuickbuildException("Failed to publish build info: " + (String)response.getEntity(String.class));
                    }
                }
                if (items != null) {
                    File artifactsInfo = new File(build.getPublishDir(), "artifactoryArtifacts");
                    FileUtils.writeFile((File)artifactsInfo, (byte[])SerializationHelper.serialize((Serializable)((Serializable)((Object)items))));
                }
            }
        }};
    }
}

