/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifactory;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.artifactory.ArtifactItem;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.hibernate.util.SerializationHelper;

public class ArtifactPanel
extends Panel {
    public ArtifactPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new ListView<ArtifactItem>("artifacts", (IModel)new LoadableDetachableModel<List<ArtifactItem>>(){

            protected List<ArtifactItem> load() {
                File artifactsInfo = new File(Context.getBuild().getPublishDir(), "artifactoryArtifacts");
                return (List)SerializationHelper.deserialize((byte[])FileUtils.readFileAsBytes((File)artifactsInfo));
            }
        }){

            protected void populateItem(ListItem<ArtifactItem> item) {
                ArtifactItem artifact = (ArtifactItem)item.getModelObject();
                item.add(new Component[]{new Label("repoName", artifact.getRepoName())});
                WebMarkupContainer link = new WebMarkupContainer("url");
                link.add(new Behavior[]{AttributeAppender.append((String)"href", (Serializable)((Object)artifact.getUrl()))});
                link.add(new Component[]{new Label("path", artifact.getPath())});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("size", String.valueOf(artifact.getSize()))});
                item.add(new Component[]{new Label("md5", artifact.getMd5())});
            }
        }});
    }
}

