/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.artifactory.ArtifactItem;
import com.pmease.quickbuild.plugin.artifactory.ArtifactoryPlugin;
import com.pmease.quickbuild.plugin.artifactory.ArtifactorySetting;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, order=35, name="Artifactory Artifacts", description="Publish specified files to server as build artifacts. This step can run either from server side or from agent side.")
@ScriptApi(value="This step publish specified files as build artifacts.")
public class ArtifactDeployStep
extends Step {
    private static final long serialVersionUID = 1L;
    public static final String BUILD_DATA_KEY = "artifactoryArtifacts";
    private String repoName;
    private String srcPath;
    private String filePatterns = "**";
    private String destPath;

    @Editable(name="Artifactory Repository Key", order=990, description="Specify key of the repository to which artifacts will be published. For instance: <em>libs-release-local</em>")
    @ExpressionProvider(value="getRepoNames")
    @NotEmpty
    @Scriptable
    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    private static Map<String, String> getRepoNames() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String repoName : ArtifactoryPlugin.listRepositories()) {
            map.put(repoName, repoName);
        }
        return map;
    }

    @Editable(order=1000, name="Source Directory", description="Specify the directory from which the files will be published. A non-absolute path is considered to be relative to current workspace directory . If left empty, the workspace directory itself will be used.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=1100, name="Files To Publish", description="Specify patterns of files that need to be published. Patterns will be matched under the <b>source directory</b> specified above. Matched files will be copied to the <b>destination path</b> specified below. The directory structure will be preserved during the copy.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String fileNamePatterns) {
        this.filePatterns = fileNamePatterns;
    }

    @Editable(order=1300, name="Destination Directory", description="Specify a destination directory for this publishing. Specified path is considered to be relative to root of the repository specified above. If left empty, the root directory of the repository will be used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public void run() {
        Build build = Context.getBuild();
        File srcDir = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getSrcPath());
        if (!srcDir.exists()) {
            throw new QuickbuildException("Can not find source directory for artifact deployment: " + srcDir.getAbsolutePath());
        }
        Collection files = FileUtils.listFiles((File)srcDir, (String)this.getFilePatterns());
        Iterator it = files.iterator();
        while (it.hasNext()) {
            if (((File)it.next()).isFile()) continue;
            it.remove();
        }
        if (!files.isEmpty()) {
            ArtifactorySetting setting = (ArtifactorySetting)PluginSettingHelper.getSetting(ArtifactoryPlugin.class, (boolean)true);
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<ArtifactItem> artifacts = new ArrayList<ArtifactItem>();
            String path = this.getRepoName().trim();
            path = StringUtils.stripStart((String)path, (String)"/\\");
            path = StringUtils.stripEnd((String)path, (String)"/\\");
            String destPath = this.getDestPath();
            if (destPath != null) {
                destPath = StringUtils.stripStart((String)destPath.trim(), (String)"/\\");
                destPath = StringUtils.stripEnd((String)destPath, (String)"/\\");
            }
            if (StringUtils.isNotBlank((String)destPath)) {
                path = path + "/" + destPath;
            }
            for (File file : files) {
                String relativePath = FileUtils.getRelativePath((String)file.getAbsolutePath(), (String)srcDir.getAbsolutePath());
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    WebResource resource = RestModule.resource((String)setting.getServerUrl(), (String)(path + relativePath), (String)setting.getUserName(), (String)setting.getPassword());
                    ClientResponse response = (ClientResponse)resource.type("application/octet-stream").put(ClientResponse.class, (Object)is);
                    if (response.getStatus() != 200 && response.getStatus() != 201) {
                        throw new QuickbuildException("Failed to deploy artifacts: " + (String)response.getEntity(String.class));
                    }
                    Map map = (Map)mapper.readValue((String)response.getEntity(String.class), Map.class);
                    ArtifactItem item = new ArtifactItem();
                    item.setUrl((String)map.get("downloadUri"));
                    item.setRepoName(this.getRepoName());
                    item.setPath(StringUtils.stripStart((String)((String)map.get("path")), (String)"/"));
                    item.setSize(Long.valueOf((String)map.get("size")));
                    Map checkSums = (Map)map.get("checksums");
                    item.setMd5((String)checkSums.get("md5"));
                    item.setSha1((String)checkSums.get("sha1"));
                    artifacts.add(item);
                }
                catch (Exception e) {
                    try {
                        throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)is);
            }
            build.getReports().put(BUILD_DATA_KEY, artifacts);
        }
    }
}

