/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.filesystem;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.filesystem.FileSystemRevision;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.setting.repository.usermapping.UserMapping;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="File System", description="This repository can be used to copy files from arbitrary directory in the file system into the configuration workspace. QuickBuild is able to detect changes in the directory and only copy changed files.")
@ScriptApi
public class FileSystemRepository
extends Repository<FileSystemRevision> {
    private static final long serialVersionUID = 1L;
    private String srcPath;
    private String destPath;

    public UserMapping getUserMapping() {
        return super.getUserMapping();
    }

    @Editable(order=100, name="Source Directory", description="Specify absolute path of the source directory of this repository. Changes will be detected in this directory based on modification time, and modified files under this directory will be copied to the workspace upon checkout.")
    @NotEmpty
    @ScriptApi(value="Get source path to copy files from.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=200, name="Destination Directory", description="Specify a directory relative to the workspace. Contents under the above source directory will be copied into this directory. When left empty, files will be copied into the workspace directory.")
    @ScriptApi(value="Get destination path to place copied files. Null if copy files into workspace directory.")
    @Scriptable
    public String getDestPath() {
        if (this.destPath == null) {
            return "";
        }
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    protected void checkoutByRevision(FileSystemRevision revision) {
        Context.getLogger().warn("This repository does not support to checkout against specified date, checking out latest instead...");
        File srcDir = new File(this.getSrcPath());
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            throw new QuickbuildException("'" + this.getSrcPath() + "' does not exist or " + "is not a directory.");
        }
        if (!srcDir.isAbsolute()) {
            throw new QuickbuildException("'" + this.getSrcPath() + "' should be defined as " + "an absolute directory");
        }
        File destDir = this.getDestPath() != null ? new File(Context.getConfiguration().getWorkspaceDir(), this.getDestPath()) : Context.getConfiguration().getWorkspaceDir();
        Context.getLogger().debug("Copying files recursively (from dir: {}, to dir: {})", (Object)srcDir.getAbsolutePath(), (Object)destDir.getAbsolutePath());
        FileUtils.copyDir((File)srcDir, (File)destDir);
    }

    protected FileSystemRevision getHeadRevision() {
        return new FileSystemRevision(new Date());
    }

    @ScriptApi(value="Get revision of this repository.")
    public FileSystemRevision getRevision() {
        return (FileSystemRevision)super.getRevision();
    }

    protected void labelOnRevision(FileSystemRevision revision, String label, String comment) {
        throw new UnsupportedOperationException();
    }

    protected List<Changeset> getChangesBetween(FileSystemRevision startRevision, FileSystemRevision endRevision) {
        ArrayList<Changeset> changesets = new ArrayList<Changeset>();
        File sourceDir = new File(this.getSrcPath());
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            Context.getLogger().warn("Changes can not be calculated since '" + this.getSrcPath() + "' does not exist or is not a directory.");
        } else if (!sourceDir.isAbsolute()) {
            Context.getLogger().warn("Changes are not calculated since '" + this.getSrcPath() + "' is not defined as an absolute directory.");
        } else {
            this.getFileChangesBetween(sourceDir, startRevision.getValue(), endRevision.getValue(), changesets);
        }
        return changesets;
    }

    private void getFileChangesBetween(File file, Date startDate, Date endDate, List<Changeset> changesets) {
        File[] childs;
        Date lastModified = new Date(file.lastModified());
        if (lastModified.after(startDate) && lastModified.before(endDate)) {
            Modification modification = new Modification();
            modification.setAction(Modification.Action.MODIFY);
            modification.setPath(file.getAbsolutePath());
            modification.setEdition(String.valueOf(lastModified.getTime()));
            Changeset changeset = new Changeset();
            changeset.setDate(lastModified);
            changeset.setId(UUID.randomUUID().toString());
            changeset.getModifications().add(modification);
            changesets.add(changeset);
        }
        if (file.isDirectory() && (childs = file.listFiles()) != null) {
            for (int i = 0; i < childs.length; ++i) {
                File child = childs[i];
                this.getFileChangesBetween(child, startDate, endDate, changesets);
            }
        }
    }

    public SourceViewSupport<FileSystemRevision> getSourceViewSupport() {
        return new SourceViewSupport<FileSystemRevision>((Repository)this){

            public List<String> readSourceByRevision(String repositoryPath, FileSystemRevision revision) {
                File file = new File(repositoryPath);
                if (!file.exists() || file.isDirectory() || file.lastModified() > revision.getValue().getTime()) {
                    return null;
                }
                return FileUtils.readFileAsLines((File)file);
            }

            public List<String> readSourceByEdition(String repositoryPath, String edition) {
                File file = new File(repositoryPath);
                if (!file.exists() || file.isDirectory() || file.lastModified() != new Date(Long.parseLong(edition)).getTime()) {
                    return null;
                }
                return FileUtils.readFileAsLines((File)file);
            }

            public String getRepositoryPath(String checkoutPath) {
                File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
                File destDir = FileSystemRepository.this.getDestPath() != null ? new File(Context.getConfiguration().getWorkspaceDir(), FileSystemRepository.this.getDestPath()) : Context.getConfiguration().getWorkspaceDir();
                String relativePath = FileUtils.getRelativePath((String)checkoutFile.getAbsolutePath(), (String)destDir.getAbsolutePath());
                if (relativePath == null || relativePath.length() == 0) {
                    return null;
                }
                return new File(FileSystemRepository.this.getSrcPath(), relativePath).getAbsolutePath();
            }
        };
    }

    public ProofBuildSupport<LocalChange> getProofBuildSupport() {
        return null;
    }

    protected boolean isQuietSince(Date date) {
        return this.getChangesBetween(new FileSystemRevision(date), new FileSystemRevision(new Date())).isEmpty();
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }
}

