/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.utils;

import com.pmease.quickbuild.addons.jira.utils.ExceptionUtils;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private static boolean isXPath(String path) {
        return path.indexOf(47) >= 0;
    }

    public static String getString(Node node, String path, String defaultValue) {
        if (node == null) {
            return null;
        }
        String value = null;
        switch (node.getNodeType()) {
            case 2: {
                value = node.getStringValue();
                break;
            }
            case 1: {
                if (XMLHelper.isXPath(path)) {
                    value = node.valueOf(path);
                    break;
                }
                Element element = (Element)node;
                if (element.attribute(path) != null) {
                    value = element.attributeValue(path);
                    break;
                }
                if ((element = element.element(path)) == null) break;
                value = element.getText();
                break;
            }
            default: {
                value = node.getText();
            }
        }
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getString(Node node, String name) {
        return XMLHelper.getString(node, name, null);
    }

    public static Boolean getBoolean(Node node, String name, Boolean defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(strValue);
    }

    public static Integer getInt(Node node, String name, Integer defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return Integer.valueOf(strValue);
    }

    public static Long getLong(Node node, String name, Long defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return Long.valueOf(strValue);
    }

    public static Double getDouble(Node node, String name, Double defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return Double.valueOf(strValue);
    }

    public static <T extends Enum> T getEnum(Node node, String path, Class<T> cls) {
        String str = XMLHelper.getString(node, path);
        if (str == null) {
            return (T)((Enum[])cls.getEnumConstants())[0];
        }
        return Enum.valueOf(cls, str);
    }

    private static DateFormat getISO8601Format() {
        return new SimpleDateFormat(ISO8601_FORMAT);
    }

    public static Date parseISO8601Date(String str) {
        try {
            return XMLHelper.getISO8601Format().parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDate(Node node, String path) {
        return XMLHelper.getDate(node, path, null);
    }

    public static Date getDate(Node node, String path, String pattern) {
        String str = XMLHelper.getString(node, path);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        if (StringUtils.isEmpty((String)pattern)) {
            return XMLHelper.parseISO8601Date(str);
        }
        DateTime dt = DateTimeFormat.forPattern((String)pattern).parseDateTime(str);
        return dt.toDate();
    }

    public static Document readXML(InputStream in) {
        SAXReader reader = new SAXReader();
        try {
            reader.setValidation(false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = reader.read(in);
            return document;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static Document readXML(File file) {
        SAXReader reader = new SAXReader(false);
        try {
            reader.setValidation(false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return reader.read(file);
        }
        catch (DocumentException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        catch (SAXException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }
}

