/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.service;

import com.atlassian.jira.issue.Issue;
import com.pmease.quickbuild.addons.jira.model.BuildChangeset;
import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.JerseyParser;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QuickBuildClient {
    private static final Logger logger = Logger.getLogger(QuickBuildClient.class);
    private final QuickBuild server;
    private final Client client;
    static final String BASE_URL = "/rest/jira";
    static final String BUILDS_URL = "/rest/jira/builds";
    private static final String CONFIGURATION_ID_URL = "/rest/ids";
    private static int DEFAULT_SIZE = 50;

    public QuickBuildClient(QuickBuild server) {
        this.server = server;
        this.client = this.createClient();
        this.client.removeAllFilters();
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(server.getUsername(), server.getPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client createClient() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Client client = null;
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            client = Client.create();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (client == null) {
            throw new RuntimeException("Unable to create Jersey client.");
        }
        return client;
    }

    public BuildSet getBuildsOfProject(String projectKey) {
        BuildSet buildset = new BuildSet(this.server);
        for (String configuration : this.server.getConfigurations(projectKey)) {
            List<BuildFragment> builds = this.getLatestBuilds(configuration);
            buildset.getBuilds().put(configuration, builds);
        }
        return buildset;
    }

    public BuildSet getBuildsOfIssue(Issue issue) {
        String projectKey = issue.getProjectObject().getKey();
        Set<String> configurations = this.server.getConfigurations(projectKey);
        if (configurations.isEmpty()) {
            throw new RuntimeException("No configuration found! Please associate the JIRA project with QuickBuild configuration(s) from Administration -> QuickBuild Server.");
        }
        BuildSet buildset = new BuildSet(this.server);
        for (String configuration : configurations) {
            List<BuildFragment> builds = this.getIssueBuilds(configuration, issue.getKey());
            for (BuildFragment b : builds) {
                b.setConfigurationPath(configuration);
            }
            buildset.getBuilds().put(configuration, builds);
        }
        return buildset;
    }

    public List<BuildChangeset> getChangesOfIssue(Issue issue) {
        String projectKey = issue.getProjectObject().getKey();
        Set<String> configurations = this.server.getConfigurations(projectKey);
        if (configurations.isEmpty()) {
            throw new RuntimeException("No configuration found! Please associate the JIRA project with QuickBuild configuration(s) from Administration -> QuickBuild Server.");
        }
        ArrayList<BuildChangeset> changes = new ArrayList<BuildChangeset>();
        for (String configuration : configurations) {
            logger.debug((Object)("Retrieving from configuration: " + configuration));
            List<Changeset> subchanges = this.getIssueChanges(configuration, issue);
            ArrayList<Long> buildIds = new ArrayList<Long>();
            for (Changeset each : subchanges) {
                if (buildIds.contains(each.getBuildId())) continue;
                buildIds.add(each.getBuildId());
            }
            List<BuildFragment> builds = this.getBuildsByIds(configuration, buildIds);
            logger.debug((Object)("Found total " + builds.size() + " builds."));
            for (BuildFragment each : builds) {
                BuildChangeset buildchange = new BuildChangeset(each);
                Iterator<Changeset> it = subchanges.iterator();
                while (it.hasNext()) {
                    Changeset change = it.next();
                    if (!each.getId().equals(change.getBuildId())) continue;
                    buildchange.addChangeset(change);
                    it.remove();
                }
                if (buildchange.size() <= 0) continue;
                changes.add(buildchange);
            }
        }
        logger.debug((Object)("buildchangeset size: " + changes.size()));
        return changes;
    }

    private List<BuildFragment> getLatestBuilds(String configuration) {
        WebResource resource = this.client.resource(this.server.getHost()).path(BUILDS_URL).path(configuration).queryParam("count", String.valueOf(DEFAULT_SIZE));
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        String entity = (String)response.getEntity(String.class);
        if (status == ClientResponse.Status.OK) {
            return JerseyParser.parseBuilds(this.server, entity);
        }
        throw new RuntimeException(entity);
    }

    private List<BuildFragment> getBuildsByIds(String configuration, List<Long> buildIds) {
        if (buildIds.isEmpty()) {
            return Collections.emptyList();
        }
        String ids = StringUtils.join(buildIds, (String)",");
        WebResource resource = this.client.resource(this.server.getHost()).path(BUILDS_URL).path(configuration).queryParam("ids", ids);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        String entity = (String)response.getEntity(String.class);
        if (status == ClientResponse.Status.OK) {
            return JerseyParser.parseBuilds(this.server, entity);
        }
        throw new RuntimeException(entity);
    }

    private List<BuildFragment> getIssueBuilds(String configuration, String key) {
        WebResource resource = this.client.resource(this.server.getHost()).path(BASE_URL).path(key).path("builds").path(configuration);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        String entity = (String)response.getEntity(String.class);
        if (status == ClientResponse.Status.OK) {
            return JerseyParser.parseBuilds(this.server, entity);
        }
        throw new RuntimeException(entity);
    }

    private List<Changeset> getIssueChanges(String configuration, Issue issue) {
        WebResource resource = this.client.resource(this.server.getHost()).path(BASE_URL).path(issue.getKey()).path("changes").path(configuration).queryParam("count", String.valueOf(DEFAULT_SIZE));
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        String entity = (String)response.getEntity(String.class);
        if (status == ClientResponse.Status.OK) {
            return JerseyParser.parseChanges(entity);
        }
        throw new RuntimeException(entity);
    }

    @Deprecated
    public Long getConfigurationId(String path) {
        WebResource resource = this.client.resource(this.server.getHost()).path(CONFIGURATION_ID_URL).queryParam("configuration_path", path);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            return Long.valueOf(entity);
        }
        throw new RuntimeException(entity);
    }
}

