/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.Modification;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.utils.XMLHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class JerseyParser {
    private static final Logger logger = Logger.getLogger(JerseyParser.class);

    public static List<Changeset> parseChanges(String xml) {
        if (StringUtils.isBlank((String)xml)) {
            return Collections.emptyList();
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            ArrayList<Changeset> changesets = new ArrayList<Changeset>();
            List nodes = doc.selectNodes("//changeset");
            for (Element node : nodes) {
                Changeset commit = JerseyParser.parseChangeset(node);
                if (commit == null) continue;
                changesets.add(commit);
            }
            return changesets;
        }
        catch (DocumentException e) {
            logger.error((Object)"Parse issue changes rest document failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<BuildFragment> parseBuilds(QuickBuild server, String xml) {
        if (StringUtils.isEmpty((String)xml)) {
            return Collections.emptyList();
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            ArrayList<BuildFragment> builds = new ArrayList<BuildFragment>();
            Element root = doc.getRootElement();
            for (Object node : root.elements("build")) {
                BuildFragment b = JerseyParser.parseBuild(server, (Element)node);
                if (b == null || b.getId() <= 0L) continue;
                builds.add(b);
            }
            return builds;
        }
        catch (DocumentException e) {
            logger.error((Object)"Parse issue builds rest document failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static BuildFragment parseBuild(QuickBuild server, Element node) {
        BuildFragment build = new BuildFragment(server);
        if (node == null) {
            return build;
        }
        build.setId(XMLHelper.getLong((Node)node, "id", null));
        build.setVersion(XMLHelper.getString((Node)node, "version"));
        build.setStatus(XMLHelper.getString((Node)node, "status"));
        build.setDuration(XMLHelper.getLong((Node)node, "duration", 0L));
        build.setDeleted(XMLHelper.getBoolean((Node)node, "deleted", false));
        build.setScheduled(XMLHelper.getBoolean((Node)node, "scheduled", false));
        build.setBeginDate(XMLHelper.getDate((Node)node, "beginDate"));
        build.setRequester(XMLHelper.getString((Node)node, "requester"));
        return build;
    }

    public static Changeset parseChangeset(Element node) {
        Changeset change = new Changeset();
        if (node == null) {
            return change;
        }
        change.setId(XMLHelper.getString((Node)node, "id"));
        change.setBuildId(XMLHelper.getLong((Node)node, "buildId", 0L));
        change.setUser(XMLHelper.getString((Node)node, "user"));
        change.setComment(XMLHelper.getString((Node)node, "comment"));
        change.setRepositoryName(XMLHelper.getString((Node)node, "repositoryName"));
        change.setRepositoryType(XMLHelper.getString((Node)node, "repositoryType"));
        change.setDate(XMLHelper.getDate((Node)node, "date"));
        change.setAdditional(XMLHelper.getString((Node)node, "additional"));
        List nodes = node.selectNodes("./modifications/modification");
        for (Element each : nodes) {
            Modification modification = JerseyParser.parseModification(each);
            change.addModification(modification);
        }
        return change;
    }

    public static Modification parseModification(Element node) {
        Modification modification = new Modification();
        if (node == null) {
            return modification;
        }
        modification.setAction(XMLHelper.getString((Node)node, "action"));
        modification.setEdition(XMLHelper.getString((Node)node, "edition"));
        modification.setPath(XMLHelper.getString((Node)node, "path"));
        modification.setPathType(XMLHelper.getString((Node)node, "pathType"));
        modification.setPreviousEdition(XMLHelper.getString((Node)node, "previousEdition"));
        modification.setAdditional(XMLHelper.getString((Node)node, "additional"));
        return modification;
    }
}

