/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.Modification;
import com.pmease.quickbuild.addons.jira.utils.ExceptionUtils;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class IssueChange
implements Comparable<IssueChange> {
    private final Changeset changeset;
    private List<BuildFragment> builds = new ArrayList<BuildFragment>();
    public static final String BUILD_ID = "build";
    public static final String PREVIOUS_BUILD_ID = "previous_build";
    public static final String REPOSITORY = "repository";
    public static final String FILE_PATH = "file";
    public static final String FILE_EDITION = "edition";
    public static final String PREVIOUS_EDITION = "previous_edition";

    public IssueChange(Changeset changeset) {
        this.changeset = changeset;
    }

    public List<BuildFragment> getBuilds() {
        return this.builds;
    }

    public void addBuild(BuildFragment build) {
        if (build != null && !this.builds.contains(build)) {
            this.builds.add(build);
        }
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public String getId() {
        return this.changeset.getChangesetId();
    }

    @Override
    public int compareTo(IssueChange other) {
        if (other == null) {
            return 1;
        }
        return this.changeset.compareTo(other.changeset);
    }

    public BuildFragment getValidBuild() {
        for (BuildFragment each : this.builds) {
            if (each.isDeleted()) continue;
            return each;
        }
        return null;
    }

    public String formatBuildLinks() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.builds.size(); ++i) {
            sb.append(this.builds.get(i).formatAsLink());
            if (i + 1 >= this.builds.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    static String appendUrl(String key, String value) {
        try {
            return new StringBuffer().append(key).append("=").append(URLEncoder.encode(value, "UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public String getViewSourceUrl(Modification modification) {
        BuildFragment build = this.getValidBuild();
        if (build == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.normalizeUrl(build.getServer().getHost())).append("/source/view?").append(BUILD_ID).append("=").append(build.getId()).append("&").append(IssueChange.appendUrl(REPOSITORY, this.changeset.getRepositoryName())).append("&").append(IssueChange.appendUrl(FILE_PATH, modification.getPath())).append("&").append(IssueChange.appendUrl(FILE_EDITION, modification.getEdition()));
        return sb.toString();
    }

    public String getDiffSourceUrl(Modification modification) {
        BuildFragment build = this.getValidBuild();
        if (build == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.normalizeUrl(build.getServer().getHost())).append("/source/diff?").append(BUILD_ID).append("=").append(build.getId()).append("&").append(IssueChange.appendUrl(REPOSITORY, this.changeset.getRepositoryName())).append("&").append(IssueChange.appendUrl(FILE_PATH, modification.getPath())).append("&").append(IssueChange.appendUrl(FILE_EDITION, modification.getEdition())).append("&").append(IssueChange.appendUrl(PREVIOUS_EDITION, modification.getPreviousEdition()));
        return sb.toString();
    }
}

