/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.issuepanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.issue.ViewIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.issuepanel.FeedbackAction;
import com.pmease.quickbuild.addons.jira.issuepanel.IssueChangesAction;
import com.pmease.quickbuild.addons.jira.model.BuildChangeset;
import com.pmease.quickbuild.addons.jira.model.BuildFragment;
import com.pmease.quickbuild.addons.jira.model.Changeset;
import com.pmease.quickbuild.addons.jira.model.IssueChange;
import com.pmease.quickbuild.addons.jira.model.IssueChanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;

public class IssueChangesTabPanel
extends AbstractIssueTabPanel {
    private static final Logger logger = Logger.getLogger(IssueChangesTabPanel.class);
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final QuickBuildManager qbManager;
    private final VelocityRequestContextFactory requestContextFactory;

    public IssueChangesTabPanel(QuickBuildManager qbManager, PermissionManager permissionManager, WebResourceManager webResourceManager, VelocityRequestContextFactory requestContextFactory) {
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
        this.requestContextFactory = requestContextFactory;
    }

    static void reverseChanges(List<BuildChangeset> changes) {
        if (changes.isEmpty()) {
            return;
        }
        Collections.reverse(changes);
        for (BuildChangeset each : changes) {
            Collections.reverse(each.getChangesets());
        }
    }

    static List<RestResult<IssueChanges>> mergeChanges(List<RestResult<List<BuildChangeset>>> buildChangesets) {
        logger.debug((Object)("Merge changes, original size: " + buildChangesets.size()));
        ArrayList<RestResult<IssueChanges>> result = new ArrayList<RestResult<IssueChanges>>();
        for (RestResult<List<BuildChangeset>> each : buildChangesets) {
            RestResult<IssueChanges> rr = new RestResult<IssueChanges>(each.getServer());
            if (each.hasErrors()) {
                rr.setErrors(each.getErrors());
            } else {
                IssueChanges changes = IssueChangesTabPanel.toIssueChanges(each.getResult());
                logger.debug((Object)("to issue changes, size: " + changes.size()));
                rr.setResult(changes);
            }
            result.add(rr);
        }
        logger.debug((Object)("Merged, size: " + result.size()));
        return result;
    }

    static IssueChanges toIssueChanges(List<BuildChangeset> changesets) {
        LinkedHashMap<String, IssueChange> changes = new LinkedHashMap<String, IssueChange>();
        for (BuildChangeset each : changesets) {
            BuildFragment build = each.getBuild();
            for (Changeset changeset : each.getChangesets()) {
                String id = changeset.getChangesetId();
                IssueChange issuechange = (IssueChange)changes.get(id);
                if (issuechange == null) {
                    issuechange = new IssueChange(changeset);
                    issuechange.addBuild(build);
                    changes.put(id, issuechange);
                    continue;
                }
                issuechange.addBuild(build);
            }
        }
        return new IssueChanges(changes.values());
    }

    public List getActions(Issue issue, User user) {
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-css");
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-js");
        try {
            List<RestResult<List<BuildChangeset>>> allchanges = this.qbManager.getIssueChanges(issue);
            boolean isDesc = !this.isSortingActionsInAscendingOrder();
            List<RestResult<IssueChanges>> rr = IssueChangesTabPanel.mergeChanges(allchanges);
            logger.debug((Object)("Merged changes total: " + rr.size()));
            if (isDesc) {
                for (RestResult<IssueChanges> each : rr) {
                    IssueChanges changes = each.getResult();
                    if (changes == null) continue;
                    Collections.reverse(each.getResult());
                }
            }
            IssueChangesAction action = new IssueChangesAction(rr, this.descriptor);
            return Lists.newArrayList((Object[])new IssueChangesAction[]{action});
        }
        catch (Exception e) {
            logger.error((Object)"Retrieve changes failed.", (Throwable)e);
            FeedbackAction action = new FeedbackAction("<h3>Retrive Changes Failed!</h3><p>" + e.getMessage() + "</p>", FeedbackAction.Level.ERROR);
            return Lists.newArrayList((Object[])new GenericMessageAction[]{action});
        }
    }

    public boolean showPanel(Issue issue, User user) {
        if (!this.permissionManager.hasPermission(29, issue, user)) {
            return false;
        }
        String projectKey = issue.getProjectObject().getKey();
        return this.qbManager.isProjectAssociated(projectKey);
    }

    boolean isSortingActionsInAscendingOrder() {
        try {
            Action viewIssueAction = ActionFactory.getActionFactory().getActionImpl(ViewIssue.class.getName());
            return !StringUtils.equalsIgnoreCase((String)this.getActionSortOrder(viewIssueAction), (String)"desc");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to figure out how actions are sorted. I'm going to default to ascending", (Throwable)e);
            return true;
        }
    }

    private String getActionSortOrder(Action viewIssueAction) {
        String defaultOrder = ((ViewIssue)viewIssueAction).getApplicationProperties().getDefaultString("jira.issue.actions.order");
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String actionOrder = requestContext.getRequestParameter("actionOrder");
        VelocityRequestSession session = requestContext.getSession();
        if (StringUtils.isNotBlank((String)actionOrder)) {
            if (!actionOrder.equals(defaultOrder)) {
                session.setAttribute("jira.issue.action.order", (Object)actionOrder);
                return defaultOrder;
            }
            session.removeAttribute("jira.issue.action.order");
            return defaultOrder;
        }
        actionOrder = (String)session.getAttribute("jira.issue.action.order");
        if (StringUtils.isNotBlank((String)actionOrder)) {
            return actionOrder;
        }
        return defaultOrder;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }
}

