/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.action;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.action.AddQuickBuildServerAction;
import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import java.util.Map;

public class UpdateQuickBuildServerAction
extends AddQuickBuildServerAction {
    private static final long serialVersionUID = 1L;
    private Long quickbuildServerId = -1L;

    public UpdateQuickBuildServerAction(QuickBuildManager manager, WebResourceManager webResourceManager) {
        super(manager, webResourceManager);
    }

    @Override
    public String doDefault() {
        if ("error".equals(super.doDefault())) {
            return "error";
        }
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        QuickBuild serverToEdit = this.getManager().get(this.quickbuildServerId);
        if (serverToEdit == null) {
            return this.getRedirect("ViewQuickBuildServers.jspa");
        }
        this.server = new QuickBuild(serverToEdit);
        this.password = this.server.getPassword();
        this.projectMapping = this.getAssociations(this.server);
        return "input";
    }

    protected String getAssociations(QuickBuild server) {
        Map<String, String> map = server.getProjectPathAssociations();
        StringBuilder sb = new StringBuilder();
        for (String key : map.keySet()) {
            sb.append(key).append('=').append(map.get(key)).append("\n");
        }
        return sb.toString().trim();
    }

    @Override
    public void doValidation() {
        super.doValidation();
        if (this.quickbuildServerId == -1L) {
            this.addErrorMessage("QuickBuild id is missing.");
            return;
        }
        QuickBuild original = this.getManager().get(this.quickbuildServerId);
        if (original == null) {
            this.addErrorMessage("Can't find this QuickBuild server. Maybe already deleted by others.");
            return;
        }
        if (!original.getName().equalsIgnoreCase(this.server.getName()) && this.getManager().hasServer(this.server.getName())) {
            this.addError("name", "The server name has been defined already.");
        }
    }

    @Override
    public String doExecute() {
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.quickbuildServerId == -1L) {
            return this.getRedirect("ViewQuickBuildServers.jspa");
        }
        this.server.setId(this.quickbuildServerId);
        this.server.setProjectPathAssociations(Utils.stringToMap(this.projectMapping));
        this.server.setPassword(this.password);
        this.getManager().update(this.server);
        return this.getRedirect("ViewQuickBuildServers.jspa");
    }

    public Long getQuickbuildServerId() {
        return this.quickbuildServerId;
    }

    public void setQuickbuildServerId(Long quickbuildServerId) {
        this.quickbuildServerId = quickbuildServerId;
    }
}

