/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.starteam;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRepositoryProxy;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarTeamSourceViewSupport
extends SourceViewSupport<StarTeamRevision> {
    private static final Logger logger = LoggerFactory.getLogger(StarTeamSourceViewSupport.class);

    public StarTeamSourceViewSupport(StarTeamRepositoryProxy proxy) {
        super((Repository)proxy);
    }

    public StarTeamRepositoryProxy getProxy() {
        return (StarTeamRepositoryProxy)this.getRepository();
    }

    public String getRepositoryPath(String checkoutPath) {
        return this.getProxy().getRepository().getRepositoryPath(checkoutPath);
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        View view = null;
        File tempDir = FileUtils.createTempDir((String)"starteamreadsource");
        try {
            com.starbase.starteam.File file;
            String folderPath;
            view = this.getProxy().getRepository().openView();
            if (repositoryPath.contains("/")) {
                folderPath = StringUtils.substringBeforeLast((String)repositoryPath, (String)"/");
                Folder folder = StarTeamFinder.findFolder((Folder)view.getRootFolder(), (String)folderPath);
                if (folder == null) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Can not find folder", (Object[])new Object[]{"view url", this.getProxy().getRepository().getViewUrlDescription(), "folder", folderPath}));
                }
                folder.setAlternatePathFragment(tempDir.getAbsolutePath());
                file = StarTeamFinder.findFile((Folder)folder, (String)StringUtils.substringAfterLast((String)repositoryPath, (String)"/"), (boolean)true);
            } else {
                view.getRootFolder().setAlternatePathFragment(tempDir.getAbsolutePath());
                file = StarTeamFinder.findFile((Folder)view.getRootFolder(), (String)StringUtils.substringAfterLast((String)repositoryPath, (String)"/"), (boolean)true);
            }
            if (file == null) {
                Context.getLogger().warn("Can not find file in StarTeam view (view url:{}, file:{})", (Object)this.getProxy().getRepository().getViewUrlDescription(), (Object)repositoryPath);
                folderPath = null;
                return folderPath;
            }
            for (Item item : file.getHistory()) {
                com.starbase.starteam.File historyFile = (com.starbase.starteam.File)item;
                if (historyFile.getContentVersion() != Integer.parseInt(edition)) continue;
                historyFile.checkout(3, true, true, false);
                List list = FileUtils.readFileAsLines((File)new File(historyFile.getFullName()));
                return list;
            }
            logger.warn("Can not find file revision in StarTeam view (view url: {}, file: {}, revision: {})", new Object[]{this.getProxy().getRepository().getViewUrlDescription(), repositoryPath, edition});
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteDir((File)tempDir);
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    public List<String> readSourceByRevision(String repositoryPath, StarTeamRevision revision) {
        View view = null;
        File tempDir = FileUtils.createTempDir((String)"starteamreadsource");
        try {
            List list;
            com.starbase.starteam.File file;
            view = this.getProxy().getRepository().openView();
            View snapshot = this.getProxy().getRepository().getSnapshot(view, revision);
            if (repositoryPath.contains("/")) {
                String folderPath = StringUtils.substringBeforeLast((String)repositoryPath, (String)"/");
                Folder folder = StarTeamFinder.findFolder((Folder)snapshot.getRootFolder(), (String)folderPath);
                if (folder == null) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Can not find folder", (Object[])new Object[]{"view url", this.getProxy().getRepository().getViewUrlDescription(), "folder", folderPath}));
                }
                folder.setAlternatePathFragment(tempDir.getAbsolutePath());
                file = StarTeamFinder.findFile((Folder)folder, (String)StringUtils.substringAfterLast((String)repositoryPath, (String)"/"), (boolean)true);
            } else {
                view.getRootFolder().setAlternatePathFragment(tempDir.getAbsolutePath());
                file = StarTeamFinder.findFile((Folder)snapshot.getRootFolder(), (String)StringUtils.substringAfterLast((String)repositoryPath, (String)"/"), (boolean)true);
            }
            if (file == null) {
                logger.warn("Can not find file in StarTeam snapshot view (view url:{}, file:{})", (Object)this.getProxy().getRepository().getViewUrlDescription(), (Object)repositoryPath);
                list = null;
                return list;
            }
            file.checkout(3, true, true, false);
            list = FileUtils.readFileAsLines((File)new File(file.getFullName()));
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteDir((File)tempDir);
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }
}

