/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.starteam;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRepository;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRevision;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamSourceViewSupport;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="StarTeam", descriptionProvider="getTypeDescription")
@ScriptApi(value="This class acts as proxy to the internal StarTeam repository object.")
public class StarTeamRepositoryProxy
extends Repository<StarTeamRevision> {
    private static final long serialVersionUID = 1L;
    private String projectLocation;
    private String viewName;
    private String srcPath;
    private String labelName;
    private boolean recursive = true;
    private String destPath;
    private String userName;
    private String password;
    @XStreamOmitField
    private UserInfo userInfo;
    private StarTeamProofBuildSupport proofBuildSupport;

    @Editable(order=100, description="Location of a StarTeam project is defined as: <em>&lt;servername&gt;:&lt;portnum&gt;/&lt;projectname&gt;</em>, where <em>&lt;servername&gt;</em> is the host where the StarTeam server runs, <em>&lt;portnum&gt;</em> is the port number the StarTeam server uses, default value is <em>49201</em>. <em>&lt;projectname&gt;</em> is a StarTeam project under this StarTeam server.")
    @NotEmpty
    @ScriptApi(value="Get location of the project.")
    @Scriptable
    public String getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    @Editable(order=110, name="Build View", description="Specify a StarTeam view of the above project to checkout and build against.")
    @NotEmpty
    @ScriptApi(value="Get name of StarTeam view against which to checkout code and build.")
    @Scriptable
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Editable(order=120, name="Source Path", description="Specify a path relative to root directory of the above StarTeam view. If left empty, the root directory itself will be checkout.")
    @ScriptApi(value="Get source path relative to root directory of the build view. Null if root directory itself will be checked out.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=130, name="Label", description="Specify the label for the above StarTeam view. When left empty, the latest version of the view will be used for checkout.")
    @Expressions(value={"Label of Promotion State \"xyz\"", "${current.repository.getPromotionStateLabel(\"xyz\")}"})
    @Scriptable
    @ScriptApi(value="Get label name to checkout. Null if check out the latest version.")
    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    @Editable(order=135, description="")
    @ScriptApi(value="Whether or not to checkout above path recursively.")
    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Editable(order=140, name="Destination Path", description="Specify the directory relative to the checkouts directory of current configuration. Contents under the above from path will be retrieved to this directory. When left empty, retrieved code will be put into directory specified in from path, relative to the workspace directory.")
    @Scriptable
    @ScriptApi(value="Get destination path where to put checked out files. Null if check out files should be put into the workspace directory.")
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=200, description="Specify user name to login to StarTeam server.")
    @NotEmpty
    @ScriptApi(value="Get user name to access the StarTeam server.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=300, description="Specify the password for above user.")
    @Password
    @ScriptApi(value="Get password to access the StarTeam server.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=400, description="Check this to enable proof build for this repository.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled.")
    @Advanced
    public StarTeamProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(StarTeamProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @ScriptApi(value="Get revision of this repository.")
    public StarTeamRevision getRevision() {
        return (StarTeamRevision)super.getRevision();
    }

    String getRepositoryPath(File checkoutFile) {
        String relativePath = FileUtils.getRelativePath((String)checkoutFile.getAbsolutePath(), (String)this.getDestDir().getAbsolutePath());
        if (StringUtils.isBlank((String)relativePath)) {
            return null;
        }
        if (this.getSrcPath() == null) {
            return relativePath.substring(1);
        }
        return StringUtils.strip((String)this.getSrcPath().replace('\\', '/'), (String)"/") + relativePath;
    }

    File getDestDir() {
        if (this.getDestPath() != null) {
            return new File(Context.getConfiguration().getWorkspaceDir(), this.getDestPath());
        }
        return Context.getConfiguration().getWorkspaceDir();
    }

    public static String getTypeDescription() {
        try {
            Class.forName("com.starbase.starteam.Project");
            return "Configure a StarTeam repository.";
        }
        catch (ClassNotFoundException e) {
            return "<span class='red'>StarTeam API library not found</span>, please make sure that StarTeam client is installed on the build machine, and copy the StarTeam API library file (normally starteamXX.jar, where XX stands for StarTeam API version) to directory <code>" + Bootstrap.getLibsDir().getAbsolutePath() + "</code> and restart the server.<br>" + "<strong>NOTE:</strong> You will also need to install StarTeam client to build agents if " + "you plan to run StarTeam related steps on those agents and if the agents are running on " + "a Windows platform.";
        }
    }

    protected void checkoutByRevision(StarTeamRevision revision) {
        this.getRepository().checkoutByRevision(revision);
    }

    protected List<Changeset> getChangesBetween(StarTeamRevision startRevision, StarTeamRevision endRevision) {
        List<Changeset> changes = this.getRepository().getChangesBetween(startRevision, endRevision);
        for (Changeset change : changes) {
            if (change.getId() == null) {
                change.setId(UUID.randomUUID().toString());
            }
            if (change.getDate() != null) continue;
            change.setDate(new Date());
        }
        return changes;
    }

    protected StarTeamRevision getHeadRevision() {
        return this.getRepository().getHeadRevision();
    }

    public SourceViewSupport<StarTeamRevision> getSourceViewSupport() {
        return new StarTeamSourceViewSupport(this);
    }

    protected void labelOnRevision(StarTeamRevision revision, String label, String comment) {
        this.getRepository().labelOnRevision(revision, label, comment);
    }

    @ScriptApi(value="Get the repository object.")
    public StarTeamRepository getRepository() {
        return new StarTeamRepository(this);
    }

    protected boolean isQuietSince(Date date) {
        return this.getRepository().isQuietSince(date);
    }

    public String getEmail(String committer) {
        return this.getRepository().getEmail(committer);
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("recursive").setText("true");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element proofBuildSupportElement = dom.getRootElement().element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }

    UserInfo getUserInfo() {
        return this.userInfo;
    }

    void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    static class UserInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<Integer, String> id2logon = new HashMap<Integer, String>();
        private Map<String, String> logon2email = new HashMap<String, String>();

        UserInfo() {
        }

        public Map<Integer, String> getId2logon() {
            return this.id2logon;
        }

        public Map<String, String> getLogon2email() {
            return this.logon2email;
        }
    }
}

