/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.starteam;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRepositoryProxy;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRevision;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.FlatChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Label;
import com.starbase.starteam.Project;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.Topic;
import com.starbase.starteam.User;
import com.starbase.starteam.UserAccount;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

@Editable(name="StarTeam", descriptionProvider="getTypeDescription")
@ScriptApi
public class StarTeamRepository
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StarTeamRepositoryProxy proxy;

    public StarTeamRepository(StarTeamRepositoryProxy proxy) {
        this.proxy = proxy;
    }

    public String getProjectLocation() {
        return this.proxy.getProjectLocation();
    }

    public String getViewName() {
        return this.proxy.getViewName();
    }

    public String getSrcPath() {
        return this.proxy.getSrcPath();
    }

    public String getLabelName() {
        return this.proxy.getLabelName();
    }

    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    public String getDestPath() {
        return this.proxy.getDestPath();
    }

    public String getUserName() {
        return this.proxy.getUserName();
    }

    public String getPassword() {
        return this.proxy.getPassword();
    }

    public StarTeamProofBuildSupport getProofBuildSupport() {
        return this.proxy.getProofBuildSupport();
    }

    @ScriptApi
    public String getProjectUrl(String userName, String password) {
        if (password != null) {
            return userName + ":" + password + "@" + this.getProjectLocation();
        }
        return userName + "@" + this.getProjectLocation();
    }

    public String getProjectUrlDescription(String userName) {
        return userName + ":******@" + this.getProjectLocation();
    }

    @ScriptApi
    String getViewUrl() {
        return this.getProjectUrl(this.getUserName(), this.getPassword()) + "/" + this.getViewName();
    }

    String getViewUrlDescription() {
        return this.getProjectUrlDescription(this.getUserName()) + "/" + this.getViewName();
    }

    View openView() {
        View view = StarTeamFinder.openView((String)this.getViewUrl());
        if (view == null) {
            throw new QuickbuildException("Can not find view '" + this.getViewUrlDescription() + "'.");
        }
        return view;
    }

    private Label getLabel(View view, String labelName) {
        for (Label label : view.getLabels()) {
            if (label.isDeleted() || !label.getName().equals(labelName)) continue;
            if (!label.isViewLabel()) {
                throw new QuickbuildException("Please specify a view label to build against.");
            }
            return label;
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Can not find label", (Object[])new Object[]{"view", this.getViewUrlDescription(), "label", labelName}));
    }

    View getSnapshot(View view, StarTeamRevision revision) {
        if (view.getConfiguration().isTip()) {
            if (revision.getLabel() != null) {
                int labelId = this.getLabel(view, revision.getLabel()).getID();
                return new View(view, ViewConfiguration.createFromLabel((int)labelId));
            }
            return new View(view, ViewConfiguration.createFromTime((OLEDate)new OLEDate(revision.getDate())));
        }
        return view;
    }

    private void checkoutFolder(Folder folder) {
        File workingDir = new File(folder.getPath());
        if (!workingDir.exists()) {
            Context.getLogger().debug("Creating directory: " + workingDir.getAbsolutePath());
            FileUtils.createDir((File)workingDir);
        }
        try {
            folder.getServer().getTypeNames().getClass();
            for (Item item : folder.getItems("File")) {
                com.starbase.starteam.File file = (com.starbase.starteam.File)item;
                int fileStatus = file.getStatus();
                if (fileStatus == 6) {
                    Context.getLogger().debug("Updating file status: " + file.getFullName());
                    file.updateStatus(true, true);
                    fileStatus = file.getStatus();
                }
                if (fileStatus == 0) continue;
                Context.getLogger().debug("Checking out file: " + file.getFullName());
                file.checkout(3, true, true, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.isRecursive()) {
            for (Item item : folder.getSubFolders()) {
                this.checkoutFolder((Folder)item);
            }
        }
    }

    private Folder getSrcFolder(View view) {
        if (this.getSrcPath() != null) {
            Folder srcFolder = StarTeamFinder.findFolder((Folder)view.getRootFolder(), (String)this.getSrcPath());
            if (srcFolder == null) {
                throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Unable to find folder", (Object[])new Object[]{"view url", this.getViewUrlDescription(), "folder", this.getSrcPath()}));
            }
            return srcFolder;
        }
        return view.getRootFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkoutByRevision(StarTeamRevision revision) {
        View view = null;
        try {
            StarTeamRevision baseRevision;
            StarTeamRevision previousRevision;
            view = this.openView();
            View snapshot = this.getSnapshot(view, revision);
            Folder srcFolder = this.getSrcFolder(snapshot);
            Context.getLogger().info("Caching item props of checkout folder tree...");
            this.cacheItemProps(srcFolder);
            srcFolder.setAlternatePathFragment(this.getDestDir().getAbsolutePath());
            Context.getLogger().info("Checking out folder...");
            this.checkoutFolder(srcFolder);
            Context.getLogger().info("Calculating changes since last checkout to remove deleted files...");
            File revisionFile = this.getRevisionFile();
            List<Object> changes = revisionFile.exists() ? ((previousRevision = (StarTeamRevision)((Object)BeanUtils.readFile((File)revisionFile, (MigrationListener)new MigrationListener.NoMigration(), StarTeamRevision.class))).equals((Object)(baseRevision = (StarTeamRevision)this.proxy.getBaseRevision())) ? this.proxy.getChanges() : this.proxy.getChangesBetween(previousRevision, revision)) : this.proxy.getChanges();
            for (Changeset changeset : changes) {
                for (Modification modification : changeset.getModifications()) {
                    if (modification.getAction() != Modification.Action.DELETE) continue;
                    File localFile = this.getCheckoutFile(modification.getPath());
                    Validate.notNull((Object)localFile);
                    if (!localFile.exists()) continue;
                    if (localFile.isDirectory()) {
                        Context.getLogger().debug("Removing directory '" + localFile.getAbsolutePath() + "'...");
                        FileUtils.deleteDir((File)localFile);
                        continue;
                    }
                    Context.getLogger().debug("Removing file '" + localFile.getAbsolutePath() + "'...");
                    FileUtils.deleteFile((File)localFile);
                }
            }
            BeanUtils.writeFile((Object)((Object)revision), (File)this.getRevisionFile());
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    private File getRevisionFile() {
        return new File(this.getDestDir(), this.proxy.getName() + ".revision");
    }

    File getCheckoutFile(String repositoryPath) {
        if (this.getSrcPath() != null) {
            String relativePath = FileUtils.getRelativePath((String)repositoryPath, (String)this.getSrcPath());
            if (relativePath != null) {
                return new File(this.getDestDir(), relativePath);
            }
            return null;
        }
        return new File(this.getDestDir(), repositoryPath);
    }

    private String getRepositoryPath(File checkoutFile) {
        String relativePath;
        try {
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getDestDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((String)relativePath)) {
            return null;
        }
        if (this.getSrcPath() == null) {
            return relativePath.substring(1);
        }
        return StringUtils.strip((String)this.getSrcPath().replace('\\', '/'), (String)"/") + relativePath;
    }

    String getRepositoryPath(String checkoutPath) {
        return this.getRepositoryPath(new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath));
    }

    File getDestDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getDestPath());
    }

    private List<Changeset> getChangesBetween(View view, StarTeamRevision startRevision, StarTeamRevision endRevision) {
        if (startRevision.getView() != null && endRevision.getView() != null && !startRevision.getView().equals(endRevision.getView())) {
            Context.getLogger().warn("Changes can not be calculated between different views.");
            return new ArrayList<Changeset>();
        }
        ArrayList<FlatChange> flatChanges = new ArrayList<FlatChange>();
        View oldSnapshot = this.getSnapshot(view, startRevision);
        Folder oldSrcFolder = this.getSrcFolder(oldSnapshot);
        Context.getLogger().info("Caching item props of checkout folder tree of previous build...");
        this.cacheItemProps(oldSrcFolder);
        oldSrcFolder.setAlternatePathFragment(this.getDestDir().getAbsolutePath());
        View newSnapshot = this.getSnapshot(view, endRevision);
        Folder newSrcFolder = this.getSrcFolder(newSnapshot);
        Context.getLogger().info("Caching item props of checkout folder tree of current build...");
        this.cacheItemProps(newSrcFolder);
        newSrcFolder.setAlternatePathFragment(this.getDestDir().getAbsolutePath());
        HashMap<String, Item> oldNodes = new HashMap<String, Item>();
        Context.getLogger().info("Populating checkout folder tree of previous build...");
        this.populateTreeNodes(oldSrcFolder, oldNodes);
        HashMap<String, Item> newNodes = new HashMap<String, Item>();
        Context.getLogger().info("Populating checkout folder tree of current build...");
        this.populateTreeNodes(newSrcFolder, newNodes);
        Context.getLogger().info("Comparing checkout folder tree between previous build and current build...");
        for (Map.Entry newEntry : newNodes.entrySet()) {
            String path = (String)newEntry.getKey();
            Item newNode = (Item)newEntry.getValue();
            Item oldNode = (Item)oldNodes.get(path);
            if (oldNode != null) {
                oldNodes.remove(path);
                if (oldNode.getItemID() != newNode.getItemID()) {
                    flatChanges.addAll(this.processAddition(path, newNode));
                    continue;
                }
                if (!(newNode instanceof com.starbase.starteam.File)) continue;
                com.starbase.starteam.File newFile = (com.starbase.starteam.File)newNode;
                com.starbase.starteam.File oldFile = (com.starbase.starteam.File)oldNode;
                int oldVersion = oldFile.getContentVersion();
                int newVersion = newFile.getContentVersion();
                if (newVersion <= oldVersion) continue;
                HashSet<Integer> versions = new HashSet<Integer>();
                for (Item item : newFile.getHistory()) {
                    com.starbase.starteam.File file = (com.starbase.starteam.File)item;
                    int version = file.getContentVersion();
                    if (version <= oldVersion || version > newVersion || versions.contains(version)) continue;
                    versions.add(version);
                    FlatChange change = new FlatChange();
                    change.setAction(Modification.Action.MODIFY);
                    change.setComment(file.getComment());
                    change.setDate(file.getModifiedTime().createDate());
                    change.setEdition(String.valueOf(version));
                    change.setPreviousEdition(String.valueOf(version - 1));
                    change.setPath(this.getRepositoryPath(new File(path)));
                    User user = file.getServer().getUser(file.getModifiedBy());
                    if (user != null) {
                        String logonName = this.getUserInfo().getId2logon().get(user.getID());
                        if (logonName != null) {
                            change.setUser(logonName);
                        } else {
                            change.setUser(user.getName());
                        }
                    }
                    flatChanges.add(change);
                }
                continue;
            }
            flatChanges.addAll(this.processAddition(path, newNode));
        }
        for (Map.Entry entry : oldNodes.entrySet()) {
            flatChanges.addAll(this.processDeletion((String)entry.getKey(), (Item)entry.getValue(), newSnapshot));
        }
        return FlatChange.aggregate(flatChanges);
    }

    private List<FlatChange> processAddition(String path, Item addItem) {
        ArrayList<FlatChange> changes = new ArrayList<FlatChange>();
        if (addItem instanceof com.starbase.starteam.File) {
            for (Item item : addItem.getHistory()) {
                com.starbase.starteam.File histFile = (com.starbase.starteam.File)item;
                int version = histFile.getContentVersion();
                FlatChange change = new FlatChange();
                change.setComment(histFile.getComment());
                change.setDate(histFile.getModifiedTime().createDate());
                change.setEdition(String.valueOf(version));
                change.setPath(this.getRepositoryPath(new File(path)));
                User user = addItem.getServer().getUser(histFile.getModifiedBy());
                if (user != null) {
                    String logonName = this.getUserInfo().getId2logon().get(user.getID());
                    if (logonName != null) {
                        change.setUser(logonName);
                    } else {
                        change.setUser(user.getName());
                    }
                }
                if (version == 1) {
                    change.setAction(Modification.Action.ADD);
                } else {
                    change.setPreviousEdition(String.valueOf(version - 1));
                    change.setAction(Modification.Action.MODIFY);
                }
                changes.add(change);
            }
        } else {
            FlatChange change = new FlatChange();
            change.setComment(addItem.getComment());
            change.setPath(this.getRepositoryPath(new File(path)));
            change.setDate(addItem.getModifiedTime().createDate());
            User user = addItem.getServer().getUser(addItem.getModifiedBy());
            if (user != null) {
                String logonName = this.getUserInfo().getId2logon().get(user.getID());
                if (logonName != null) {
                    change.setUser(logonName);
                } else {
                    change.setUser(user.getName());
                }
            }
            change.setAction(Modification.Action.ADD);
            changes.add(change);
        }
        return changes;
    }

    private List<FlatChange> processDeletion(String path, Item deleteItem, View newSnapshot) {
        User user;
        ArrayList<FlatChange> changes = new ArrayList<FlatChange>();
        FlatChange change = new FlatChange();
        change.setAction(Modification.Action.DELETE);
        Server server = deleteItem.getServer();
        Item disembodiedItem = newSnapshot.getDisembodiedItem(deleteItem.getItemID(), deleteItem.getType());
        if (disembodiedItem != null) {
            user = server.getUser(disembodiedItem.getDeletedUserID());
            if (user == null) {
                user = server.getUser(disembodiedItem.getModifiedBy());
            }
        } else {
            user = server.getUser(deleteItem.getModifiedBy());
        }
        if (user != null) {
            String logonName = this.getUserInfo().getId2logon().get(user.getID());
            if (logonName != null) {
                change.setUser(logonName);
            } else {
                change.setUser(user.getName());
            }
        }
        change.setPath(this.getRepositoryPath(new File(path)));
        change.setComment("Deleted item '" + change.getPath() + "'.");
        changes.add(change);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Changeset> getChangesBetween(StarTeamRevision startRevision, StarTeamRevision endRevision) {
        View view = null;
        try {
            view = this.openView();
            List<Changeset> list = this.getChangesBetween(view, startRevision, endRevision);
            return list;
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    private void populateTreeNodes(Folder folder, Map<String, Item> nodes) {
        nodes.put(folder.getPath(), (Item)folder);
        folder.getServer().getTypeNames().getClass();
        for (Item item : folder.getItems("File")) {
            nodes.put(((com.starbase.starteam.File)item).getFullName(), item);
        }
        if (this.isRecursive()) {
            for (Item item : folder.getSubFolders()) {
                this.populateTreeNodes((Folder)item, nodes);
            }
        }
    }

    StarTeamRevision getHeadRevision() {
        StarTeamRevision revision = new StarTeamRevision();
        revision.setView(this.getViewName());
        if (this.getLabelName() != null) {
            revision.setLabel(this.getLabelName());
        } else {
            revision.setDate(this.getServerDate());
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void labelOnRevision(StarTeamRevision revision, String label, String comment) {
        View view = null;
        try {
            view = this.openView();
            this.labelOnRevision(view, revision, label, comment);
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    private void labelOnRevision(View view, StarTeamRevision revision, String label, String comment) {
        if (view.getConfiguration().isTip()) {
            if (revision.getLabel() != null) {
                view.cloneViewLabel(this.getLabel(view, revision.getLabel()), label, comment, true, false);
            } else {
                view.createViewLabel(label, comment, new OLEDate(revision.getDate()), true, false);
            }
        } else {
            throw new QuickbuildException("Can not create label on view with a non-tip configuration");
        }
        revision.setLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get label attached to specified promote state.")
    public String getPromotionStateLabel(String promotionStateName) {
        View view = null;
        try {
            view = this.openView();
            String string = this.getPromotionStateLabel(view, promotionStateName);
            return string;
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    private PromotionState getPromotionState(View view, String promotionStateName) {
        for (PromotionState state : view.getPromotionModel().getPromotionStates()) {
            if (!state.getName().equals(promotionStateName)) continue;
            return state;
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Promotion state not found", (Object[])new Object[]{"view", this.getViewUrlDescription(), "promotion state", promotionStateName}));
    }

    private String getPromotionStateLabel(View view, String promotionStateName) {
        PromotionState state = this.getPromotionState(view, promotionStateName);
        if (state.getLabelID() == -1) {
            return null;
        }
        Label[] allLabels = view.fetchAllLabels();
        for (int j = 0; j < allLabels.length; ++j) {
            Label label = allLabels[j];
            if (label.getID() != state.getLabelID()) continue;
            return label.getName();
        }
        throw new QuickbuildException("Can not find label with ID '" + state.getLabelID() + "'.");
    }

    private void promoteLabel(View view, String labelName, String promotionStateName) {
        Label label = this.getLabel(view, labelName);
        PromotionState state = this.getPromotionState(view, promotionStateName);
        state.setLabelID(label.getID());
        view.getPromotionModel().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promoteLabel(String labelName, String promotionStateName) {
        View view = null;
        try {
            view = this.openView();
            this.promoteLabel(view, labelName, promotionStateName);
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }

    public boolean isQuietSince(Date date) {
        if (this.getLabelName() == null) {
            Date serverDate = this.getServerDate();
            if (date.before(serverDate)) {
                StarTeamRevision sinceRevision = new StarTeamRevision();
                sinceRevision.setView(this.getViewName());
                sinceRevision.setDate(date);
                StarTeamRevision currentRevision = new StarTeamRevision();
                currentRevision.setView(this.getViewName());
                currentRevision.setDate(serverDate);
                return this.getChangesBetween(sinceRevision, currentRevision).isEmpty();
            }
            Context.getLogger().warn("Can not determine if repository is quiet as clock of StarTeam server and QuickBuild server is not synchronized.");
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getServerDate() {
        Project project = null;
        try {
            project = StarTeamFinder.openProject((String)this.getProjectUrl(this.getUserName(), this.getPassword()));
            Server server = project.getServer();
            if (server.getSupportedFeatures().hasCurrentTime()) {
                Date date = server.getCurrentTime().createDate();
                return date;
            }
            project.getDefaultView().getServer().getTypeNames().getClass();
            Topic newItem = (Topic)Item.createItem((String)"Topic", (Folder)project.getDefaultView().getRootFolder());
            newItem.update();
            newItem.remove();
            newItem.update();
            Date date = new Date(newItem.getCreatedTime().createDate().getTime() - 1000L);
            return date;
        }
        finally {
            if (project != null) {
                project.getServer().disconnect();
            }
        }
    }

    private void populateUserInfo(Server server, StarTeamRepositoryProxy.UserInfo userInfo) {
        try {
            ServerAdministration serverAdmin = server.getAdministration();
            UserAccount[] userAccounts = serverAdmin.getUserAccounts();
            for (int i = 0; i < userAccounts.length; ++i) {
                UserAccount userAccount = userAccounts[i];
                userInfo.getId2logon().put(userAccount.getID(), userAccount.getLogOnName());
                if (!StringUtils.isNotBlank((String)userAccount.getEmailAddress())) continue;
                userInfo.getLogon2email().put(userAccount.getLogOnName(), userAccount.getEmailAddress());
            }
        }
        catch (ServerException e) {
            Context.getLogger().warn("Can not retrieve user detail info.", (Throwable)e);
            Context.getLogger().warn("Due to above error, change set of repository '{}' will contain user full name instead of logon name.", (Object)this.proxy.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StarTeamRepositoryProxy.UserInfo getUserInfo() {
        if (this.proxy.getUserInfo() == null) {
            this.proxy.setUserInfo(new StarTeamRepositoryProxy.UserInfo());
            View view = null;
            try {
                view = this.openView();
                this.populateUserInfo(view.getServer(), this.proxy.getUserInfo());
            }
            finally {
                if (view != null) {
                    view.getServer().disconnect();
                    view = null;
                }
            }
        }
        return this.proxy.getUserInfo();
    }

    public String getEmail(String committer) {
        return this.getUserInfo().getLogon2email().get(committer);
    }

    void cacheItemProps(Folder folder) {
        PropertyNames pn = folder.getServer().getPropertyNames();
        String[] stringArray = new String[8];
        pn.getClass();
        stringArray[0] = "Name";
        pn.getClass();
        stringArray[1] = "Path";
        pn.getClass();
        stringArray[2] = "Status";
        pn.getClass();
        stringArray[3] = "ModifiedUserID";
        pn.getClass();
        stringArray[4] = "ModifiedTime";
        pn.getClass();
        stringArray[5] = "Modified";
        pn.getClass();
        stringArray[6] = "ContentVersion";
        pn.getClass();
        stringArray[7] = "Comment";
        String[] props = stringArray;
        folder.getServer().getTypeNames().getClass();
        folder.populateNow("File", props, -1);
    }
}

